/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.AccessBacnetUtil;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessFloor;
import com.tridiumx.accessDriver.BAccessNetwork;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BStatusFaultAlgorithm;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BFormat;
import javax.baja.util.Version;

public abstract class AccessNetworkUpgrade {
    public static final Version phaseI = new Version("1.0");
    public static final Version phaseII = new Version("1.1");
    public static final Version phaseIII = new Version("2.0");
    public static final Version phaseIV = new Version("2.1");
    public static final Version phaseV;
    public static final Version CURRENT_NETWORK_VERSION;

    public static void upgrade(BAccessNetwork network, Version oldVersion, Version newVersion) throws Exception {
        BOrd bqlQuery;
        String bql;
        String accessNetwork;
        if (phaseII.compareTo(oldVersion) > 0) {
            network.getLog().message("Starting Access Network Upgrade from " + phaseI + " to " + phaseII + " ...");
            AccessBacnetUtil.removeBacnetTable();
            accessNetwork = "station:|slot:/Drivers/AccessNetwork";
            bql = "|bql:select * from accessDriver:Access2ReaderPoints stop";
            bqlQuery = BOrd.make((String)(accessNetwork + bql));
            AccessBacnetUtil.rebuildBacnetTable();
            network.set("networkVersion", (BValue)BString.make((String)phaseII.toString()));
            network.getLog().message("Upgrade from " + phaseI + " to " + phaseII + " complete.");
        }
        if (phaseIII.compareTo(oldVersion) > 0) {
            network.getLog().message("Starting Access Network Upgrade from " + phaseII + " to " + phaseIII + " ...");
            accessNetwork = "station:|service:accessDriver:AccessNetwork";
            bql = "|bql:select * from control:BooleanWritable stop";
            bqlQuery = BOrd.make((String)(accessNetwork + bql));
            TableCursor points = ((BITable)bqlQuery.resolve().get()).cursor();
            while (points.next()) {
                BBooleanWritable point = (BBooleanWritable)points.get();
                BLink[] links = point.getLinks((Slot)BBooleanWritable.in10);
                for (int j = 0; j < links.length; ++j) {
                    BLink link = links[j];
                    BComponent c = null;
                    try {
                        c = link.getSourceComponent();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!c.getType().toString().equals("kitControl:AlarmCountToRelay")) continue;
                    Slot slot = link.getSourceSlot();
                    point.remove(link.getPropertyInParent());
                    link.setTargetSlotName(BBooleanWritable.in15.getName());
                    LinkCheck check = point.checkLink(c, slot, (Slot)BBooleanWritable.in15, null);
                    if (check.isValid()) {
                        link = point.makeLink(c, slot, (Slot)BBooleanWritable.in15, null);
                        point.add(null, (BValue)link);
                    }
                    network.getLog().message("AccessRelay link slot corrected: " + c.getSlotPath() + " to " + point.getSlotPath());
                }
            }
            network.set("networkVersion", (BValue)BString.make((String)phaseIII.toString()));
            network.getLog().message("Upgrade to " + phaseIII + " complete.");
        }
        if (phaseIV.compareTo(oldVersion) > 0) {
            network.getLog().message("Starting Access Network Upgrade from " + phaseIII + " to " + phaseIV + " ...");
            accessNetwork = "station:|service:accessDriver:AccessNetwork";
            bql = "|bql:select * from accessDriver:AccessElevator stop";
            bqlQuery = BOrd.make((String)(accessNetwork + bql));
            TableCursor elevators = ((BITable)bqlQuery.resolve().get()).cursor();
            while (elevators.next()) {
                BAccessElevator elevator = (BAccessElevator)elevators.get();
                Property p = elevator.getProperty("floorEnabledSchedule");
                if (p == null) continue;
                BAccessFloor[] floors = (BAccessFloor[])elevator.getChildren(BAccessFloor.class);
                for (int j = 0; j < floors.length; ++j) {
                    floors[j].setLogScheduleActivity(elevator.getLogScheduleActivity());
                }
                BLink[] links = elevator.getLinks((Slot)p);
                if (links.length > 0 && links[0].getSourceComponent() instanceof BBooleanSchedule) {
                    BBooleanSchedule schedule = (BBooleanSchedule)links[0].getSourceComponent();
                    for (int j = 0; j < floors.length; ++j) {
                        Property floorProp = floors[j].getPropertyInParent();
                        if (!Flags.isUserDefined1((BComplex)elevator, (Slot)floorProp)) continue;
                        LinkCheck check = floors[j].checkLink((BComponent)schedule, (Slot)BBooleanSchedule.out, (Slot)BAccessFloor.enabledSchedule, null);
                        if (check.isValid()) {
                            BLink link = floors[j].makeLink((BComponent)schedule, (Slot)BBooleanSchedule.out, (Slot)BAccessFloor.enabledSchedule, null);
                            floors[j].add(null, (BValue)link);
                        }
                        elevator.setFlags((Slot)floorProp, elevator.getFlags((Slot)floorProp) & 0xEFFFFFFF);
                    }
                }
                if (p == null) continue;
                elevator.remove(p.getName());
            }
            network.set("networkVersion", (BValue)BString.make((String)phaseIV.toString()));
            network.getLog().message("Upgrade to " + phaseIV + " complete.");
        }
        if (phaseV.compareTo(oldVersion) > 0) {
            network.getLog().message("Starting Access Network Upgrade from " + phaseIV + " to " + phaseV + " ...");
            accessNetwork = "station:|service:accessDriver:AccessNetwork";
            bql = "|bql:select * from accessDriver:AccessAlarmSourceExt stop";
            bqlQuery = BOrd.make((String)(accessNetwork + bql));
            TableCursor c = ((BITable)bqlQuery.resolve().get()).cursor();
            while (c.next()) {
                AccessNetworkUpgrade.upgradeAlarmSourceExt(((BComponent)c.get()).asComponent(), network);
            }
            bql = "|bql:select * from accessDriver:SecAlarmSourceInfo stop";
            bqlQuery = BOrd.make((String)(accessNetwork + bql));
            c = ((BITable)bqlQuery.resolve().get()).cursor();
            while (c.next()) {
                AccessNetworkUpgrade.upgradeAlarmSourceExt(((BComponent)c.get()).asComponent(), network);
            }
            network.set("networkVersion", (BValue)BString.make((String)newVersion.toString()));
            network.getLog().message("Upgrade to " + newVersion + " complete.");
        }
    }

    public static void upgradeAlarmSourceExt(BComponent alarmSourceExt, BAccessNetwork network) {
        BFormat format = (BFormat)alarmSourceExt.get("sourceName");
        if (format.toString().startsWith("%") && format.toString().endsWith("%")) {
            network.setSourceName(alarmSourceExt);
        }
    }

    public static void upgradeFaultExt(BControlPoint oldPoint, BControlPoint newPoint) {
        BAlarmSourceExt faultExt = (BAlarmSourceExt)oldPoint.get("FaultExt");
        if (faultExt != null) {
            oldPoint.remove("FaultExt");
            newPoint.add("FaultExt", (BValue)faultExt);
        } else {
            faultExt = new BAlarmSourceExt();
            faultExt.setSourceName(BFormat.make((String)"%parent.parent.getDisplayName%.%parent.displayName%"));
            BStatusFaultAlgorithm faultAlgo = new BStatusFaultAlgorithm();
            faultAlgo.setFaultValues(BStatus.fault);
            faultExt.setFaultAlgorithm((BFaultAlgorithm)faultAlgo);
            faultExt.setToFaultText(BFormat.make((String)BAccessNetwork.lex.getText("sdi.toFaultText")));
            faultExt.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("sdi.toNormalText")));
            newPoint.add("FaultExt", (BValue)faultExt);
        }
    }

    static {
        CURRENT_NETWORK_VERSION = phaseV = new Version("2.2");
    }
}

