/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.entsecDriver.BAbstractDoor;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridiumx.accessDriver.AccessBacnetUtil;
import com.tridiumx.accessDriver.AccessContainer;
import com.tridiumx.accessDriver.BAccess2ReaderModule;
import com.tridiumx.accessDriver.BAccessAda;
import com.tridiumx.accessDriver.BAccessBacnetOutput;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessRelay;
import com.tridiumx.accessDriver.BAccessRex;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BRexActivation;
import com.tridiumx.accessDriver.BTimedOverride;
import com.tridiumx.accessDriver.StatusSubscriber;
import com.tridiumx.accessDriver.enums.BOverrideEnum;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import com.tridiumx.accessDriver.points.BIAccessPointDeviceExt;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.control.BBooleanPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.license.Feature;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="instance", type="int", defaultValue="0", flags=69)})
@NiagaraAction(name="manualOverride", parameterType="BTimedOverride", defaultValue="new BTimedOverride()", flags=2048)
public class BAccessDoor
extends BAbstractDoor
implements NrioMessageConst,
AccessContainer,
BIPointFolder,
BIStatus {
    @Generated
    public static final Property status = BAccessDoor.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property instance = BAccessDoor.newProperty((int)69, (int)0, null);
    @Generated
    public static final Action manualOverride = BAccessDoor.newAction((int)2048, (BValue)new BTimedOverride(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAccessDoor.class);
    public static final BIcon ICON = BIcon.std((String)"door.png");
    private boolean skipInit;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public int getInstance() {
        return this.getInt(instance);
    }

    @Generated
    public void setInstance(int v) {
        this.setInt(instance, v, null);
    }

    @Generated
    public void manualOverride(BTimedOverride parameter) {
        this.invoke(manualOverride, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public void stationStarted() {
        StatusSubscriber.initSubscriptions((BComponent)this);
    }

    public void init(BIAccessDevice device, BIAccessPointDeviceExt ext) {
        if (!Sys.isStationStarted() || this.skipInit) {
            return;
        }
        boolean addReader = device instanceof BAccess2ReaderModule;
        boolean readersAvailable = false;
        try {
            if (addReader) {
                AccessPointDeviceExtUtil.checkAdd((BNrioPointDeviceExt)ext, "unknown", (BValue)new BAccessReader(), 0, null, null);
                readersAvailable = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getInstance() == 0) {
            BComponent parent = (BComponent)ext;
            boolean oneFree = true;
            boolean twoFree = true;
            BAccessDoor[] doors = (BAccessDoor[])parent.getChildren(BAccessDoor.class);
            for (int i = 0; i < doors.length; ++i) {
                if (doors[i].getInstance() == 1) {
                    oneFree = false;
                    continue;
                }
                if (doors[i].getInstance() != 2) continue;
                twoFree = false;
            }
            if (oneFree) {
                this.setInstance(1);
            } else if (twoFree) {
                this.setInstance(2);
            }
        }
        if (this.get(SlotPath.escape((String)BAccessNetwork.lex.getText("exitRequest"))) == null) {
            this.add(SlotPath.escape((String)BAccessNetwork.lex.getText("exitRequest")), (BValue)new BAccessRex());
        }
        if (this.get(SlotPath.escape((String)BAccessNetwork.lex.getText("sensor"))) == null) {
            this.add(SlotPath.escape((String)BAccessNetwork.lex.getText("sensor")), (BValue)new BAccessSdi());
        }
        if (this.get(SlotPath.escape((String)BAccessNetwork.lex.getText("strike"))) == null) {
            this.add(SlotPath.escape((String)BAccessNetwork.lex.getText("strike")), (BValue)new BAccessStrike());
        }
        if (readersAvailable) {
            BAccessReader reader = new BAccessReader();
            reader.setAvailableInstance((BPointDeviceExt)ext);
            String instance = "" + reader.getInstance();
            if (this.get(SlotPath.escape((String)BAccessNetwork.lex.getText("reader", new Object[]{instance}))) == null) {
                this.add(SlotPath.escape((String)BAccessNetwork.lex.getText("reader", new Object[]{instance})), (BValue)reader);
            }
        }
    }

    public int getInitialAddress(BBooleanPoint point) {
        int doorInstance = this.getInstance();
        int strikeInstance = 0;
        int sensorInstance = 0;
        int exitRequestInstance = 0;
        if (doorInstance == 1) {
            strikeInstance = 1;
            sensorInstance = 1;
            exitRequestInstance = 2;
        } else if (doorInstance == 2) {
            strikeInstance = 2;
            sensorInstance = 3;
            exitRequestInstance = 4;
        }
        if (point instanceof BAccessStrike) {
            return strikeInstance;
        }
        if (point instanceof BAccessSdi) {
            return sensorInstance;
        }
        if (point instanceof BAccessAda) {
            return 0;
        }
        if (point instanceof BAccessRex) {
            if (((BAccessRex[])this.getChildren(BAccessRex.class)).length > 1) {
                return 0;
            }
            return exitRequestInstance;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value instanceof BAccessReader) {
            AccessPointDeviceExtUtil.checkAdd((BNrioPointDeviceExt)this.getParent(), name, value, flags, facets, context);
            return;
        } else if (value instanceof BAccessStrike) {
            BAccessStrike strike = (BAccessStrike)value;
            if (((BAccessStrike[])this.getChildren(BAccessStrike.class)).length <= 0) return;
            if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "Only 1 Strike per Door allowed");
            Logger.getLogger("AccessNetwork").warning("Only 1 Strike per Door allowed");
            return;
        } else if (value instanceof BAccessSdi) {
            BAccessSdi sensor = (BAccessSdi)value;
            if (((BAccessSdi[])this.getChildren(BAccessSdi.class)).length <= 0) return;
            if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "Only 1 Sensor per Door allowed");
            Logger.getLogger("AccessNetwork").warning("Only 1 Sensor per Door allowed");
            return;
        } else {
            if (!(value instanceof BAccessAda)) return;
            Feature accessControl = Sys.getLicenseManager().getFeature("tridium", "accessControl");
            String ada = accessControl.get("ada");
            if (ada != null) {
                if (!ada.equals("false")) return;
                if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "ADA option is unlicensed");
                Logger.getLogger("AccessNetwork").warning("ADA option is unlicensed");
                return;
            } else {
                if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "ADA option is unlicensed");
                Logger.getLogger("AccessNetwork").warning("ADA option is unlicensed");
            }
        }
    }

    public void doManualOverride(BTimedOverride override, Context cx) {
        if (this.getStrike() == null) {
            throw new IllegalStateException("Strike is required to Manually Override Door");
        }
        BOverrideEnum overrideType = override.getOverrideType();
        BRexActivation rexActivation = new BRexActivation();
        if (overrideType.equals((Object)BOverrideEnum.pickTime)) {
            rexActivation.setTime(override.getDoorOpenTime());
            rexActivation.setEmergencyOverride(true);
        } else if (overrideType.equals((Object)BOverrideEnum.quickOpen)) {
            rexActivation.setTime(BTimedOverride.quickOpenTime);
        } else if (overrideType.equals((Object)BOverrideEnum.openDoorOnce)) {
            rexActivation.setTime(BRelTime.DAY);
        } else if (overrideType.equals((Object)BOverrideEnum.pickLockTime)) {
            this.getStrike().doLockOutSchedule(override.getDoorOpenTime(), cx);
            return;
        }
        rexActivation.setIsManualOverride(true);
        if (override.getOwner().length() > 0) {
            rexActivation.setAuthorization(override.getOwner());
        } else if (cx != null) {
            rexActivation.setAuthorization(BAccessNetwork.lex.getText("userAuthorization", new Object[]{cx.getUser()}));
        }
        this.getStrike().doExitRequest(rexActivation);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue val = this.get(property);
        if (val instanceof BComponent) {
            AccessBacnetUtil.addBacnetPoints((BComponent)val);
            ((BIAccessDevice)this.getDevice()).fixGeneralUsePoints();
        }
        if (val instanceof BAccessReader) {
            BAccessReader reader = (BAccessReader)val;
            reader.initLinks();
        }
    }

    public void descendantsStarted() throws Exception {
        if (this.getParent() instanceof BIAccessPointDeviceExt && ((BIAccessPointDeviceExt)this.getParent()).hasDescendantsStarted()) {
            BComponent[] children = (BComponent[])this.getChildren(BComponent.class);
            for (int i = 0; i < children.length; ++i) {
                BComponent val = children[i];
                AccessBacnetUtil.addBacnetPoints(val);
                if (!(val instanceof BAccessReader)) continue;
                BAccessReader reader = (BAccessReader)val;
                if (reader.getStatus().isFault()) {
                    this.remove(reader.getName());
                    continue;
                }
                reader.initLinks();
            }
            ((BIAccessDevice)this.getDevice()).fixGeneralUsePoints();
        }
    }

    public void checkRemove(Property property, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BValue oldValue = this.get(property);
        if (oldValue instanceof BComponent) {
            String oldName = this.getParent().getParent().getDisplayName(cx) + "." + this.getDisplayName(cx) + "." + property.getDefaultDisplayName(cx);
            AccessBacnetUtil.removeBacnetPoints(oldName);
        }
    }

    public void removed(Property property, BValue oldValue, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (oldValue instanceof BComponent) {
            ((BIAccessDevice)this.getDevice()).fixGeneralUsePoints();
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        AccessPointDeviceExtUtil.renamed((BComponent)this, property, oldName, context);
    }

    public BAccessStrike getStrike() {
        Object[] children = this.getChildren(BAccessStrike.class);
        if (children.length > 0) {
            return (BAccessStrike)((Object)children[0]);
        }
        return null;
    }

    public BAccessRex[] getExitRequests() {
        return (BAccessRex[])this.getChildren(BAccessRex.class);
    }

    public BAccessRelay[] getRelays() {
        return (BAccessRelay[])this.getChildren(BAccessRelay.class);
    }

    public BAccessBacnetOutput[] getBacnetOutputs() {
        return (BAccessBacnetOutput[])this.getChildren(BAccessBacnetOutput.class);
    }

    public BAccessSdi getSensor() {
        Object[] children = this.getChildren(BAccessSdi.class);
        if (children.length > 0) {
            return (BAccessSdi)((Object)children[0]);
        }
        return null;
    }

    public String toStatusString(Context cx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStatus()).append(" ");
        if (this.getStrike() != null) {
            sb.append(((BStatusValue)this.getStrike().get(this.getStrike().getOutProperty())).getValueValue().toString((Context)this.getStrike().getFacets()));
            sb.append(" ");
        }
        if (this.getSensor() != null) {
            sb.append(((BStatusValue)this.getSensor().get(this.getSensor().getOutProperty())).getValueValue().toString((Context)this.getSensor().getFacets()));
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getRecordDisplayName(Context cx) {
        return this.getDisplayName(cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIAccessPointDeviceExt;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("wiresheet:WireSheet");
        return list;
    }

    public BDevice getDevice() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BDevice)) {
            parent = parent.getParent();
        }
        return (BDevice)parent;
    }

    public BPointDeviceExt getDeviceExt() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BPointDeviceExt)) {
            parent = parent.getParent();
        }
        return (BPointDeviceExt)parent;
    }

    public BDeviceNetwork getNetwork() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BDeviceNetwork)) {
            parent = parent.getParent();
        }
        return (BDeviceNetwork)parent;
    }

    public String getDescription(Context cx) {
        return this.getDisplayName(cx);
    }

    public String getDeviceDisplayName(Context cx) {
        return this.getDevice().getDisplayName(cx);
    }

    public String getStatusString(Context cx) {
        return this.toStatusString(cx);
    }

    public Type getProxyExtType() {
        return BAccessProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void skipInit() {
        this.skipInit = true;
    }
}

