/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.BNrioDevice;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;

public class StatusSubscriber
extends Subscriber {
    private final BComponent c;

    public StatusSubscriber(BComponent c) {
        this.c = c;
    }

    public void event(BComponentEvent event) {
        if (!Sys.isStationStarted()) {
            return;
        }
        if (event.getSourceComponent() != this.c && event.getSlot() != null && (event.getSlot().getName().equals("status") || event.getSlot().getName().equals("out"))) {
            StatusSubscriber.updateStatus(this.c);
        } else if (event.getSourceComponent() == this.c && (event.getId() == 2 || event.getId() == 1)) {
            if (event.getId() == 1 && event.getValue() instanceof BComponent) {
                this.subscribe((BComponent)event.getValue());
            }
            if (event.getValue() instanceof BIStatus) {
                StatusSubscriber.updateStatus(this.c);
            }
        }
    }

    public static void initSubscriptions(BComponent c) {
        StatusSubscriber parentSubscriber = new StatusSubscriber(c);
        parentSubscriber.subscribe(c.getParent().getParent().asComponent());
        StatusSubscriber childrenSubscribe = new StatusSubscriber(c);
        childrenSubscribe.subscribe(c, 1);
        StatusSubscriber.updateStatus(c);
    }

    public static void updateStatus(BComponent c) {
        int bits = 0;
        if (c.getParent() != null && c.getParent().getParent() instanceof BNrioDevice) {
            bits |= ((BNrioDevice)c.getParent().getParent()).getStatus().getBits();
        }
        BIStatus[] status = (BIStatus[])c.getChildren(BIStatus.class);
        for (int i = 0; i < status.length; ++i) {
            if (!(status[i] instanceof BComplex)) continue;
            bits |= status[i].getStatus().getBits();
        }
        if (c.get("faultCause") != null && c.get("faultCause").toString().length() > 0) {
            bits |= 2;
        }
        c.set("status", (BValue)BStatus.make((int)bits));
    }
}

