/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BIAccessDriverService;
import com.tridiumx.accessDriver.ValidationInvocation;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Worker;

public class ValidationWorker
extends Worker {
    private final BAccessNetwork network;

    public ValidationWorker(Worker.ITodo todo, BAccessNetwork network) {
        super(todo);
        this.network = network;
    }

    protected void process(Runnable work) throws Exception {
        if (work == null) {
            return;
        }
        ValidationInvocation validationInvocation = (ValidationInvocation)((Object)work);
        long startTicks = validationInvocation.getStartTicks();
        long timeElapsed = Clock.ticks() - startTicks;
        if (timeElapsed < this.network.getValidationTimeout().getMillis()) {
            work.run();
        } else {
            BIAccessDriverService serv = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
            serv.validateBadgeTimeout(validationInvocation.getValidationInfo());
        }
    }

    public void start(ThreadGroup threadGroup, String threadName) {
        threadGroup = new ThreadGroup(threadGroup, threadName);
        super.start(threadGroup, threadName);
        Thread[] gAll = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(gAll);
        for (int i = 0; i < gAll.length; ++i) {
            gAll[i].setPriority(10);
        }
    }
}

