/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.job;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.UnconfiguredModuleReply;
import com.tridiumx.accessDriver.BAccessNetwork;
import java.util.Vector;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAccessLearnDevicesJob
extends BNrioLearnDevicesJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAccessLearnDevicesJob.class);
    private static final String LEARN_NAME_PREFIX = "Device";
    final BAccessNetwork accessNet;
    private int learnCount = 0;
    public static final Logger discoveryLog = Logger.getLogger("AccessNetwork.discovery");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAccessLearnDevicesJob() {
        this.accessNet = null;
    }

    public BAccessLearnDevicesJob(BAccessNetwork net) {
        super((BNrioNetwork)net);
        this.accessNet = net;
    }

    public void run(Context cx) throws Exception {
        if (this.accessNet.getStatus().isFault()) {
            throw new Exception("Discovery cannot be run while the Access Network is in fault");
        }
        if (!this.accessNet.getComm().isCommStarted()) {
            throw new Exception("Error opening and configuring the NrioPlatformService");
        }
        this.logMessage("starting");
        try {
            NrioMessage message = new NrioMessage();
            UnconfiguredModuleReply ucmr = new UnconfiguredModuleReply();
            this.accessNet.initLogicalAddressMap();
            Vector unconfigDevices = new Vector();
            boolean done = false;
            boolean firstRun = true;
            int exceptionCount = 0;
            while (firstRun || unconfigDevices.size() > 0 && !done && this.isAlive()) {
                firstRun = false;
                try {
                    discoveryLog.fine("*** accessNet.discover() called *****");
                    unconfigDevices = this.accessNet.discover();
                    exceptionCount = 0;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    discoveryLog.fine("*** unconfigDevices.size() = " + unconfigDevices.size());
                    for (int i = 0; i < unconfigDevices.size(); ++i) {
                        byte[] data = (byte[])unconfigDevices.elementAt(i);
                        discoveryLog.fine("AccessDiscovery byte[] = " + ByteArrayUtil.toHexString((byte[])data));
                        NrioReceivedMessage receivedMessage = new NrioReceivedMessage(data, data.length, null);
                        NrioInputStream inStream = message.readResponse(receivedMessage);
                        ucmr.readData(inStream);
                        BNrioDevice stationDevice = this.accessNet.getDevice(ucmr.getUid());
                        int setAddress = -1;
                        if (stationDevice == null) {
                            setAddress = this.accessNet.getFreeAddress(ucmr.isReader());
                            if (setAddress < 0) {
                                discoveryLog.fine("************** no free addresses availiable ****************");
                                this.logMessage("no free address is availiable for this module!");
                                this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw((int)ucmr.getModuleType()), ucmr.getUid(), "", "");
                                done = true;
                                continue;
                            }
                            if (this.setAddressAndPing(setAddress, ucmr.getUid(), ucmr.getModuleType()) != 0) {
                                this.accessNet.clearAddressUsed(setAddress);
                                continue;
                            }
                            String version = this.accessNet.readBuildInfo(setAddress);
                            this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw((int)ucmr.getModuleType()), ucmr.getUid(), version, "");
                            continue;
                        }
                        discoveryLog.fine(" ******  discovered device allready in station ******");
                        setAddress = stationDevice.getAddress();
                        if (this.setAddressAndPing(setAddress, ucmr.getUid(), ucmr.getModuleType()) == 0) {
                            if (stationDevice.sendWriteConfig() == 0) {
                                this.accessNet.enablePolling(setAddress);
                            } else {
                                discoveryLog.fine("write config was not Ok");
                            }
                            stationDevice.readBuildInfo();
                            continue;
                        }
                        discoveryLog.fine("Set logical address and Ping was not Ok");
                        this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw((int)ucmr.getModuleType()), ucmr.getUid(), stationDevice.getInstalledVersion(), stationDevice.getDisplayName(null));
                    }
                }
                catch (Exception e) {
                    discoveryLog.fine("*** caught Exception: " + e + " count = " + ++exceptionCount);
                    if (exceptionCount > 10) {
                        done = true;
                    }
                    firstRun = true;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.addExistingDevices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BNrioLearnDeviceEntry[] learnEntries = (BNrioLearnDeviceEntry[])this.getLearnedDevices().getChildren(BNrioLearnDeviceEntry.class);
        for (int i = 0; i < learnEntries.length; ++i) {
            if (!learnEntries[i].getUsedBy().equals("")) continue;
            this.accessNet.sendReset(learnEntries[i].getAddress());
        }
        this.progress(100);
    }

    protected void logMessage(String message) {
        this.log().message(message);
        if (this.accessNet != null) {
            int severity = this.accessNet.getLog().getSeverity();
            this.accessNet.getLog().setSeverity(1);
            this.accessNet.getLog().message("Learn Access Devices Job:" + message);
            this.accessNet.getLog().setSeverity(severity);
        }
    }
}

