/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.messages;

import com.tridium.nrio.messages.NrioInputStream;
import com.tridiumx.accessDriver.messages.ReaderIOStatus;

public class TwoReaderIOStatus {
    protected int sci1;
    protected int sci2;
    protected int sci3;
    protected int sci4;
    protected int sci5;
    protected int ciData;
    protected int firstReadFlag;
    public byte[] reader1Data;
    public byte[] reader2Data;
    protected boolean di1;
    protected boolean di2;
    protected boolean di3;
    protected ReaderIOStatus reader1 = new ReaderIOStatus();
    protected ReaderIOStatus reader2 = new ReaderIOStatus();
    private final boolean newStyle = true;

    public TwoReaderIOStatus() {
    }

    public TwoReaderIOStatus(byte[] data) {
        NrioInputStream in = new NrioInputStream(data);
        this.sci1 = in.readSdi();
        this.sci2 = in.readSdi();
        this.sci3 = in.readSdi();
        this.sci4 = in.readSdi();
        this.sci5 = in.readSdi();
        in.readSdi();
        in.readSdi();
        in.readSdi();
        this.ciData = in.readInt(2);
        this.firstReadFlag = in.readInt(2);
        int r1Size = in.read() & 0xFF;
        if (r1Size > 0 && r1Size != 255) {
            this.reader1Data = in.readBytes(r1Size);
        } else {
            r1Size = 0;
        }
        int r2Size = in.read() & 0xFF;
        if (r2Size > 0 && r2Size != 255) {
            this.reader2Data = in.readBytes(r2Size);
        } else {
            r2Size = 0;
        }
        this.di1 = (this.ciData & 0x100) == 0;
        this.di2 = (this.ciData & 0x200) == 0;
        this.di3 = (this.ciData & 0x400) == 0;
        this.reader1 = new ReaderIOStatus(this.sci1, this.sci2, this.reader1Data);
        this.reader2 = new ReaderIOStatus(this.sci3, this.sci4, this.reader2Data);
    }

    public boolean getDi1() {
        return this.di1;
    }

    public boolean getDi2() {
        return this.di2;
    }

    public boolean getDi3() {
        return this.di3;
    }

    public ReaderIOStatus getReader1() {
        return this.reader1;
    }

    public ReaderIOStatus getReader2() {
        return this.reader2;
    }

    public void setDi1(boolean di1) {
        this.di1 = di1;
    }

    public void setDi2(boolean di2) {
        this.di2 = di2;
    }

    public void setReader1(ReaderIOStatus reader1) {
        this.reader1 = reader1;
    }

    public void setReader2(ReaderIOStatus reader2) {
        this.reader2 = reader2;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TwoReaderIOStatus:");
        sb.append("\n  di1 = " + this.di1);
        sb.append("\n  di2 = " + this.di2);
        sb.append("\n  di3 = " + this.di3);
        sb.append("\n  reader1: ");
        sb.append(this.reader1.toDebugString());
        sb.append("\n  reader2: ");
        sb.append(this.reader2.toDebugString());
        return sb.toString();
    }
}

