/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.nd.point.BNiagaraPointFolder;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nv.NiagaraVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationSlotPath", type="BOrd", defaultValue="BOrd.make(\"slot:points\")", facets={@Facet(value="makeStationSlotPathFacets()")}, override=true), @NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"driver:ProxyConversionFE\"")}), @NiagaraProperty(name="tuningPolicyName", type="String", defaultValue="defaultPolicy")})
public final class BPointTag
extends BNiagaraExportTag {
    @Generated
    public static final Property stationSlotPath = BPointTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:points"), (BFacets)BPointTag.makeStationSlotPathFacets());
    @Generated
    public static final Property conversion = BPointTag.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:ProxyConversionFE"));
    @Generated
    public static final Property tuningPolicyName = BPointTag.newProperty((int)0, (String)"defaultPolicy", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPointTag.class);

    @Generated
    public BProxyConversion getConversion() {
        return (BProxyConversion)this.get(conversion);
    }

    @Generated
    public void setConversion(BProxyConversion v) {
        this.set(conversion, (BValue)v, null);
    }

    @Generated
    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    @Generated
    public void setTuningPolicyName(String v) {
        this.setString(tuningPolicyName, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint;
    }

    @Override
    protected Type getFolderType() {
        return BNiagaraPointFolder.TYPE;
    }

    @Override
    protected void doJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        BStatusNumeric defaultReadValue;
        Type pointType;
        BControlPoint sourcePoint = (BControlPoint)this.getParent();
        sub.subscribe((BComponent)sourcePoint);
        sub.subscribe(sourcePoint.getParent().asComponent());
        if (sourcePoint.getType().is(BNumericPoint.TYPE)) {
            pointType = BNumericPoint.TYPE;
            defaultReadValue = new BStatusNumeric();
        } else if (sourcePoint.getType().is(BBooleanPoint.TYPE)) {
            pointType = BBooleanPoint.TYPE;
            defaultReadValue = new BStatusBoolean();
        } else if (sourcePoint.getType().is(BEnumPoint.TYPE)) {
            pointType = BEnumPoint.TYPE;
            defaultReadValue = new BStatusEnum();
        } else {
            pointType = BStringPoint.TYPE;
            defaultReadValue = new BStatusString();
        }
        final String pointId = sourcePoint.getSlotPathOrd().toString();
        IFilter filter = new IFilter(){

            public boolean accept(Object obj) {
                BControlPoint pnt;
                if (obj instanceof BControlPoint && (pnt = (BControlPoint)obj).getProxyExt() instanceof BNiagaraProxyExt) {
                    BNiagaraProxyExt proxy = (BNiagaraProxyExt)pnt.getProxyExt();
                    return proxy.getPointId().equals(pointId);
                }
                return false;
            }
        };
        BControlPoint point = (BControlPoint)NiagaraVirtualUtil.findInstance((BComponent)this.getTargetParent(), (IFilter)filter, (Type)pointType);
        point.setProxyExt((BAbstractProxyExt)new BNullProxyExt());
        point.set(BControlPoint.facets, (BValue)sourcePoint.getFacets(), cx);
        BNiagaraProxyExt proxyExt = new BNiagaraProxyExt();
        proxyExt.setPointId(pointId);
        proxyExt.setDeviceFacets(sourcePoint.getFacets());
        proxyExt.setConversion(this.getConversion());
        proxyExt.setTuningPolicyName(this.getTuningPolicyName());
        proxyExt.setReadValue((BStatusValue)defaultReadValue);
        point.set(BControlPoint.proxyExt, (BValue)proxyExt, cx);
        String name = point.getName();
        if (name == null) {
            name = BPointTag.getUniqueName(this.getTargetParent(), sourcePoint.getName());
        }
        BPointTag.updateTargetDisplayName(this.getTargetParent(), name, (BComplex)sourcePoint);
        this.addTarget(name, (BComplex)point, cx);
    }
}

