/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DnsQuestion {
    private String qName;
    private int qType;
    private int qClass;
    private static final int PTR_TYPE = 12;
    private static final int SRV_TYPE = 33;
    private static final int IN_CLASS = 1;

    private DnsQuestion() {
        this.qName = "";
        this.qType = 255;
        this.qClass = 255;
    }

    private DnsQuestion(String qName, int qType, int qClass) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
    }

    public static DnsQuestion readQuestion(DataInput in) throws IOException {
        DnsQuestion question = new DnsQuestion();
        question.read(in);
        return question;
    }

    public static DnsQuestion makeQuestion(String qName, int qType, int qClass) {
        DnsQuestion question = new DnsQuestion(qName, qType, qClass);
        return question;
    }

    public static DnsQuestion make_PTR_Question(String qName) {
        return DnsQuestion.makeQuestion(qName, 12, 1);
    }

    public static DnsQuestion make_SRV_Question(String qName) {
        return DnsQuestion.makeQuestion(qName, 33, 1);
    }

    public void read(DataInput in) throws IOException {
        int octet;
        StringBuilder domainNameBuilder = new StringBuilder();
        while ((octet = in.readUnsignedByte()) != 0) {
            int length = octet;
            for (int i = 0; i < length; ++i) {
                domainNameBuilder.append((char)in.readUnsignedByte());
            }
            domainNameBuilder.append(".");
        }
        this.qName = domainNameBuilder.toString();
        this.qType = in.readUnsignedShort();
        this.qClass = in.readUnsignedShort();
    }

    public void write(DataOutput out) throws IOException {
        StringTokenizer st = new StringTokenizer(this.qName, ".");
        while (st.hasMoreTokens()) {
            String label = st.nextToken();
            out.writeByte(label.length());
            out.writeBytes(label);
        }
        out.writeByte(0);
        out.writeShort(this.qType);
        out.writeShort(this.qClass);
    }

    public void read(ByteArrayInputStream in) throws IOException {
        this.read(new DataInputStream(in));
    }

    public void read(byte[] data) throws IOException {
        this.read(new ByteArrayInputStream(data));
    }

    public String geDomainName() {
        return this.qName;
    }

    public int getQueryType() {
        return this.qType;
    }

    public int getQueryClass() {
        return this.qClass;
    }
}

