/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;

public class AxisRtspVideoStreamRequest
extends NHttpRequest {
    private static final String LOW_RES_DEFAULT = "320x240";
    private static final String MEDIUM_RES_DEFAULT = "640x480";
    private static final String HIGH_RES_DEFAULT = "704x480";
    private static final String MPEG4_CODEC = "mpeg4";
    private static final String H264_CODEC = "h264";
    private static final String MJPEG_CODEC = "jpeg";
    private static final Logger log = Logger.getLogger("naxisVideo.AxisRtspVideoStreamRequest");
    BAxisVideoCamera camera;
    BPlaybackParams playbackParams;
    private RtspConnection videoConnection;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;

    public AxisRtspVideoStreamRequest(BIpAddress ipaddress, BAxisVideoCamera camera, BPlaybackParams playbackParams) {
        super(ipaddress);
        this.camera = camera;
        this.playbackParams = playbackParams;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        return "";
    }

    public IVideoStream makeVideoStream() {
        try {
            if (this.videoConnection != null) {
                this.videoConnection.stop();
                this.videoConnection = null;
            }
            if (this.camera.getHostName() != "" && this.camera.getControlPort() != 0 && this.camera.getDataPort() != 0) {
                this.videoConnection = new RtspConnection(this.camera.getHostName(), this.camera.getControlPort(), this.camera.getDataPort(), this.camera.getUseTcpTransport());
            }
            if (this.videoConnection == null) {
                throw new LocalizableRuntimeException("naxisVideo", "Please fill all the credentials");
            }
            String passKey = this.camera.getUpdatedRtspVideoKey();
            this.videoConnection.setAuthorization(this.camera.getRtspUsername(), passKey);
            this.videoConnection.connect(this.getParameterString());
            this.videoConnection.play();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception in makeVideoStream()", e);
            }
            return null;
        }
        return new IVideoStream(){

            public void closeVideoStream() throws IOException {
                try {
                    if (AxisRtspVideoStreamRequest.this.videoConnection != null) {
                        AxisRtspVideoStreamRequest.this.videoConnection.stop();
                    }
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception in closeVideoStream", e);
                }
            }

            public InputStream getInputStream() {
                try {
                    return AxisRtspVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException ioe) {
                    log.log(Level.INFO, "Exception in getInputStream", ioe);
                    throw new BajaRuntimeException((Throwable)ioe);
                }
            }

            public BPlaybackParams getPlaybackParams() {
                return AxisRtspVideoStreamRequest.this.playbackParams;
            }
        };
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }

    public String getParameterString() {
        String parameterString = "";
        BAxisVideoCamera videoCamera = (BAxisVideoCamera)this.getVideoSource();
        String resolution = "resolution=";
        switch (videoCamera.getPreferredResolution().getOrdinal()) {
            case 2: {
                String highRes = videoCamera.getResolutionSettings().getHigh();
                resolution = resolution + (!highRes.equals("") ? highRes : HIGH_RES_DEFAULT);
                break;
            }
            case 1: {
                String mediumRes = videoCamera.getResolutionSettings().getMedium();
                resolution = resolution + (!mediumRes.equals("") ? mediumRes : MEDIUM_RES_DEFAULT);
                break;
            }
            case 0: {
                String lowRes = videoCamera.getResolutionSettings().getLow();
                resolution = resolution + (!lowRes.equals("") ? lowRes : LOW_RES_DEFAULT);
                break;
            }
            default: {
                resolution = resolution + MEDIUM_RES_DEFAULT;
            }
        }
        int compressionOrdinal = videoCamera.getPreferredCompression().getOrdinal();
        String compression = "compression=";
        compression = compressionOrdinal == 0 ? compression + "15" : compression + compressionOrdinal * 33;
        int frameRateOrdinal = videoCamera.getPreferredFrameRate().getOrdinal();
        String frameRate = "fps=" + frameRateOrdinal * 10;
        String videoDecoder = "videocodec=";
        switch (videoCamera.getHighCompressionCodec().getOrdinal()) {
            case 12: {
                videoDecoder = videoDecoder + MPEG4_CODEC;
                break;
            }
            case 27: {
                videoDecoder = videoDecoder + H264_CODEC;
                break;
            }
            default: {
                videoDecoder = videoDecoder + MJPEG_CODEC;
            }
        }
        parameterString = resolution + "&" + compression + "&" + frameRate + "&" + videoDecoder;
        return parameterString;
    }
}

