/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;

public class AxisSubscribeVideoMotionDetectionRequest
extends NHttpRequest {
    private RtspConnection videoConnection;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;
    private BAxisVideoCamera axisVideoCamera = null;
    private BPlaybackParams playbackParams = null;
    private static final Logger logger = Logger.getLogger("naxisVideo.AxisSubscribeVideoMotionDetectionRequest");
    public static final Lexicon LEX = Lexicon.make(AxisSubscribeVideoMotionDetectionRequest.class);

    public AxisSubscribeVideoMotionDetectionRequest(BIpAddress address, BAxisVideoCamera axisVideoCamera, BPlaybackParams playbackParams) {
        super(address);
        this.axisVideoCamera = axisVideoCamera;
        this.playbackParams = playbackParams;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        return "";
    }

    public IVideoStream makeVideoStream() {
        try {
            if (this.videoConnection != null) {
                this.videoConnection.stop();
                this.videoConnection = null;
            }
            if (this.axisVideoCamera.getHostName() != "" && this.axisVideoCamera.getControlPort() != 0 && this.axisVideoCamera.getDataPort() != 0) {
                this.videoConnection = new RtspConnection(this.axisVideoCamera.getHostName(), this.axisVideoCamera.getControlPort(), this.axisVideoCamera.getDataPort(), this.axisVideoCamera.getUseTcpTransport());
            }
            if (this.videoConnection == null) {
                throw new LocalizableRuntimeException("naxisVideo", LEX.getText("fillCredentials"));
            }
            String passKey = this.axisVideoCamera.getUpdatedRtspVideoKey();
            this.videoConnection.setAuthorization(this.axisVideoCamera.getRtspUsername(), passKey);
            this.videoConnection.connect(this.getParameterString());
            this.videoConnection.play();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception in makeVideoStream()", e);
            }
            return null;
        }
        return new IVideoStream(){

            public void closeVideoStream() throws IOException {
                try {
                    if (AxisSubscribeVideoMotionDetectionRequest.this.videoConnection != null) {
                        AxisSubscribeVideoMotionDetectionRequest.this.videoConnection.stop();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception raised on closeVideoStream().", e);
                }
            }

            public InputStream getInputStream() {
                try {
                    return AxisSubscribeVideoMotionDetectionRequest.this.videoConnection.getInputStream();
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Exception raised on getInputStream().", ioe);
                    throw new BajaRuntimeException((Throwable)ioe);
                }
            }

            public BPlaybackParams getPlaybackParams() {
                return AxisSubscribeVideoMotionDetectionRequest.this.playbackParams;
            }
        };
    }

    public void processRtspStream(String responseString) {
        try {
            StringTokenizer st = new StringTokenizer(responseString, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (!line.startsWith("<tt:SimpleItem")) continue;
                if (line.contains("Name=\"active\"") && line.contains("Value=\"0\"")) {
                    this.axisVideoCamera.updateEventPoint("AX Motion Stopped");
                    continue;
                }
                if (!line.contains("Name=\"active\"") || !line.contains("Value=\"1\"")) continue;
                this.axisVideoCamera.updateEventPoint("AX Motion Started");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception raised while processing the response string from motion detection.", e);
        }
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }

    public String getParameterString() {
        return this.axisVideoCamera.getEventListToSubscribe();
    }
}

