/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoResolutionSettings;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.net.UrlConnection;
import javax.baja.sys.BajaRuntimeException;

public class AxisVideoStreamRequest
extends NHttpRequest {
    private UrlConnection videoConnection;
    BAxisVideoCamera camera;
    BPlaybackParams playbackParams;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;

    public AxisVideoStreamRequest(BIpAddress ipaddress, BAxisVideoCamera camera, BPlaybackParams playbackParams) {
        super(ipaddress);
        this.camera = camera;
        this.playbackParams = playbackParams;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuilder urlBuf = this.initUrlRequest();
        BPlaybackParams playbackParams = this.getPlaybackParams();
        this.updateUrlToRequestResolution(urlBuf, playbackParams.getResolution(), this.camera.getResolutionSettings());
        this.updateUrlToRequestFrameRate(urlBuf, playbackParams.getFrameRate());
        return urlBuf.toString();
    }

    public boolean processHttpStream(UrlConnection mostRecentBajaUrlConnection) {
        this.videoConnection = mostRecentBajaUrlConnection;
        return false;
    }

    private StringBuilder initUrlRequest() {
        BAxisVideoCameraDeviceId camId = (BAxisVideoCameraDeviceId)this.camera.getVideoDeviceId();
        StringBuilder buf = new StringBuilder("http://");
        buf.append(camId.getUrlAddress());
        buf.append("/axis-cgi/mjpg/video.cgi?clock=0&date=0");
        return buf;
    }

    private void updateUrlToRequestResolution(StringBuilder urlBuf, BVideoResolutionEnum resolution, BAxisVideoResolutionSettings resolutionSetings) {
        if (resolution == BVideoResolutionEnum.high) {
            String res = resolutionSetings.getHigh();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else if (resolution == BVideoResolutionEnum.medium) {
            String res = resolutionSetings.getMedium();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else if (resolution == BVideoResolutionEnum.low) {
            String res = resolutionSetings.getLow();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else {
            System.out.println(">> Unrecognized Niagara AX video resolution: " + resolution);
        }
        urlBuf.append("&compression=" + this.getAxisVideoCompression());
    }

    private int getAxisVideoCompression() {
        BVideoCompressionEnum desiredCompression = this.getPlaybackParams().getCompression();
        if (desiredCompression == BVideoCompressionEnum.none) {
            return 0;
        }
        if (desiredCompression == BVideoCompressionEnum.low) {
            return 10;
        }
        if (desiredCompression == BVideoCompressionEnum.medium) {
            return 30;
        }
        if (desiredCompression == BVideoCompressionEnum.high) {
            return 80;
        }
        throw new IllegalArgumentException("Requested compression unrecognized: " + desiredCompression);
    }

    private void updateUrlToRequestFrameRate(StringBuilder urlBuf, BVideoFrameRateEnum frameRate) {
        if (frameRate == BVideoFrameRateEnum.high) {
            urlBuf.append("&fps=30");
        } else if (frameRate == BVideoFrameRateEnum.medium) {
            urlBuf.append("&fps=15");
        } else if (frameRate == BVideoFrameRateEnum.low) {
            urlBuf.append("&fps=4");
        } else {
            System.out.println(">> Unrecognized Niagara AX frame rate: " + frameRate);
        }
    }

    public IVideoStream makeVideoStream() {
        return new IVideoStream(){

            public void closeVideoStream() throws IOException {
                AxisVideoStreamRequest.this.videoConnection.close();
            }

            public InputStream getInputStream() {
                try {
                    return AxisVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException ioe) {
                    throw new BajaRuntimeException((Throwable)ioe);
                }
            }

            public BPlaybackParams getPlaybackParams() {
                return AxisVideoStreamRequest.this.playbackParams;
            }
        };
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }
}

