/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.tools;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.SecretChars;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopierOptions;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.list.ListModel;
import javax.baja.util.PatternFilter;

public class StationCopy
implements DaemonSessionTaskListener {
    private static Logger log = Logger.getLogger("platformDaemon.StationCopy");
    private BDaemonSession daemonSession;
    private BDaemonPlatform remotePlatform;
    private StationListModel remoteStations = null;
    private boolean stationPassPhraseRequired;
    private BDirectory stationDir = null;
    private boolean autostartStation = false;
    private boolean startStation = false;
    private SecretChars stationBogPassphrase = null;
    private CommissioningWizardModel wizardModel = null;
    private SessionSurrogates surrogates;

    public StationCopy(BDaemonSession daemonSession, BDaemonPlatform remotePlatform) {
        this.daemonSession = daemonSession;
        this.remotePlatform = remotePlatform;
        try {
            this.surrogates = new SessionSurrogates(daemonSession);
            this.wizardModel = new CommissioningWizardModel(daemonSession, false, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushStationToPlatform(String stationName, BDirectory stationRoot, boolean startStation, boolean autoStartStation, Supplier<char[]> passphraseSupplier) throws ConnectException {
        log.log(Level.FINE, "Entering pushStationToPlatform");
        log.log(Level.FINE, "Installing Station:  " + stationName);
        if (!this.remotePlatform.getNiagaraStationsEnabled()) throw new BajaRuntimeException("Remote host does not support Niagara Stations");
        if (!this.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
            this.deleteRemoteStations();
        } else {
            this.stopAllStations();
        }
        this.startStation = startStation;
        this.autostartStation = autoStartStation;
        if (stationRoot == null) {
            stationRoot = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true));
        }
        if (stationRoot != null) {
            for (BIFile kid : stationRoot.listFiles()) {
                if (!(kid instanceof BDirectory) || !kid.getNavName().equalsIgnoreCase(stationName)) continue;
                BINavNode configBogNode = kid.getNavChild("config.bog");
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path found: " + kid.getFilePath());
                    log.log(Level.FINE, "Bog: " + configBogNode.getNavName());
                }
                if (configBogNode == null) throw new BajaRuntimeException("Unable to locate station Bog.");
                this.stationDir = (BDirectory)kid;
                break;
            }
        }
        if (this.stationDir != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Station Directory is: " + this.stationDir);
            }
            this.wizardModel.setTargetStationName(stationName);
            this.wizardModel.setStationDir(this.stationDir);
            try {
                BDaemonDirectoryStore store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                if (store == null) {
                    DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)SystemFilePaths.getStationsDirPath((boolean)true), (BDaemonFileSpace)this.daemonSession.getFileSpace()), null, (DaemonSessionTaskListener)this);
                    store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                }
                this.wizardModel.setTargetStationsRoot(new BDirectory((BIFileStore)store));
            }
            catch (ConnectException e) {
                throw new BajaRuntimeException("Unable to access remote host station store.");
            }
            BStationCopierOptions stationCopierOptions = BStationCopierOptions.make();
            String fileExcludeList = stationCopierOptions.getFilePatternExcludeList();
            String directoryExcludeList = stationCopierOptions.getDirectoryPatternExcludeList();
            this.wizardModel.setFileExcludePatterns(PatternFilter.parseList((String)fileExcludeList, (String)" "));
            this.wizardModel.setDirectoryExcludePatterns(PatternFilter.parseList((String)directoryExcludeList, (String)" "));
            this.wizardModel.setStationContent(BStationContentEnum.everything);
            ArrayList<BFileInstallable> extraInstallables = new ArrayList<BFileInstallable>();
            for (BIFile file : this.getStationTransferContents()) {
                extraInstallables.add(new BFileInstallable(file, this.getStationDestDir(file.getFilePath())));
            }
            try {
                CertificateChainValidator certValidator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(this.daemonSession));
                DependencyUtil.AnalysisResults analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)this.remotePlatform, (BFileSpace)this.stationDir.getFileSpace(), (FilePath)this.stationDir.getFilePath(), null, (DaemonSessionTaskListener)this, (CertificateChainValidator)certValidator);
                this.wizardModel.setSolution(analysisResults.getSolution().solve(null, null, null, extraInstallables.toArray(new BInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            log.log(Level.FINE, "Station directory not found.");
            throw new BajaRuntimeException("Station Bog not found.");
        }
        this.stationBogPassphrase = passphraseSupplier != null ? new SecretChars(passphraseSupplier.get(), false) : null;
        this.wizardModel.setStationBogPassphrase(this.stationBogPassphrase);
        try {
            BBogFile stationBog = (BBogFile)this.stationDir.getNavChild("config.bog");
            PBEEncodingInfo encodingInfo = stationBog.getPBEEncodingInfo();
            log.log(Level.FINE, "Initializing Station Transfer...");
            Optional<Consumer> initializer = Optional.of(DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)this.daemonSession, Optional.ofNullable(encodingInfo), Optional.ofNullable(this.stationBogPassphrase)));
            this.wizardModel.getSolution().commit((DaemonSessionTaskListener)this, new StoreCache(), null, false, initializer);
            this.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage());
            this.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage(stationName, false, this.startStation, this.autostartStation, true));
            if (this.startStation) {
                BStationSurrogate station = this.getStationSurrogate(stationName, true);
                station.startStation(null, (DaemonSessionTaskListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.log(Level.FINE, "Exiting pushStationToPlatform");
    }

    private BStationSurrogate getStationSurrogate(String name, boolean forceLoad) throws AuthenticationException {
        try {
            return (BStationSurrogate)this.surrogates.get(BStationSurrogate.TYPE, name, forceLoad);
        }
        catch (ConnectException ce) {
            return null;
        }
    }

    private void deleteRemoteStations() throws ConnectException {
        BDirectory remoteStationsRoot = (BDirectory)this.daemonSession.getFileSpace().findFile(SystemFilePaths.getStationsDirPath((BIFileSpace)this.daemonSession.getFileSpace()), BCacheAccessPolicy.forceFetch);
        this.remoteStations = new StationListModel();
        this.remoteStations.loadValue(remoteStationsRoot);
        for (int i = 0; i < this.remoteStations.getItemCount(); ++i) {
            BDirectory dir = this.remoteStations.getDirectoryAt(i);
            this.daemonSession.sendMessage((DaemonMessage)new DeleteStationMessage(dir.getFileName()));
            DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)dir.getFilePath(), (BDaemonFileSpace)this.daemonSession.getFileSpace()), null, (DaemonSessionTaskListener)this);
        }
    }

    private void stopAllStations() throws ConnectException {
        BDirectory remoteStationsRoot = (BDirectory)this.daemonSession.getFileSpace().findFile(SystemFilePaths.getStationsDirPath((BIFileSpace)this.daemonSession.getFileSpace()), BCacheAccessPolicy.forceFetch);
        this.remoteStations = new StationListModel();
        this.remoteStations.loadValue(remoteStationsRoot);
        for (int i = 0; i < this.remoteStations.getItemCount(); ++i) {
            String stationName = this.remoteStations.getDirectoryAt(i).getFileName();
            BStationSurrogate station = this.getStationSurrogate(stationName, true);
            station.stopStation(null, (DaemonSessionTaskListener)this);
        }
    }

    private List<BIFile> getStationTransferContents() {
        ArrayList<BIFile> result = new ArrayList<BIFile>();
        if (this.wizardModel.getStationContent() == BStationContentEnum.selectedDirectories) {
            Iterator i = this.wizardModel.getDirectoryTreeModel().getCheckedDirectories();
            while (i.hasNext()) {
                BIFile[] files;
                BDirectory sd = (BDirectory)i.next();
                for (BIFile file : files = sd.listFiles()) {
                    if (file.isDirectory() || this.ignoreFile(file)) continue;
                    result.add(file);
                }
            }
        } else if (this.wizardModel.getStationContent() == BStationContentEnum.everything) {
            TreeSet<FilePath> exclude = new TreeSet<FilePath>();
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("history"));
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("alarm"));
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("dataRecovery"));
            this.addAllDataFiles(this.wizardModel.getStationDir(), exclude, result);
        } else if (this.wizardModel.getStationContent() == BStationContentEnum.configOnly) {
            result.add((BIFile)this.wizardModel.getStationDir().getNavChild("config.bog"));
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private boolean ignoreFile(BIFile file) {
        for (int i = 0; i < this.wizardModel.getFileExcludePatterns().length; ++i) {
            if (!this.wizardModel.getFileExcludePatterns()[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    private FilePath getStationDestDir(FilePath sourcePath) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "TargetStationsRoot: " + this.wizardModel.getTargetStationsRoot().getNavName());
            log.log(Level.FINE, "TargetStationName : " + this.wizardModel.getTargetStationName());
        }
        FilePath result = this.wizardModel.getTargetStationsRoot().getFilePath().merge(this.wizardModel.getTargetStationName());
        for (int i = this.wizardModel.getStationDir().getFilePath().depth(); i < sourcePath.depth() - 1; ++i) {
            result = result.merge(sourcePath.nameAt(i));
        }
        return result;
    }

    private void addAllDataFiles(BDirectory dir, Set<FilePath> exclude, List<BIFile> result) {
        BIFile[] files;
        for (BIFile file : files = dir.listFiles()) {
            if (exclude.contains(file.getFilePath())) continue;
            if (file.isDirectory()) {
                if (this.ignoreDirectory((BDirectory)file)) continue;
                this.addAllDataFiles((BDirectory)file, exclude, result);
                continue;
            }
            if (this.ignoreFile(file)) continue;
            result.add(file);
        }
    }

    private boolean ignoreDirectory(BDirectory directory) {
        for (int i = 0; i < this.wizardModel.getDirectoryExcludePatterns().length; ++i) {
            if (!this.wizardModel.getDirectoryExcludePatterns()[i].accept((BIFile)directory)) continue;
            return true;
        }
        return false;
    }

    public void taskStarted(DaemonSessionTask task) {
    }

    public void taskUpdated(DaemonSessionTask task) {
    }

    public void taskFinished(DaemonSessionTask task) {
    }

    private class StationListModel
    extends ListModel {
        private final Array<BIFile> list = new Array(BIFile.class);

        private StationListModel() {
        }

        public void loadValue(BDirectory directory) {
            this.list.clear();
            if (directory != null) {
                try {
                    if (directory.getStore() instanceof BDaemonDirectoryStore) {
                        ((BDaemonDirectoryStore)directory.getStore()).reset();
                    }
                    for (BIFile kid : directory.listFiles()) {
                        if (!kid.isDirectory()) continue;
                        BIDirectory kidDirectory = (BIDirectory)kid;
                        for (BIFile kidFile : kidDirectory.listFiles()) {
                            if (!kidFile.getFileName().equals("config.bog")) continue;
                            this.list.add((Object)kid);
                        }
                    }
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.SEVERE, "error loading station list", e);
                }
            }
            this.updateList();
        }

        public int getItemCount() {
            return this.list.size();
        }

        public Object getItem(int row) {
            return this.getDirectoryAt(row).getFileName();
        }

        BDirectory getDirectoryAt(int row) {
            return (BDirectory)this.list.get(row);
        }

        public BImage getItemIcon(int index) {
            return null;
        }
    }
}

