/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.platDaemon.ui.BPlatformConnectionOptions;
import com.tridium.platDaemon.ui.config.BPlatformAdministration;
import com.tridium.platDaemon.ui.config.ChangeDefaultsWizardModel;
import com.tridium.platDaemon.ui.console.BApplicationDirector;
import com.tridium.platDaemon.ui.distinstall.BDistInstaller;
import com.tridium.platDaemon.ui.filetransfer.BFileTransferClient;
import com.tridium.platDaemon.ui.lexiconinstall.BLexiconInstaller;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseManager;
import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManager;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopier;
import com.tridium.platDaemon.ui.tcpip.BTcpIpConfiguration;
import com.tridium.platform.BSessionNavNode;
import com.tridium.platform.BSessionNavNodeFactory;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.CheckDefaultCredentialsMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.license.BrandProps;
import java.io.InputStream;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.kiosk.BKioskProfile;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BDaemonNavNodeFactory
extends BSessionNavNodeFactory {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonNavNodeFactory.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void connect() {
        BDaemonSession session = (BDaemonSession)this.getNavSession();
        BHostProperties sessionHostProperties = session.getHostProperties();
        BWbShell shell = null;
        if (BWbShell.getApplication() != null) {
            for (BWidgetShell widgetShell : BWbShell.getApplication().getShells()) {
                if (!(widgetShell instanceof BWbShell)) continue;
                shell = (BWbShell)widgetShell;
                if (!(shell.getProfile() instanceof BKioskProfile)) break;
                shell = null;
                break;
            }
        }
        if (sessionHostProperties.isNiagara4() && shell != null) {
            boolean factoryDefaultSystemPasswordPresent = false;
            boolean factoryDefaultSystemPasswordCanBeChanged = false;
            boolean factoryDefaultCredentialsPresent = false;
            boolean factoryDefaultCredentialsCanBeRemoved = false;
            BPlatformConnectionOptions platformConnectionOptions = BPlatformConnectionOptions.make();
            if (sessionHostProperties.supportsServlet("systempw") && platformConnectionOptions.getRequireDefaultSystemPassphraseChange()) {
                try {
                    XElem systemPasswordElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
                    factoryDefaultSystemPasswordPresent = systemPasswordElem.getb("default", false);
                    factoryDefaultSystemPasswordCanBeChanged = !systemPasswordElem.getb("readonly", false);
                }
                catch (Exception ignored) {
                    factoryDefaultSystemPasswordPresent = false;
                    factoryDefaultSystemPasswordCanBeChanged = false;
                }
            }
            if (platformConnectionOptions.getRequireDefaultAccountRemoval()) {
                try {
                    XElem userElem;
                    boolean tempDefaultCredentialsPresent = false;
                    XElem authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new CheckDefaultCredentialsMessage(), "text/xml")).parse();
                    XElem authElem = authInfo.elem("auth");
                    if (authElem != null && (userElem = authElem.elem("user")) != null) {
                        tempDefaultCredentialsPresent = userElem.getb("default", false);
                    }
                    if (factoryDefaultCredentialsPresent = tempDefaultCredentialsPresent) {
                        boolean tempFactoryDefaultCredentialsCanBeRemoved = false;
                        boolean authReadonly = false;
                        authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
                        authElem = authInfo.elem("auth");
                        if (authElem != null) {
                            authReadonly = authElem.getb("readonly", false);
                        }
                        if (!authReadonly) {
                            if (sessionHostProperties.supportsServlet("acctmgt")) {
                                tempFactoryDefaultCredentialsCanBeRemoved = true;
                            } else {
                                String currentAuthType;
                                authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new AuthenticationInfoMessage(false), AuthenticationInfoMessage.AUTH_INFO_MESSAGE_TIMEOUT, "text/xml")).parse();
                                authElem = authInfo.elem("auth");
                                if (authElem != null && (currentAuthType = authElem.get("type")) != null) {
                                    tempFactoryDefaultCredentialsCanBeRemoved = DaemonAuthUtil.isFileScheme((String)currentAuthType);
                                }
                            }
                        }
                        factoryDefaultCredentialsCanBeRemoved = tempFactoryDefaultCredentialsCanBeRemoved;
                    }
                }
                catch (Exception ignored) {
                    factoryDefaultCredentialsPresent = false;
                    factoryDefaultCredentialsCanBeRemoved = false;
                }
            }
            if (factoryDefaultSystemPasswordPresent && factoryDefaultSystemPasswordCanBeChanged || factoryDefaultCredentialsPresent && factoryDefaultCredentialsCanBeRemoved) {
                try {
                    ChangeDefaultsWizardModel wizardModel = new ChangeDefaultsWizardModel(session, factoryDefaultCredentialsPresent && factoryDefaultCredentialsCanBeRemoved, factoryDefaultSystemPasswordPresent && factoryDefaultSystemPasswordCanBeChanged, true);
                    BWizard.open((BWidget)shell, (WizardModel)wizardModel);
                    if (wizardModel.isCanceled()) {
                        session.disconnect();
                        throw new ICancelHint.CanceledException();
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ICancelHint.CanceledException) {
                        throw (ICancelHint.CanceledException)t;
                    }
                    BDialog.error((BWidget)shell, (String)this.getLexicon().getText("ChangeDefaultsWizard.generalError.title"), (Object)this.getLexicon().getText("ChangeDefaultsWizard.generalError.message"), (Throwable)t);
                }
            }
        }
        boolean localNiagaraHome = session.usesLocalNiagaraHome();
        boolean localNiagaraUserHome = session.usesLocalNiagaraUserHome();
        Array resultArray = new Array(BSessionNavNode.class);
        resultArray.add((Object)new BSessionNavNode((BISession)session, BPlatformAdministration.TYPE));
        resultArray.add((Object)new BSessionNavNode((BISession)session, BApplicationDirector.TYPE));
        resultArray.add((Object)new BSessionNavNode((BISession)session, BLicenseManager.TYPE));
        resultArray.add((Object)new BSessionNavNode((BISession)session, BTcpIpConfiguration.TYPE));
        if (!sessionHostProperties.getIsNiagaraHomeReadonly()) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, BLexiconInstaller.TYPE));
        }
        if (!localNiagaraHome) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, BDistInstaller.TYPE));
        }
        if (!localNiagaraHome) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, BFileTransferClient.TYPE));
        }
        if (!localNiagaraHome) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, BSoftwareManager.TYPE));
        }
        if (!localNiagaraUserHome && !Boolean.parseBoolean(BrandProps.getLocalInstance().get("platform.disableStationCopy", "false"))) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, BStationCopier.TYPE));
        }
        if (sessionHostProperties.supportsServlet("crypto")) {
            resultArray.add((Object)new BSessionNavNode((BISession)session, Sys.getType((String)"platCrypto:CertManagerView")));
        }
        this.setNavNodes((BSessionNavNode[])resultArray.trim());
    }
}

