/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.acctmgt.PasswdCommentController;
import com.tridium.platDaemon.ui.acctmgt.QnxUserNameController;
import com.tridium.platform.daemon.message.CheckUserMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.ui.util.LabelUtil;
import java.security.AccessController;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BAddUserDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BAddUserDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BAddUserDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAddUserDialog.class);
    BNativeUserTable userTable;
    BTextField nameField;
    BTextField commentField;
    BWbFieldEditor passwordFE1;
    BWbFieldEditor passwordFE2;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    protected BButton okButton;
    protected BButton cancelButton;
    private UserAccount response = null;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static UserAccount open(BNativeUserTable table, String title) {
        BAddUserDialog dialog = new BAddUserDialog(table, title);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getUserAccount();
    }

    private BAddUserDialog(BNativeUserTable table, String title) {
        super((BWidget)table, title, true);
        this.userTable = table;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        this.okButton.setEnabled(true);
    }

    private BWidget buildDialog() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane);
    }

    private BWidget buildBody() {
        BGridPane grid = new BGridPane(2);
        this.nameField = new BTextField("", 20);
        this.commentField = new BTextField("", 20);
        this.passwordFE1 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
        this.passwordFE2 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.name"), (BWidget)this.nameField);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.password"), (BWidget)this.passwordFE1);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.password2"), (BWidget)this.passwordFE2);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.comment"), (BWidget)this.commentField);
        if (this.userTable.session.getHostProperties().getOsName().startsWith("qnx-jace") || this.userTable.session.getHostProperties().getOsName().startsWith("tridium-qnx7")) {
            this.nameField.setController((TextController)new QnxUserNameController());
        }
        this.commentField.setController((TextController)new PasswdCommentController());
        return grid;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.okButton.setPreferredSize(50.0, this.okButton.getPreferredHeight());
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.cancelButton.setPreferredSize(50.0, this.cancelButton.getPreferredHeight());
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public UserAccount getUserAccount() {
        return this.response;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword pw2;
        BPassword pw1;
        String comment;
        String fullyQualifiedName;
        block15: {
            block14: {
                int i;
                String accountName = this.nameField.getText().trim();
                if (accountName.length() == 0) {
                    BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.nameRequired"));
                    return;
                }
                if (!NativeAccount.isAccountNameFullyQualified((String)accountName)) {
                    fullyQualifiedName = this.userTable.group.getDomain() + "\\" + accountName;
                } else {
                    fullyQualifiedName = accountName;
                    accountName = NativeAccount.fullyQualifiedToUsername((String)accountName);
                }
                comment = this.commentField.getText().trim();
                if (BNativeUserTable.isReserved(accountName)) {
                    BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.userReserved", new Object[]{accountName}));
                    return;
                }
                for (i = 0; i < this.userTable.getUserModel().getRowCount(); ++i) {
                    if (!this.userTable.getUserModel().getUser(i).getAccountName().equals(accountName)) continue;
                    BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.userAlreadyExists", new Object[]{accountName}));
                    return;
                }
                if (this.userTable.getUserModel().getRowCount() == 20) {
                    BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.tooManyUsers", new Object[]{20}));
                    return;
                }
                for (i = 0; i < comment.length(); ++i) {
                    char c = comment.charAt(i);
                    if (!"-=+()@._ ".contains(String.valueOf(c)) && !Character.isLetterOrDigit(c)) {
                        BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.invalidCommentCharacter", new Object[]{String.valueOf(c)}));
                        return;
                    }
                    if (i < 64) continue;
                    BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.commentTooLong"));
                    return;
                }
                pw1 = (BPassword)this.passwordFE1.saveValue();
                pw2 = (BPassword)this.passwordFE2.saveValue();
                if (pw1 == null) break block14;
                if (AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()).trim().length() == 0 || pw2 == null) break block14;
                if (AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()).trim().length() != 0) break block15;
            }
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.passwordRequired"));
            return;
        }
        BPasswordStrength passwordStrength = FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.userTable.fipsModeSelected(), this.userTable.session);
        if (!BNativeUserTable.validatePassword((BWidget)this.userTable, pw1, passwordStrength)) {
            return;
        }
        UserAccount userAccount = new UserAccount(fullyQualifiedName, null, comment, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (int)0));
        if (!BNativeUserTable.checkStatus(null, this.userTable.session, (XmlResponseMessage)new CheckUserMessage(userAccount, this.userTable.session.generateSharedSecretKey("addUser_check")))) {
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.invalidUserPasswordDefault"));
            return;
        }
        if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()))) {
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.passwordMismatch"));
            return;
        }
        this.response = new UserAccount(fullyQualifiedName, null, comment, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (int)0));
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.response = null;
        this.close();
    }
}

