/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.InstallScenario;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddSubscriptionModeMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.IUserUpdate;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.daemon.message.ReloadLicenseModeMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.UpdateFileAuthenticationMessage;
import com.tridium.platform.daemon.message.UpdateNativeAuthenticationMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.platform.ui.util.AuditUtil;
import com.tridium.sys.license.dom.LicenseDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class FinishPane
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private String lastText = null;
    private CommissioningWizardModel wizardModel;
    private TaskDetailPane.TaskItem stopAppsItem;
    private TaskDetailPane.TaskItem deleteStationsItem;
    private TaskDetailPane.TaskItem installItem;
    private TaskDetailPane.TaskItem tcpItem;
    private TaskDetailPane.TaskItem osInstallItem;
    private TaskDetailPane.TaskItem dateTimeItem;
    private TaskDetailPane.TaskItem systemPasswordItem;
    private TaskDetailPane.TaskItem authChangeItem;
    private TaskDetailPane.TaskItem rebootItem;
    private TaskDetailPane.TaskItem updateDaemonItem;
    private TaskDetailPane.TaskItem startAppItem;
    private TaskDetailPane.TaskItem reconnectItem;
    private TaskDetailPane.TaskItem importFromPlatformItem;
    private TaskDetailPane.TaskItem updateInstallScenarioItem;
    private TaskDetailPane.TaskItem cleanAndUpdateRebootInstallablesItem;
    private TaskDetailPane.TaskItem lowMemoryRebootItem;
    private TaskDetailPane.TaskItem lowMemoryReconnectItem;
    BRemoteModuleList remoteModules;
    List<BDependency> modulesToRestore;
    List<BInstallable> jreAndOsInstallables = new ArrayList<BInstallable>();
    private List<TaskDetailPane.TaskItem> items = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    private FinishPane(CommissioningWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.stopAppsItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.stopApps"));
        this.deleteStationsItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.deleteStations"));
        this.installItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.install"));
        this.tcpItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateTcp"));
        this.osInstallItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.osInstall"));
        this.authChangeItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateAuth"));
        this.systemPasswordItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateSystemPassword"));
        this.dateTimeItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.dateTime"));
        this.rebootItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reboot"));
        this.updateDaemonItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateDaemon"));
        this.startAppItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.startApp"));
        this.reconnectItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reconnect"));
        this.updateInstallScenarioItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.updateInstallScenario"));
        this.importFromPlatformItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.importPlatformModules"));
        this.cleanAndUpdateRebootInstallablesItem = new TaskDetailPane.TaskItem("");
        this.lowMemoryRebootItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reboot"));
        this.lowMemoryReconnectItem = new TaskDetailPane.TaskItem(lex.getText("CommissioningWizard.finish.item.reconnect"));
        this.init(wizardModel.owner);
    }

    public static void openDialog(CommissioningWizardModel wizardModel) {
        new FinishPane(wizardModel).open();
    }

    @Override
    public String getDialogTitle() {
        return lex.getText("CommissioningWizard.title", new Object[]{this.wizardModel.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    @Override
    public String getHeadingTitle() {
        return lex.getText("CommissioningWizard.finish.mainHeading");
    }

    @Override
    public BImage getHeadingIcon() {
        return BImage.make((String)lex.getText("CommissioningWizard.wizard.sectionIcon"));
    }

    @Override
    public String getItemListHeading() {
        return lex.getText("CommissioningWizard.finish.itemHeading");
    }

    @Override
    public TaskDetailPane.TaskItem[] makeTaskItems() {
        boolean mustReboot = false;
        boolean mustStopApps = false;
        boolean mustInstallOs = false;
        boolean mustUpdateDaemon = false;
        this.items = new ArrayList<TaskDetailPane.TaskItem>();
        if (!this.wizardModel.skipAuth && (this.wizardModel.authUsersChanged || this.wizardModel.authMethodChanged)) {
            this.items.add(this.authChangeItem);
        }
        if (!this.wizardModel.skipSystemPassword && this.wizardModel.newSystemPassword != null && this.wizardModel.oldSystemPassword != null) {
            this.items.add(this.systemPasswordItem);
        }
        if (!this.wizardModel.skipStation && this.wizardModel.stationsToDelete.size() > 0) {
            this.items.add(this.deleteStationsItem);
        }
        if (this.wizardModel.solution.hasChanges()) {
            block36: {
                try {
                    if (this.wizardModel.daemonSession.getHostProperties().getIsNpsdk() || !this.wizardModel.getPlatform().getArchPart().getPartName().contains("ppc")) break block36;
                    boolean rebootAndReconnect = true;
                    try {
                        if (new com.tridium.nre.util.Version(this.wizardModel.daemonSession.getHostProperties().getDaemonVersion()).compareTo((Object)new com.tridium.nre.util.Version("4.3")) >= 0) {
                            rebootAndReconnect = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rebootAndReconnect) {
                        this.items.add(0, this.lowMemoryRebootItem);
                        this.items.add(1, this.lowMemoryReconnectItem);
                    }
                    BInstallable[] installList = this.wizardModel.solution.getToInstall();
                    boolean foundJre = false;
                    boolean foundOs = false;
                    for (BInstallable anInstallList : installList) {
                        if (anInstallList.getPart() instanceof BVmPart) {
                            this.jreAndOsInstallables.add(anInstallList);
                            foundJre = true;
                            if (foundOs) break;
                        }
                        if (!(anInstallList.getPart() instanceof BOsPart)) continue;
                        this.jreAndOsInstallables.add(anInstallList);
                        foundOs = true;
                        if (foundJre) break;
                    }
                    if (foundOs || foundJre) {
                        this.cleanAndUpdateRebootInstallablesItem.description = foundOs && !foundJre ? lex.getText("CommissioningWizard.finish.item.updatePlatformOsAndReboot") : (!foundOs ? lex.getText("CommissioningWizard.finish.item.updatePlatformJvmAndReboot") : lex.getText("CommissioningWizard.finish.item.updatePlatformOsAndJvmAndReboot"));
                        this.items.add(this.importFromPlatformItem);
                        this.items.add(this.cleanAndUpdateRebootInstallablesItem);
                        this.items.add(this.reconnectItem);
                        this.items.add(this.updateInstallScenarioItem);
                        mustReboot = true;
                    }
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            this.items.add(this.installItem);
            if ((this.wizardModel.solution.getProcessingFlags() & 0x20000L) > 0L) {
                mustInstallOs = true;
                mustReboot = true;
            }
            if ((this.wizardModel.solution.getProcessingFlags() & 0x10000L) > 0L) {
                mustReboot = true;
            } else if ((this.wizardModel.solution.getProcessingFlags() & 0x40000L) > 0L) {
                mustUpdateDaemon = true;
            }
            mustStopApps = true;
        }
        if (!this.wizardModel.skipSyncLocalTime && this.wizardModel.syncLocalTime) {
            this.items.add(this.dateTimeItem);
        }
        if (!this.wizardModel.skipTcp && (this.wizardModel.updateTcpIpSettings || this.wizardModel.updateLinkSettings || this.wizardModel.updateDhcpdSettings)) {
            this.items.add(this.tcpItem);
            mustStopApps = true;
            mustReboot = true;
        }
        if (!this.wizardModel.skipStation && this.wizardModel.stationDir != null && !this.wizardModel.restartEnabled) {
            mustReboot = true;
        }
        if (mustInstallOs && !this.items.contains(this.cleanAndUpdateRebootInstallablesItem)) {
            this.items.add(this.osInstallItem);
        }
        if (mustReboot) {
            this.items.add(this.rebootItem);
        } else {
            if (mustStopApps) {
                try {
                    BAppSurrogate[] allApplications;
                    for (BAppSurrogate app : allApplications = BAppSurrogate.makeAll(null, (BDaemonSession)this.wizardModel.daemonSession)) {
                        if (app.isAppStopped()) continue;
                        if (this.wizardModel.restartEnabled) {
                            if (!this.items.contains(this.startAppItem)) {
                                this.items.add(this.startAppItem);
                            }
                        } else if (!this.items.contains(this.rebootItem)) {
                            this.items.add(this.rebootItem);
                        }
                        break;
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            if (mustUpdateDaemon) {
                this.items.add(this.updateDaemonItem);
            } else if (this.wizardModel.targetStationName != null && this.wizardModel.startStation && !this.items.contains(this.startAppItem)) {
                this.items.add(this.startAppItem);
            }
        }
        if (mustStopApps) {
            this.items.add(0, this.stopAppsItem);
        }
        return this.items.toArray(new TaskDetailPane.TaskItem[0]);
    }

    @Override
    public void run() {
        try {
            int i;
            HashMap<Type, HashSet<String>> stoppedApps = new HashMap<Type, HashSet<String>>();
            if (this.items.contains(this.stopAppsItem)) {
                this.setCurrentItem(this.stopAppsItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.stopApps"));
                this.getLog().append("\n");
                BAppSurrogate[] stopResults = BAppSurrogate.stopAllApps((BDaemonSession)this.wizardModel.daemonSession, null, null, (DaemonSessionTaskListener)new DaemonSessionTaskHandler((BWidget)this.getDialog()));
                if (stopResults.length == 0) {
                    this.getLog().append(lex.getText("CommissioningWizard.installDist.stopApps.noneRunning"));
                    this.getLog().append("\n");
                } else {
                    for (BAppSurrogate result : stopResults) {
                        HashSet<String> appsForType = (HashSet<String>)stoppedApps.get(result.getType());
                        if (appsForType == null) {
                            appsForType = new HashSet<String>();
                            stoppedApps.put(result.getType(), appsForType);
                        }
                        appsForType.add(result.getAppName());
                        this.getLog().append(lex.getText("CommissioningWizard.finish.item.stopApps", new Object[]{result.toString(null)}));
                        this.getLog().append("\n");
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains(this.lowMemoryRebootItem)) {
                String currentSessionTimestamp = this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp();
                BAppSurrogate[] apps = BAppSurrogate.makeAll(null, (BDaemonSession)this.wizardModel.daemonSession);
                boolean[] mustReEnableAutoStart = new boolean[apps.length];
                for (i = 0; i < apps.length; ++i) {
                    if (apps[i].getIsAutoStart()) {
                        mustReEnableAutoStart[i] = true;
                        apps[i].updateSettings(false, apps[i].getIsAutoRestart());
                        continue;
                    }
                    mustReEnableAutoStart[i] = false;
                }
                this.lowMemoryReboot();
                this.reconnect(this.lowMemoryReconnectItem, currentSessionTimestamp);
                for (i = 0; i < apps.length; ++i) {
                    if (!mustReEnableAutoStart[i]) continue;
                    apps[i].updateSettings(true, apps[i].getIsAutoRestart());
                }
            }
            if (this.items.contains(this.authChangeItem)) {
                this.setCurrentItem(this.authChangeItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateAuth"));
                this.getLog().append("\n");
                boolean requiresCredentialsUpdate = false;
                if (DaemonAuthUtil.isNativeScheme((String)this.wizardModel.authMethod)) {
                    if (this.wizardModel.authUsersChanged && this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                        if (this.wizardModel.defaultAccountPresent) {
                            AddUserMessage addUserMessage = new AddUserMessage(this.wizardModel.newNativeUserAccountToAdd);
                            addUserMessage.setSharedKey(this.wizardModel.daemonSession.generateSharedSecretKey("commissioningWizard_finish_addUser"));
                            AddMemberMessage addMemberMessage = new AddMemberMessage(this.wizardModel.nativeAdminGroup, this.wizardModel.newNativeUserAccountToAdd);
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)addUserMessage);
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)addMemberMessage);
                            FipsOptionsHelper.getInstance().updateUserCookie(this.wizardModel.newNativeUserAccountToAdd.getAccountName(), this.wizardModel.isFips, this.wizardModel.daemonSession);
                            String encodedPassword = this.wizardModel.newNativeUserAccountToAdd.getPassword();
                            String decodedPassword = null;
                            try {
                                decodedPassword = LegacyStorageUtil.decode((String)encodedPassword);
                            }
                            catch (IOException appsForType) {
                                // empty catch block
                            }
                            BUsernameAndPassword newUserCredentials = new BUsernameAndPassword(this.wizardModel.newNativeUserAccountToAdd.getAccountName(), BPassword.make((String)decodedPassword));
                            DaemonCredentialsManager.setCredentials(this.wizardModel.daemonSession, (BICredentials)newUserCredentials);
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
                            DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(this.wizardModel.nativeAdminGroup, this.wizardModel.defaultNativeUserAccountToRemove);
                            DeleteUserMessage deleteUserMessage = new DeleteUserMessage(this.wizardModel.defaultNativeUserAccountToRemove);
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)deleteMemberMessage);
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)deleteUserMessage);
                            FipsOptionsHelper.getInstance().updateUserCookie(this.wizardModel.defaultNativeUserAccountToRemove.getAccountName(), false, this.wizardModel.daemonSession);
                        }
                        for (XmlResponseMessage currentMessageInQueue : this.wizardModel.authMessageQueue) {
                            if (currentMessageInQueue instanceof IUserUpdate) {
                                IUserUpdate userUpdate = (IUserUpdate)currentMessageInQueue;
                                FipsOptionsHelper.getInstance().updateUserCookie(userUpdate.getUsername(), this.wizardModel.isFips && !userUpdate.isDelete(), this.wizardModel.daemonSession);
                            }
                            this.wizardModel.daemonSession.sendMessage((DaemonMessage)currentMessageInQueue);
                        }
                        if (this.wizardModel.newCredentials != null) {
                            requiresCredentialsUpdate = true;
                        }
                    }
                    if (this.wizardModel.authMethodChanged) {
                        this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateNativeAuthenticationMessage(this.wizardModel.authMethod, (NativeAccount)this.wizardModel.nativeAdminGroup));
                        requiresCredentialsUpdate = true;
                    }
                } else if (DaemonAuthUtil.isFileScheme((String)this.wizardModel.authMethod)) {
                    FipsOptionsHelper.getInstance().updateUserCookie(this.wizardModel.fileDomainAdminUser, this.wizardModel.isFips, this.wizardModel.daemonSession);
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateFileAuthenticationMessage(this.wizardModel.authMethod, this.wizardModel.fileDomainAdminUser, this.wizardModel.fileDomainAdminPassword, this.wizardModel.daemonSession.generateSharedSecretKey("commissioningWizard_finish_updateFile")));
                    requiresCredentialsUpdate = true;
                }
                if (requiresCredentialsUpdate && this.wizardModel.newCredentials != null) {
                    DaemonCredentialsManager.setCredentials(this.wizardModel.daemonSession, (BICredentials)this.wizardModel.newCredentials);
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains(this.systemPasswordItem)) {
                this.setCurrentItem(this.systemPasswordItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateSystemPassword"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new SystemPasswordMessage(this.wizardModel.newSystemPassword, this.wizardModel.oldSystemPassword, false, this.wizardModel.daemonSession.generateSharedSecretKey("commissionWizard_set")));
                FipsOptionsHelper.getInstance().updateSystemPassphraseCookie(this.wizardModel.isFips, this.wizardModel.daemonSession);
                this.updateCurrentItemState(BJobState.success);
                this.setCancelEnabled(false);
            }
            if (this.items.contains(this.deleteStationsItem)) {
                int i2;
                this.setCurrentItem(this.deleteStationsItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.deleteStations"));
                this.getLog().append("\n");
                FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                for (i2 = 0; i2 < this.wizardModel.stationsToDelete.size(); ++i2) {
                    BStationSurrogate station = this.wizardModel.stationsToDelete.get(i2);
                    message.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("~stations/" + station.getStationName()), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                    HashSet appsForType = (HashSet)stoppedApps.get(station.getType());
                    if (appsForType == null) continue;
                    appsForType.remove(station.getAppName());
                }
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)message, (ICancelHint)this, (DaemonSessionTaskListener)this);
                for (i2 = 0; i2 < this.wizardModel.stationsToDelete.size(); ++i2) {
                    BStationSurrogate station = this.wizardModel.stationsToDelete.get(i2);
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new DeleteStationMessage(station.getStationName()));
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains(this.importFromPlatformItem)) {
                this.importPlatformModules();
                String currentSessionTimestamp = this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp();
                BAppSurrogate[] apps = BAppSurrogate.makeAll(null, (BDaemonSession)this.wizardModel.daemonSession);
                boolean[] mustReEnableAutoStart = new boolean[apps.length];
                for (i = 0; i < apps.length; ++i) {
                    if (apps[i].getIsAutoStart()) {
                        mustReEnableAutoStart[i] = true;
                        apps[i].updateSettings(false, apps[i].getIsAutoRestart());
                        continue;
                    }
                    mustReEnableAutoStart[i] = false;
                }
                this.cleanAndUpdatePlatformOsAndJvm();
                this.reconnect(this.reconnectItem, currentSessionTimestamp);
                for (i = 0; i < apps.length; ++i) {
                    if (!mustReEnableAutoStart[i]) continue;
                    apps[i].updateSettings(true, apps[i].getIsAutoRestart());
                }
                this.updateInstallScenario();
            }
            if (this.items.contains(this.installItem)) {
                this.setCurrentItem(this.installItem, BJobState.running);
                this.checkCanceled();
                Optional<Object> initializer = this.wizardModel.stationDir == null ? Optional.empty() : Optional.of(DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)this.wizardModel.daemonSession, Optional.ofNullable(this.wizardModel.encodingInfo), Optional.ofNullable(this.wizardModel.stationBogPassphrase)));
                this.wizardModel.solution.commit((DaemonSessionTaskListener)this, new StoreCache(), (ICancelHint)this, false, initializer);
                if (!this.wizardModel.skipLicense && this.wizardModel.getLicenseSelection() != null) {
                    this.updateLicenseProperties(this.wizardModel.getLicenseSelection().getSelectedLicenseMode());
                    LicenseSync<LicenseInfo> sync = this.wizardModel.getLicenseSelection().getLicenseSync();
                    if (sync != null) {
                        int ixLicense;
                        for (ixLicense = 0; ixLicense < sync.toAdd.size(); ++ixLicense) {
                            LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)sync.toAdd.get((int)ixLicense)).vendorLicense);
                        }
                        for (ixLicense = 0; ixLicense < sync.toUpdate.size(); ++ixLicense) {
                            LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)sync.toUpdate.get((int)ixLicense)).vendorLicense);
                        }
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            this.setCancelEnabled(true);
            if (this.wizardModel.targetStationName != null) {
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage());
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage(this.wizardModel.targetStationName, false, this.wizardModel.autoStart, this.wizardModel.autoRestart, true));
            }
            if (this.items.contains(this.dateTimeItem)) {
                this.setCurrentItem(this.dateTimeItem, BJobState.running);
                BTimeZone ostz = BTimeZone.getLocal();
                String tzid = ostz.getId();
                if (!TimeZoneUtil.isSupported((BTimeZone)ostz, (BDstSupportLevel)this.wizardModel.daemonSession.getHostProperties().getTimezoneDayModeSupport())) {
                    ostz = BTimeZone.UTC;
                }
                BHostProperties hostProperties = this.wizardModel.daemonSession.getHostProperties();
                BDstSupportLevel tzSupportMode = hostProperties.getTimezoneDayModeSupport();
                ostz = TimeZoneUtil.makeCompatible((BTimeZone)ostz, (BDstSupportLevel)tzSupportMode);
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new UpdateTimeMessage(BAbsTime.now(), tzid, ostz, false));
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains(this.tcpItem)) {
                this.setCurrentItem(this.tcpItem, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateTcp"));
                this.getLog().append("\n");
                if (this.wizardModel.updateTcpIpSettings) {
                    TcpUtil.saveToSession((BTcpIpHostSettings)this.wizardModel.tcpIpSettings, (BDaemonSession)this.wizardModel.daemonSession, (boolean)this.wizardModel.hostFileDirty);
                    AuditUtil.audit((String)"ipchanges", (BHost)this.wizardModel.daemonSession.getHost(), (String)"CommissioningWizard", (BComponent)this.wizardModel.originalTcpIpSettings, (BComponent)this.wizardModel.tcpIpSettings);
                }
                if (this.wizardModel.updateDhcpdSettings) {
                    DhcpdUtil.saveToSession((BDhcpdHostSettings)this.wizardModel.dhcpdHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                }
                if (this.wizardModel.updateLinkSettings) {
                    LinkCfgUtil.saveToSession((BLinkCfgHostSettings)this.wizardModel.linkCfgHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                }
                this.updateCurrentItemState(BJobState.success);
                this.setCancelEnabled(false);
            }
            if (this.items.contains(this.osInstallItem)) {
                this.setCurrentItem(this.osInstallItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.osInstall"));
                this.getLog().append("\n");
                if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("osupdate")) {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains(this.rebootItem)) {
                this.subscriptionLogMessage();
                this.setCurrentItem(this.rebootItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendRebootRequest();
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            } else if (this.items.contains(this.updateDaemonItem)) {
                this.subscriptionLogMessage();
                this.setCurrentItem(this.updateDaemonItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.updateDaemon"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            } else {
                if (this.wizardModel.getLicenseSelection() != null && this.wizardModel.getLicenseSelection().getLicenseSync() != null && !this.wizardModel.getLicenseSelection().getLicenseSync().unchanged() && this.wizardModel.getLicenseSelection().getSelectedLicenseMode() != LicenseMode.SUBSCRIPTION) {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                }
                if (this.items.contains(this.startAppItem)) {
                    BStationSurrogate station;
                    this.setCurrentItem(this.startAppItem, BJobState.running);
                    this.checkCanceled();
                    this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.header"));
                    this.getLog().append("\n");
                    SessionSurrogates sessionSurrogates = new SessionSurrogates(this.wizardModel.daemonSession);
                    sessionSurrogates.getVector(true);
                    for (Type appType : stoppedApps.keySet()) {
                        HashSet appsForType = (HashSet)stoppedApps.get(appType);
                        for (String appOfType : appsForType) {
                            BAppSurrogate app = sessionSurrogates.get(appType, appOfType, false);
                            if (app == null) continue;
                            app.startAppAsync();
                            this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.item", new Object[]{app.toString(null)}));
                            this.getLog().append("\n");
                        }
                    }
                    if (this.wizardModel.targetStationName != null && this.wizardModel.startStation && (station = (BStationSurrogate)sessionSurrogates.get(BStationSurrogate.TYPE, this.wizardModel.targetStationName, false)) != null && station.getAppStatus() == BStationStatus.idle) {
                        station.startAppAsync();
                        this.getLog().append(lex.getText("CommissioningWizard.finish.startApp.item", new Object[]{station.toString(null)}));
                        this.getLog().append("\n");
                    }
                    this.updateCurrentItemState(BJobState.success);
                }
            }
            this.checkCanceled();
            this.getLog().append(lex.getText("CommissioningWizard.finish.done"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.done"));
            if (this.items.contains(this.rebootItem)) {
                this.getLog().append("\n");
                this.getLog().append(lex.getText("CommissioningWizard.finish.powerNotice"));
                this.getLog().append("\n");
            }
        }
        catch (ICancelHint.CanceledException ce) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            t.printStackTrace();
            this.getLog().append(t);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    private void subscriptionLogMessage() {
        if (this.wizardModel.getLicenseSelection() == null || this.wizardModel.getLicenseSelection().getSelectedLicenseMode() == null) {
            return;
        }
        LicenseMode licenseMode = this.wizardModel.getLicenseSelection().getSelectedLicenseMode();
        if (licenseMode.equals((Object)LicenseMode.SUBSCRIPTION)) {
            if (this.wizardModel.autoStart) {
                this.getLog().append(lex.getText("CommissioningWizard.finish.stationEntitlementAppDirector"));
                this.getLog().append("\n");
            } else {
                this.getLog().append(lex.getText("CommissioningWizard.finish.stationEntitlementLicenseManager"));
                this.getLog().append("\n");
            }
        }
    }

    private void updateLicenseProperties(LicenseMode licenseMode) throws Exception {
        if (licenseMode == null) {
            return;
        }
        if (this.wizardModel.isUpdateLicenseProperties()) {
            if (licenseMode.equals((Object)LicenseMode.SUBSCRIPTION)) {
                this.getLog().append(lex.getText("CommissioningWizard.finish.updatingSubscriptionLicenseProperties"));
            } else {
                this.getLog().append(lex.getText("CommissioningWizard.finish.updatingPerpetualLicenseProperties"));
            }
            this.getLog().append("\n");
            Version remoteDaemonVersion = new Version(this.wizardModel.daemonSession.getHostProperties().getDaemonVersion());
            if (remoteDaemonVersion.compareTo(this.wizardModel.reqSubscriptionVersion) >= 0) {
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new AddSubscriptionModeMessage(licenseMode));
                this.wizardModel.daemonSession.sendMessage((DaemonMessage)new ReloadLicenseModeMessage());
            } else if (licenseMode == LicenseMode.SUBSCRIPTION) {
                FilePath licensePropFilePath = SystemFilePaths.getLicensePropertiesPath((boolean)this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly());
                FileTransferMessage msg = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                String metaData = "#Auto-generated file, do not modify.\n#" + new Date().toString() + "\nlicense.subscriptionMode=true\n";
                msg.addElement((FileTransferMessageElement)new ByteArrayFileTransferElement(licensePropFilePath, metaData.getBytes(), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)msg, null);
            }
            if (licenseMode == LicenseMode.SUBSCRIPTION && !this.items.contains(this.rebootItem)) {
                this.items.add(this.rebootItem);
            }
            this.deleteUnusedLicenses(licenseMode);
        }
    }

    private void deleteUnusedLicenses(LicenseMode licenseMode) throws Exception {
        boolean isNiagaraHomeReadonly = this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        if (licenseMode == LicenseMode.PERPETUAL) {
            BIFile subscriptionDir = this.wizardModel.daemonSession.getFileSpace().findFile(SystemFilePaths.getSubscriptionDirPath((boolean)isNiagaraHomeReadonly));
            if (subscriptionDir != null) {
                this.getLog().append(lex.getText("CommissioningWizard.finish.deletingExistingSubscriptionLicenses"));
                this.getLog().append("\n");
                this.getLog().append(lex.getText("CommissioningWizard.finish.deletingLicense", new Object[]{subscriptionDir.getFilePath()}));
                this.getLog().append("\n");
                DaemonFileUtil.deleteFile((BIFile)subscriptionDir);
            }
        } else {
            BDirectory perpetualLicenseDir = (BDirectory)this.wizardModel.daemonSession.getFileSpace().findFile(LicenseDatabase.getPerpetualLicenseDirPath((boolean)isNiagaraHomeReadonly));
            if (perpetualLicenseDir != null) {
                this.getLog().append(lex.getText("CommissioningWizard.finish.deletingExistingPerpetualLicenses"));
                this.getLog().append("\n");
                for (BIFile licenseFile : perpetualLicenseDir.listFiles()) {
                    if (!licenseFile.getFileName().endsWith(".license")) continue;
                    this.getLog().append(lex.getText("CommissioningWizard.finish.deletingLicense", new Object[]{licenseFile.getFilePath()}));
                    this.getLog().append("\n");
                    DaemonFileUtil.deleteFile((BIFile)licenseFile);
                }
            }
        }
    }

    private void lowMemoryReboot() {
        this.setCurrentItem(this.lowMemoryRebootItem, BJobState.running);
        try {
            this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
            this.getLog().append("\n");
            this.wizardModel.daemonSession.sendRebootRequest();
            this.wizardModel.reconnectOnFinish = false;
            this.updateCurrentItemState(BJobState.success);
        }
        catch (ICancelHint.CanceledException ce) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            t.printStackTrace();
            this.getLog().append(t);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    private void cleanAndUpdatePlatformOsAndJvm() {
        this.setCurrentItem(this.cleanAndUpdateRebootInstallablesItem, BJobState.running);
        ArrayList modulesToTemporarilyUninstall = new ArrayList();
        if (this.remoteModules != null) {
            Set modulesInSolution = Arrays.stream(this.wizardModel.solution.getToInstall()).filter(i -> i instanceof BModuleInstallable).map(i -> i.getPart().getPartName()).collect(Collectors.toSet());
            IterableCursor cursor = this.remoteModules.getInstallables(false, (DaemonSessionTaskListener)this);
            Object object = null;
            try {
                this.modulesToRestore = cursor.stream().filter(installable -> installable instanceof BModuleInstallable).map(installable -> (BModuleInstallable)installable).map(BModuleInstallable::getModulePart).peek(modulePart -> modulesToTemporarilyUninstall.add(modulePart.getPartName())).filter(modulePart -> !modulesInSolution.contains(modulePart.getPartName())).map(modulePart -> BDependency.forPart((BPart)modulePart, (BVersionRelation)BVersionRelation.exact)).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (object != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        try {
            InstallScenario initialUpdateScenario = InstallScenario.solve((BDaemonPlatform)this.wizardModel.getPlatform(), (DaemonSessionTaskListener)this, (String[])modulesToTemporarilyUninstall.toArray(new String[0]), null, (BInstallable[])this.jreAndOsInstallables.toArray(new BInstallable[0]), null, null, (CertificateChainValidator)this.wizardModel.solution.getCertValidator());
            boolean containsOSUpdate = false;
            for (BInstallable installablePart : this.jreAndOsInstallables) {
                if (!(installablePart.getPart() instanceof BOsPart)) continue;
                containsOSUpdate = true;
            }
            initialUpdateScenario.commit((DaemonSessionTaskListener)this, (ICancelHint)this);
            if (containsOSUpdate) {
                this.getLog().append(lex.getText("CommissioningWizard.finish.osInstall"));
                this.getLog().append("\n");
                if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("osupdate")) {
                    this.wizardModel.daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
                }
            }
            this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
            this.getLog().append("\n");
            this.wizardModel.daemonSession.sendRebootRequest();
            this.wizardModel.reconnectOnFinish = false;
            this.updateCurrentItemState(BJobState.success);
        }
        catch (ICancelHint.CanceledException ce) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            t.printStackTrace();
            this.getLog().append(t);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    private void importPlatformModules() {
        this.setCurrentItem(this.importFromPlatformItem, BJobState.running);
        try {
            BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
            this.remoteModules = (BRemoteModuleList)platform.getModuleList();
            this.remoteModules.importUnregisteredModules((DaemonSessionTaskListener)this, (ICancelHint)this);
            this.updateCurrentItemState(BJobState.success);
        }
        catch (ICancelHint.CanceledException ce) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            t.printStackTrace();
            this.getLog().append(t);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    private void updateInstallScenario() {
        this.setCurrentItem(this.updateInstallScenarioItem, BJobState.running);
        try {
            InstallScenario oldSolution = this.wizardModel.solution;
            BInstallable[] toInstall = oldSolution.getToInstall();
            ArrayList newInstallables = new ArrayList();
            Collections.addAll(newInstallables, toInstall);
            newInstallables.removeAll(this.jreAndOsInstallables);
            BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
            platform.requestReload();
            platform.loadPreferredVerificationMode();
            HashSet<String> removeFromReinstall = new HashSet<String>(Arrays.asList(oldSolution.getModulesToUninstall()));
            BDependency[] additionalDependencies = (BDependency[])this.modulesToRestore.stream().filter(dep -> !removeFromReinstall.contains(dep.getPartName())).toArray(BDependency[]::new);
            this.wizardModel.solution = InstallScenario.solve((BDaemonPlatform)platform, (String[])oldSolution.getModulesToUninstall(), (BDependency[])additionalDependencies, (BInstallable[])newInstallables.toArray(new BInstallable[0]), (SolutionParameters)oldSolution.getSolutionParameters(), (Set)oldSolution.getNewEnabledRuntimeProfiles(), (InstallableRegistry)oldSolution.getInstallableRegistry(), (CertificateChainValidator)oldSolution.getCertValidator());
            this.updateCurrentItemState(BJobState.success);
        }
        catch (ICancelHint.CanceledException ce) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            t.printStackTrace();
            this.getLog().append(t);
            this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(TaskDetailPane.TaskItem reconnectStep, String sessionTimestamp) throws Exception {
        block8: {
            this.setCurrentItem(reconnectStep, BJobState.running);
            this.setCancelEnabled(true);
            this.getLog().append(lex.getText("CommissioningWizard.finish.reconnect"));
            this.getLog().append("\n");
            Dots d = new Dots();
            d.start();
            try {
                if (this.wizardModel.daemonSession.reconnect(sessionTimestamp, (ICancelHint)this)) {
                    d.cancel();
                    this.getLog().append(lex.getText("CommissioningWizard.finish.reconnected"));
                    this.getLog().append("\n");
                    this.setCurrentItem(reconnectStep, BJobState.success);
                    break block8;
                }
                throw new ICancelHint.CanceledException();
            }
            catch (ICancelHint.CanceledException ce) {
                this.updateCurrentItemState(BJobState.canceled);
                this.getLog().append(lex.getText("CommissioningWizard.finish.canceled"));
                this.getLog().append("\n");
                this.setBottomLabelText(lex.getText("CommissioningWizard.finish.canceled"));
            }
            catch (Throwable t) {
                this.setCancelEnabled(true);
                this.cancel(false);
                this.updateCurrentItemState(BJobState.failed);
                t.printStackTrace();
                this.getLog().append(t);
                this.setBottomLabelText(lex.getText("CommissioningWizard.finish.failed"));
            }
            finally {
                d.cancel();
            }
        }
    }

    public void taskStarted(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
        if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask task) {
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;

        private Dots() {
        }

        @Override
        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    FinishPane.this.getLog().append("\n");
                    this.i = 0;
                }
                FinishPane.this.getLog().append(".");
            }
            FinishPane.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

