/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import javax.baja.gx.BColor;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.TextModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Version;

public class SystemPasswordStep
extends CommissioningWizardStep {
    BPasswordFE currentPasswordFE;
    BPasswordFE newPasswordFE1;
    BPasswordFE newPasswordFE2;

    public SystemPasswordStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        BGridPane grid = new BGridPane(2);
        grid.setValign(BValign.top);
        grid.setHalign(BHalign.left);
        grid.setStretchColumn(1);
        BGridPane header = new BGridPane(1);
        header.setHalign(BHalign.left);
        header.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.systemPass.header"), BHalign.left));
        if (wizardModel.requireSystemPassword) {
            BLabel noticeLabel = new BLabel(LEX.getText("CommissioningWizard.systemPass.defaultNotice"), BHalign.left);
            noticeLabel.setForeground(BColor.red.toBrush());
            header.add(null, (BValue)noticeLabel);
        }
        this.currentPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("CommissioningWizard.systemPass.oldpassword.label"), (BWidget)this.currentPasswordFE);
        this.newPasswordFE1 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("CommissioningWizard.systemPass.newpassword.label"), (BWidget)this.newPasswordFE1);
        this.newPasswordFE2 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("CommissioningWizard.systemPass.newpassword2.label"), (BWidget)this.newPasswordFE2);
        ((BTextField)this.newPasswordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
        ((BTextField)this.newPasswordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
    }

    @Override
    public String getStepName() {
        return "systemPass";
    }

    @Override
    public String getSectionName() {
        return "systemPass";
    }

    @Override
    public boolean exit(int direction) {
        boolean back;
        boolean bl = back = direction == 1;
        if (back) {
            return true;
        }
        try {
            BPassword npw2;
            BPassword npw1;
            BPassword opw;
            block12: {
                block11: {
                    opw = (BPassword)this.currentPasswordFE.saveValue();
                    npw1 = (BPassword)this.newPasswordFE1.saveValue();
                    npw2 = (BPassword)this.newPasswordFE2.saveValue();
                    if (opw == null) break block11;
                    if (AccessController.doPrivileged(() -> ((BPassword)opw).getValue()).trim().length() == 0 || npw1 == null) break block11;
                    if (AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()).trim().length() == 0 || npw2 == null) break block11;
                    if (AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()).trim().length() != 0) break block12;
                }
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.fieldRequired"));
                return false;
            }
            BPasswordStrength passwordStrength = FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.wizardModel.isFips, this.wizardModel.daemonSession);
            if (!BNativeUserTable.validatePassword((BWidget)this.wizardModel.getWizard(), npw1, passwordStrength)) {
                return false;
            }
            if (new Version(this.wizardModel.daemonSession.getHostProperties().getDaemonVersion()).compareTo(new Version("4.0.17.7.650")) != -1 && !BNativeUserTable.checkStatus(null, this.wizardModel.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(null, opw, true, this.wizardModel.daemonSession.generateSharedSecretKey("commissionWizard_check")))) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("SystemPassword.error.badPassword"));
                return false;
            }
            if (!BNativeUserTable.checkStatus(null, this.wizardModel.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(npw1, null, true, this.wizardModel.daemonSession.generateSharedSecretKey("commissionWizard_check")))) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.invalidPasswordDefault"));
                return false;
            }
            if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()))) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.passwordMismatch"));
                return false;
            }
            this.wizardModel.newSystemPassword = npw1;
            this.wizardModel.oldSystemPassword = opw;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return true;
    }

    @Override
    public int getMode() {
        int mode = 1;
        if (((BTextField)this.newPasswordFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.newPasswordFE2.getContent()).getText().trim().length() == 0) {
            return mode;
        }
        return mode | 2;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipSystemPassword;
    }

    private static class ModeControlModel
    extends TextModel {
        private CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep pStep) {
            this.step = pStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }
}

