/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platDaemon.ui.config.BMultiSliderEvent;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.Theme;
import java.text.NumberFormat;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BSlider;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="thumbCount", type="int", defaultValue="1"), @NiagaraProperty(name="thumbValues", type="BVector", defaultValue="new BVector()"), @NiagaraProperty(name="minimumThumbValues", type="BVector", defaultValue="new BVector()"), @NiagaraProperty(name="maximumThumbValues", type="BVector", defaultValue="new BVector()")})
@NiagaraTopic(name="valuesModified", eventType="BMultiSliderEvent")
public class BMultiSlider
extends BSlider {
    @Generated
    public static final Property thumbCount = BMultiSlider.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property thumbValues = BMultiSlider.newProperty((int)0, (BValue)new BVector(), null);
    @Generated
    public static final Property minimumThumbValues = BMultiSlider.newProperty((int)0, (BValue)new BVector(), null);
    @Generated
    public static final Property maximumThumbValues = BMultiSlider.newProperty((int)0, (BValue)new BVector(), null);
    @Generated
    public static final Topic valuesModified = BMultiSlider.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMultiSlider.class);
    private double[] thumbMaximumValuesAsArray = null;
    private double[] thumbMinimumValuesAsArray = null;

    @Generated
    public int getThumbCount() {
        return this.getInt(thumbCount);
    }

    @Generated
    public void setThumbCount(int v) {
        this.setInt(thumbCount, v, null);
    }

    @Generated
    public BVector getThumbValues() {
        return (BVector)this.get(thumbValues);
    }

    @Generated
    public void setThumbValues(BVector v) {
        this.set(thumbValues, (BValue)v, null);
    }

    @Generated
    public BVector getMinimumThumbValues() {
        return (BVector)this.get(minimumThumbValues);
    }

    @Generated
    public void setMinimumThumbValues(BVector v) {
        this.set(minimumThumbValues, (BValue)v, null);
    }

    @Generated
    public BVector getMaximumThumbValues() {
        return (BVector)this.get(maximumThumbValues);
    }

    @Generated
    public void setMaximumThumbValues(BVector v) {
        this.set(maximumThumbValues, (BValue)v, null);
    }

    @Generated
    public void fireValuesModified(BMultiSliderEvent event) {
        this.fire(valuesModified, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMultiSlider() {
    }

    public BMultiSlider(double min, double max, double inc, double[] thumbValues, double[] minimumThumbValues, double[] maximumThumbValues) {
        if (min < 0.0 || max < 0.0) {
            throw new BajaRuntimeException("Negative values disallowed for BMultiSlider");
        }
        this.setMin(min);
        this.setMax(max);
        this.setIncrement(inc);
        this.setValue(min);
        this.setThumbCount(thumbValues.length);
        double total = 0.0;
        BVector minValues = new BVector();
        for (int i = 0; i < minimumThumbValues.length; ++i) {
            minValues.add("minThumb" + i, (BValue)BDouble.make((double)minimumThumbValues[i]));
        }
        this.setMinimumThumbValues(minValues);
        this.thumbMinimumValuesAsArray = new double[this.getThumbCount()];
        int idx = 0;
        SlotCursor c = this.getMinimumThumbValues().getProperties();
        while (c.next(BDouble.class)) {
            this.thumbMinimumValuesAsArray[idx++] = ((BDouble)c.get()).getDouble();
        }
        BVector maxValues = new BVector();
        for (int i = 0; i < maximumThumbValues.length; ++i) {
            maxValues.add("maxThumb" + i, (BValue)BDouble.make((double)maximumThumbValues[i]));
        }
        this.setMaximumThumbValues(maxValues);
        this.thumbMaximumValuesAsArray = new double[this.getThumbCount()];
        idx = 0;
        SlotCursor c2 = this.getMaximumThumbValues().getProperties();
        while (c2.next(BDouble.class)) {
            this.thumbMaximumValuesAsArray[idx++] = ((BDouble)c2.get()).getDouble();
        }
        BVector values = new BVector();
        for (int i = 0; i < thumbValues.length; ++i) {
            if (thumbValues[i] < 0.0) {
                throw new BajaRuntimeException("Invalid thumb value: " + thumbValues[i] + ", must be >= 0");
            }
            if (max < thumbValues[i]) {
                throw new BajaRuntimeException("Invalid thumb value: " + thumbValues[i] + " with max: " + max);
            }
            if ((double)i / inc % 1.0 != 0.0) {
                throw new BajaRuntimeException("Thumb value not evenly divisible by increment");
            }
            values.add("thumb" + i, (BValue)BDouble.make((double)thumbValues[i]));
            total += thumbValues[i];
        }
        if (total > max) {
            throw new BajaRuntimeException("Invalid thumb value total: " + total + " with max: " + max);
        }
        this.setThumbValues(values);
    }

    public void paint(Graphics g) {
        SliderTheme theme = Theme.slider();
        theme.paintTrack(g, (BSlider)this, this.track);
        double[] thumbValuesAsArray = new double[this.getThumbCount()];
        int idx = 0;
        SlotCursor c = this.getThumbValues().getProperties();
        while (c.next(BDouble.class)) {
            thumbValuesAsArray[idx++] = ((BDouble)c.get()).getDouble();
        }
        double absPosition = this.getMin();
        for (idx = 0; idx < this.getThumbCount() - 1; ++idx) {
            int pos = (int)(((absPosition += thumbValuesAsArray[idx]) - this.getMin()) / this.realSize * this.viewSize);
            if (!this.isHorizontal()) {
                pos = (int)(this.viewSize - (double)pos);
            }
            if (this.isHorizontal()) {
                this.thumb.set((double)pos, 0.0, this.thumb.width, this.thumb.height);
            } else {
                this.thumb.set(0.0, (double)pos, this.thumb.width, this.thumb.height);
            }
            theme.paintThumb(g, (BSlider)this, this.thumb);
        }
    }

    public void mouseDragged(BMouseEvent event) {
        double viewPos;
        double d = viewPos = this.isHorizontal() ? event.getX() - this.thumbPoint : this.getHeight() - event.getY() - this.thumbPoint;
        if (viewPos < 0.0) {
            viewPos = 0.0;
        }
        if (viewPos > this.viewSize) {
            viewPos = this.viewSize;
        }
        double newValue = viewPos / this.viewSize * this.realSize + this.getMin();
        double pixelSizeToRealSizeRatio = this.viewSize / this.realSize;
        double[] thumbValuesAsArray = new double[this.getThumbCount()];
        int idx = 0;
        SlotCursor c = this.getThumbValues().getProperties();
        while (c.next(BDouble.class)) {
            thumbValuesAsArray[idx++] = ((BDouble)c.get()).getDouble();
        }
        double thumbValuesSum = 0.0;
        for (idx = 0; idx < thumbValuesAsArray.length - 1; ++idx) {
            double currentThumbUpperBoundary;
            double currentThumbLowerBoundary;
            thumbValuesSum += thumbValuesAsArray[idx];
            if (this.isHorizontal()) {
                currentThumbLowerBoundary = thumbValuesSum - this.thumb.width / 2.0 / pixelSizeToRealSizeRatio;
                currentThumbUpperBoundary = thumbValuesSum + this.thumb.width / 2.0 / pixelSizeToRealSizeRatio;
            } else {
                currentThumbLowerBoundary = thumbValuesSum - this.thumb.height / 2.0 / pixelSizeToRealSizeRatio;
                currentThumbUpperBoundary = thumbValuesSum + this.thumb.height / 2.0 / pixelSizeToRealSizeRatio;
            }
            if (newValue >= currentThumbLowerBoundary - 5.0 && newValue <= currentThumbUpperBoundary + 5.0) break;
            if (!(newValue < thumbValuesSum)) continue;
            return;
        }
        if (idx >= thumbValuesAsArray.length - 1) {
            return;
        }
        double inc = this.getIncrement();
        double temp = newValue % inc;
        newValue = temp > inc / 2.0 ? newValue - temp + inc : (newValue -= temp);
        double currentValueOfThumb = thumbValuesAsArray[idx];
        double sumOfAllThumbsBefore = 0.0;
        for (int i = 0; i < idx; ++i) {
            sumOfAllThumbsBefore += thumbValuesAsArray[i];
        }
        double changeResult = currentValueOfThumb - (newValue -= sumOfAllThumbsBefore);
        double newThumbValue = newValue;
        double newThumbValueOfNext = thumbValuesAsArray[idx + 1] + changeResult;
        if (newThumbValue < this.thumbMinimumValuesAsArray[idx] || newThumbValueOfNext < this.thumbMinimumValuesAsArray[idx + 1]) {
            return;
        }
        if (newThumbValue > this.thumbMaximumValuesAsArray[idx] || newThumbValueOfNext > this.thumbMaximumValuesAsArray[idx + 1]) {
            return;
        }
        thumbValuesAsArray[idx] = newThumbValue;
        thumbValuesAsArray[idx + 1] = newThumbValueOfNext;
        this.setValue(thumbValuesAsArray[0]);
        BVector values = new BVector();
        for (int i = 0; i < thumbValuesAsArray.length; ++i) {
            values.add("thumb" + i, (BValue)BDouble.make((double)thumbValuesAsArray[i]));
        }
        this.setThumbValues(values);
        this.fireValuesModified(new BMultiSliderEvent(602, (BWidget)this, thumbValuesAsArray));
        this.repaint();
        String s = this.valueToString(newValue);
        UiEnv.get().updateBubbleHelp((BWidget)this, event.getX(), event.getY() + 24.0, s);
    }

    private String valueToString(double v) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(0);
        return format.format(v);
    }
}

