/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.platDaemon.ui.config.DaemonBackupJobDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.util.TimeFormat;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.util.Lexicon;

public class BackupDistCommand
extends Command {
    private BDaemonPlatform platform;
    private Context cx;
    private StringBuilder fileName;

    public BackupDistCommand(BWidget owner, BDaemonPlatform platform, Context cx) {
        super(owner, Lexicon.make((String)"platDaemon", (Context)cx), "BackupDistCommand");
        this.cx = cx;
        this.platform = platform;
        this.fileName = new StringBuilder("backup_");
        this.fileName.append(platform.getDaemonSession().getHost().getHostname());
        this.fileName.append("_");
        this.fileName.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYMMDD_HHmm"));
        this.fileName.append(".dist");
    }

    public CommandArtifact doInvoke() {
        try {
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(this.loadDirectoryOrd());
            chooser.setDefaultFileName(this.fileName.toString());
            chooser.addFilter((IFileFilter)new ExtFileFilter(BDistributionFile.TYPE.getDisplayName(this.cx), "dist"));
            BOrd fileOrd = chooser.show();
            this.saveDirectoryOrd(chooser.getCurrentDirectory());
            if (fileOrd != null) {
                DaemonBackupJobDialog.raise(this.getOwner(), (BRemoteDaemonPlatform)this.platform, (BIFile)fileOrd.get(), this.cx);
            }
        }
        catch (Exception e) {
            CommandUtil.error((Command)this, (Throwable)e);
        }
        return null;
    }

    protected BOrd loadDirectoryOrd() {
        return FavoriteDirectory.loadByOrd((String)"platDaemon", (String)"backupDistDirectory", (FilePath)new FilePath("~backups"));
    }

    protected void saveDirectoryOrd(BOrd value) {
        FavoriteDirectory.saveOrd((String)"platDaemon", (String)"backupDistDirectory", (BOrd)value);
    }
}

