/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.job.BJobState;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class RuntimeProfileWizardModel
extends WizardModel {
    private static final BImage WIZ_IMAGE = BImage.make((String)"module://icons/x32/flag.png");
    private static final BImage ENABLED_IMAGE = BImage.make((String)"module://icons/x16/check.png");
    private static final BImage DISABLED_IMAGE = BImage.make((String)"module://icons/x16/delete.png");
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private BDaemonSession session;
    private DaemonSessionTaskHandler sessionTaskHandler;
    private WizardStep currentStep;
    private Set<RuntimeProfile> newRuntimeProfiles;
    private InstallScenario scenario;

    public RuntimeProfileWizardModel(BWidget owner, BDaemonSession session) {
        this.session = session;
        this.sessionTaskHandler = new DaemonSessionTaskHandler(owner);
        this.newRuntimeProfiles = new TreeSet<RuntimeProfile>(session.getHostProperties().getEnabledRuntimeProfiles());
        this.currentStep = new ChooseEnabledProfilesStep();
        ReviewStep reviewStep = new ReviewStep();
        BDaemonPlatform platform = this.getPlatform();
        platform.getModuleList().init((DaemonSessionTaskListener)this.sessionTaskHandler);
        platform.loadPreferredVerificationMode();
        this.currentStep.setNextStep(reviewStep);
        reviewStep.setPriorStep(this.currentStep);
    }

    public String getTitle() {
        return LEX.getText("RuntimeProfileWizard.title");
    }

    public void init() {
        WizardStep step;
        for (step = this.currentStep; step != null && step.isSkipped(); step = step.getNextStep()) {
        }
        this.update(step);
        if (step != null) {
            step.enter();
        }
    }

    public void back() {
        WizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit()) {
            this.update(step);
            step.enter();
        }
    }

    public void next() {
        WizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit()) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            if (step != null) {
                step.setPriorStep(this.getCurrentStep());
                this.update(step);
                step.enter();
            }
        }
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0) {
            return true;
        }
        return BDialog.confirm((BWidget)this.getWizard(), (String)LEX.getText("RuntimeProfileWizard.cancel.title"), (Object)LEX.getText("RuntimeProfileWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(550.0, 300.0);
    }

    public void setWizard(BWizard wizard) {
        super.setWizard(wizard);
        this.sessionTaskHandler.setOwner((BWidget)wizard);
    }

    public boolean finish() {
        if (!this.getCurrentStep().exit()) {
            return false;
        }
        new FinishDialog().open();
        return true;
    }

    public WizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(WizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public BDaemonPlatform getPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.sessionTaskHandler);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Set<RuntimeProfile> getNewRuntimeProfiles() {
        return this.newRuntimeProfiles;
    }

    public InstallScenario getInstallScenario() {
        return this.scenario;
    }

    public void setInstallScenario(InstallScenario value) {
        this.scenario = value;
    }

    private class FinishDialog
    extends TaskDetailDialog
    implements DaemonSessionTaskListener {
        private InstallScenario scenario;
        private String lastText = null;
        private TaskDetailPane.TaskItem stopStations = new TaskDetailPane.TaskItem(RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard.FinishRuntimeProfileChange.item.stopStations"));
        private TaskDetailPane.TaskItem installSoftware = new TaskDetailPane.TaskItem(RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard.FinishRuntimeProfileChange.item.installSoftware"));
        private TaskDetailPane.TaskItem startStations = new TaskDetailPane.TaskItem(RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard.FinishRuntimeProfileChange.item.startStations"));
        private TaskDetailPane.TaskItem reboot = new TaskDetailPane.TaskItem(RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard.FinishRuntimeProfileChange.item.reboot"));
        private TaskDetailPane.TaskItem[] items;

        public FinishDialog() {
            try {
                this.scenario = RuntimeProfileWizardModel.this.getInstallScenario();
                this.items = ((this.scenario.getProcessingFlags() & 2L) > 0L || (this.scenario.getProcessingFlags() & 1L) > 0L || (this.scenario.getProcessingFlags() & 4L) > 0L) && BStationSurrogate.isAnyStationRunning((BDaemonSession)RuntimeProfileWizardModel.this.session) ? (RuntimeProfileWizardModel.this.session.getHostProperties().getAllowStationRestart() ? new TaskDetailPane.TaskItem[]{this.stopStations, this.installSoftware, this.startStations} : new TaskDetailPane.TaskItem[]{this.stopStations, this.installSoftware, this.reboot}) : new TaskDetailPane.TaskItem[]{this.installSoftware};
                this.init((BWidget)RuntimeProfileWizardModel.this.getWizard());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public String getHeadingTitle() {
            return RuntimeProfileWizardModel.this.getTitle();
        }

        @Override
        public String getDialogTitle() {
            return RuntimeProfileWizardModel.this.getTitle();
        }

        @Override
        public BImage getHeadingIcon() {
            return WIZ_IMAGE;
        }

        @Override
        public String getItemListHeading() {
            return LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.itemHeading");
        }

        @Override
        public TaskDetailPane.TaskItem[] makeTaskItems() {
            return this.items;
        }

        public void taskStarted(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
            if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
                this.setCancelEnabled(false);
            }
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        @Override
        public void run() {
            try {
                BStationSurrogate[] stopped = new BStationSurrogate[]{};
                if (((this.scenario.getProcessingFlags() & 2L) > 0L || (this.scenario.getProcessingFlags() & 4L) > 0L) && BStationSurrogate.isAnyStationRunning((BDaemonSession)RuntimeProfileWizardModel.this.session)) {
                    this.setCurrentItem(this.stopStations, BJobState.running);
                    this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.stoppingAllStations"));
                    this.getLog().append("\n");
                    stopped = BStationSurrogate.stopAllStations((BDaemonSession)RuntimeProfileWizardModel.this.session, (ICancelHint)this, null);
                    this.checkCanceled();
                    this.updateCurrentItemState(BJobState.success);
                }
                this.setCurrentItem(this.installSoftware, BJobState.running);
                this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.installingSoftware"));
                this.getLog().append("\n");
                RuntimeProfileWizardModel.this.getInstallScenario().commit((DaemonSessionTaskListener)this, (ICancelHint)this);
                this.updateCurrentItemState(BJobState.success);
                if (stopped.length > 0) {
                    if (RuntimeProfileWizardModel.this.session.getHostProperties().getAllowStationRestart()) {
                        this.setCurrentItem(this.startStations, BJobState.running);
                        for (BStationSurrogate station : stopped) {
                            station.startStationAsync();
                            this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.stationStarted", new Object[]{station.getStationName()}));
                            this.getLog().append("\n");
                        }
                    } else {
                        this.setCurrentItem(this.reboot, BJobState.running);
                        this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.reboot"));
                        this.getLog().append("\n");
                        RuntimeProfileWizardModel.this.session.sendRebootRequest();
                    }
                }
                this.updateCurrentItemState(BJobState.success);
                this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.complete"));
                this.setBottomLabelText(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.complete"));
            }
            catch (ICancelHint.CanceledException ce) {
                this.cancel(false);
                this.getLog().append(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.canceled"));
                this.setBottomLabelText(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.canceled"));
            }
            catch (Throwable t) {
                this.setCancelEnabled(true);
                this.updateCurrentItemState(BJobState.failed);
                t.printStackTrace();
                this.getLog().append(t);
                this.setBottomLabelText(LEX.getText("RuntimeProfileWizard.FinishRuntimeProfileChange.failed"));
            }
        }
    }

    private class ChooseEnabledProfilesStep
    extends WizardStep {
        private Map<RuntimeProfile, BCheckBox> checkBoxByRuntimeProfile;

        public ChooseEnabledProfilesStep() {
            this.checkBoxByRuntimeProfile = new TreeMap<RuntimeProfile, BCheckBox>();
            BGridPane content = new BGridPane(1);
            content.setValign(BValign.top);
            content.setHalign(BHalign.left);
            content.add(null, (BValue)new BLabel(LEX.getText("RuntimeProfileWizard.ChooseEnabledProfilesStep.heading"), BHalign.left));
            for (final RuntimeProfile profile : RuntimeProfile.values()) {
                ToggleCommand cmd = new ToggleCommand((BWidget)content, Lexicon.make((String)"platDaemon", (Context)RuntimeProfileWizardModel.this.session.getSessionContext()).getText(String.format("RuntimeProfile.%s.long", profile.name())), null, null, Lexicon.make((String)"platDaemon", (Context)RuntimeProfileWizardModel.this.session.getSessionContext()).getText(String.format("RuntimeProfile.%s.long", profile.name()))){
                    private RuntimeProfile cmdProfile;
                    {
                        super(x0, x1, x2, x3, x4);
                        this.cmdProfile = profile;
                    }

                    public synchronized void setSelected(boolean selected) {
                        super.setSelected(selected);
                        if (selected && this.cmdProfile.equals((Object)RuntimeProfile.wb)) {
                            ((BCheckBox)ChooseEnabledProfilesStep.this.checkBoxByRuntimeProfile.get(RuntimeProfile.ux)).setSelected(true);
                        } else if (selected && this.cmdProfile.equals((Object)RuntimeProfile.ux)) {
                            ((BCheckBox)ChooseEnabledProfilesStep.this.checkBoxByRuntimeProfile.get(RuntimeProfile.wb)).setSelected(true);
                        } else if (!selected && this.cmdProfile.equals((Object)RuntimeProfile.ux)) {
                            ((BCheckBox)ChooseEnabledProfilesStep.this.checkBoxByRuntimeProfile.get(RuntimeProfile.wb)).setSelected(false);
                        } else if (!selected && this.cmdProfile.equals((Object)RuntimeProfile.wb)) {
                            ((BCheckBox)ChooseEnabledProfilesStep.this.checkBoxByRuntimeProfile.get(RuntimeProfile.ux)).setSelected(false);
                        }
                    }
                };
                BCheckBox checkBox = new BCheckBox(cmd);
                content.add(null, (BValue)checkBox);
                this.checkBoxByRuntimeProfile.put(profile, checkBox);
            }
            for (Map.Entry entry : this.checkBoxByRuntimeProfile.entrySet()) {
                switch (RuntimeProfileWizardModel.this.session.getHostProperties().getSupportForRuntimeProfile((RuntimeProfile)entry.getKey())) {
                    case required: {
                        ((BCheckBox)entry.getValue()).setEnabled(false);
                        ((BCheckBox)entry.getValue()).setSelected(true);
                        break;
                    }
                    case optional: {
                        ((BCheckBox)entry.getValue()).setEnabled(true);
                        ((BCheckBox)entry.getValue()).setSelected(false);
                        break;
                    }
                    case unsupported: {
                        ((BCheckBox)entry.getValue()).setEnabled(false);
                        ((BCheckBox)entry.getValue()).setSelected(false);
                    }
                }
            }
            this.setContent((BWidget)content);
        }

        @Override
        public String getStepName() {
            return "ChooseEnabledProfilesStep";
        }

        @Override
        public int getMode() {
            return 2;
        }

        @Override
        public void enter() {
            for (Map.Entry<RuntimeProfile, BCheckBox> entry : this.checkBoxByRuntimeProfile.entrySet()) {
                entry.getValue().setSelected(RuntimeProfileWizardModel.this.newRuntimeProfiles.contains(entry.getKey()));
            }
        }

        @Override
        public boolean exit() {
            RuntimeProfileWizardModel.this.newRuntimeProfiles = this.checkBoxByRuntimeProfile.entrySet().stream().filter(entry -> ((BCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
            return true;
        }
    }

    private class ReviewStep
    extends WizardStep {
        private int mode;
        private SolutionParameters solutionParameters;
        private BIndentPane pane;

        public ReviewStep() {
            this.mode = 0;
            this.solutionParameters = new SolutionParameters((DaemonSessionTaskListener)RuntimeProfileWizardModel.this.sessionTaskHandler);
            this.pane = new BIndentPane();
            BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.pane, 3.0, 3.0, 3.0, 3.0));
            scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            this.setContent((BWidget)scrollPane);
        }

        @Override
        public String getStepName() {
            return "ReviewStep";
        }

        @Override
        public int getMode() {
            return this.mode;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void enter() {
            try {
                RuntimeProfileWizardModel.this.setInstallScenario(new InstallScenario(RuntimeProfileWizardModel.this.getPlatform(), null, DependencyUtil.getPlatformDependencies((BDaemonPlatform)RuntimeProfileWizardModel.this.getPlatform(), RuntimeProfileWizardModel.this.getNewRuntimeProfiles()), null, null, null, null, RuntimeProfileWizardModel.this.getNewRuntimeProfiles(), this.solutionParameters, (InstallableRegistry)LocalInstallableRegistry.getInstance(), CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)RuntimeProfileWizardModel.this.getPlatform()))).solve());
                this.pane.removeAll();
                this.pane.unindentAll();
                if (RuntimeProfileWizardModel.this.getInstallScenario().canCommit()) {
                    this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.profiles.header"));
                    this.pane.indent();
                    for (RuntimeProfile runtimeProfile : RuntimeProfile.values()) {
                        BImage iconImage = RuntimeProfileWizardModel.this.getNewRuntimeProfiles().contains(runtimeProfile) ? ENABLED_IMAGE : DISABLED_IMAGE;
                        this.pane.add((BWidget)new BLabel(iconImage, LEX.getText(String.format("RuntimeProfile.%s.long", runtimeProfile.name()))));
                    }
                    this.pane.unindent();
                    if (RuntimeProfileWizardModel.this.getInstallScenario().getToInstall().length > 0) {
                        this.pane.add((BWidget)new BBox(0.0, 5.0));
                        this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.toInstall.header"));
                        this.pane.indent();
                        for (BInstallable bInstallable : RuntimeProfileWizardModel.this.getInstallScenario().getToInstall()) {
                            this.pane.add((BWidget)new BLabel(BImage.make((BIcon)bInstallable.getIcon()), bInstallable.getInstallableFileName()));
                        }
                        this.pane.unindent();
                    }
                    if (RuntimeProfileWizardModel.this.getInstallScenario().getModulesToUninstall().length > 0) {
                        this.pane.add((BWidget)new BBox(0.0, 5.0));
                        this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.toUninstall.header"));
                        this.pane.indent();
                        for (String string : RuntimeProfileWizardModel.this.getInstallScenario().getModulesToUninstall()) {
                            this.pane.add((BWidget)new BLabel(BImage.make((BIcon)BIcon.std((String)"module.png")), string));
                        }
                        this.pane.unindent();
                    }
                    this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.footer"));
                    this.mode = 5;
                } else {
                    boolean bl;
                    UnmeetableDependency dep;
                    void var4_19;
                    boolean bl2 = false;
                    UnmeetableDependency[] unmeetableDependencyArray = RuntimeProfileWizardModel.this.getInstallScenario().getUnmeetableDependencies();
                    int n = unmeetableDependencyArray.length;
                    boolean bl3 = false;
                    while (var4_19 < n) {
                        dep = unmeetableDependencyArray[var4_19];
                        if (dep.isUnsolvable) {
                            bl = true;
                            break;
                        }
                        ++var4_19;
                    }
                    if (bl) {
                        this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.mustCommission.header"));
                    } else {
                        void var4_21;
                        this.pane.add(LexiconText.make((String)"platDaemon", (String)"RuntimeProfileWizard.ReviewStep.unmeetable.header"));
                        this.pane.indent();
                        unmeetableDependencyArray = RuntimeProfileWizardModel.this.getInstallScenario().getUnmeetableDependencies();
                        n = unmeetableDependencyArray.length;
                        boolean bl4 = false;
                        while (var4_21 < n) {
                            dep = unmeetableDependencyArray[var4_21];
                            this.pane.add((BWidget)new BLabel(BImage.make((BIcon)dep.getIcon()), dep.toString()));
                            ++var4_21;
                        }
                        this.pane.unindent();
                    }
                    this.mode = 1;
                }
                RuntimeProfileWizardModel.this.update(this);
            }
            catch (RuntimeException runtimeException) {
                this.mode = 1;
                RuntimeProfileWizardModel.this.update(this);
                throw runtimeException;
            }
            catch (Exception exception) {
                this.mode = 1;
                RuntimeProfileWizardModel.this.update(this);
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public abstract class WizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(RuntimeProfileWizardModel.access$000(), RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard.headerTitle"), RuntimeProfileWizardModel.access$100().getText("RuntimeProfileWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private WizardStep priorStep = null;
        private WizardStep nextStep = null;

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget content) {
            this.contentPane.setCenter(content);
        }

        public int getMode() {
            return 0;
        }

        public WizardStep getPriorStep() {
            return this.priorStep;
        }

        public WizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(WizardStep step) {
            this.nextStep = step;
        }

        public void enter() {
        }

        public boolean exit() {
            return true;
        }

        public void setPriorStep(WizardStep step) {
            this.priorStep = step;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

