/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import java.net.ConnectException;
import java.security.AccessController;
import javax.baja.gx.BColor;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SystemPasswordPrompt {
    BDaemonSession daemonSession;
    BOptionDialog dialog;
    BLabel noticeLabel;
    BPasswordFE currentPasswordFE;
    BPasswordFE newPasswordFE1;
    BPasswordFE newPasswordFE2;
    BCheckBox fipsModeCheckBox = null;
    static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static boolean updateSettings(BWidget owner, BDaemonSession session) {
        block16: {
            try {
                SharedSecretKey sharedKey;
                BPassword npw2;
                BPassword npw1;
                BPassword opw;
                SystemPasswordPrompt prompt;
                block18: {
                    block17: {
                        boolean systemPasswordReadonly;
                        boolean factoryDefaultSystemPassword;
                        try {
                            XElem systemPasswordElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
                            factoryDefaultSystemPassword = systemPasswordElem.getb("default", false);
                            systemPasswordReadonly = systemPasswordElem.getb("readonly", false);
                        }
                        catch (Exception ignored) {
                            factoryDefaultSystemPassword = false;
                            systemPasswordReadonly = false;
                        }
                        if (systemPasswordReadonly) {
                            BDialog.error((BWidget)owner, (Object)lex.getText("SystemPassword.error.readonly"));
                            return false;
                        }
                        BOptionDialog dialog = new BOptionDialog(owner, lex.getText("SystemPasswordPrompt.dlgTitle"), (BWidget)new BNullWidget(), 3, null, null);
                        prompt = new SystemPasswordPrompt(dialog, session);
                        if (factoryDefaultSystemPassword) {
                            prompt.noticeLabel.setVisible(true);
                        }
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        if (dialog.getResult() != 1) break block16;
                        opw = (BPassword)prompt.currentPasswordFE.saveValue();
                        npw1 = (BPassword)prompt.newPasswordFE1.saveValue();
                        npw2 = (BPassword)prompt.newPasswordFE2.saveValue();
                        if (opw == null) break block17;
                        if (AccessController.doPrivileged(() -> ((BPassword)opw).getValue()).trim().length() == 0 || npw1 == null) break block17;
                        if (AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()).trim().length() == 0 || npw2 == null) break block17;
                        if (AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()).trim().length() != 0) break block18;
                    }
                    BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.fieldRequired"));
                    return false;
                }
                if (!BNativeUserTable.validatePassword(owner, npw1, prompt.getPasswordStrength())) {
                    return false;
                }
                try {
                    sharedKey = session.generateSharedSecretKey("passwordPrompt");
                }
                catch (ConnectException e) {
                    BDialog.error((BWidget)owner, (Object)lex.getText("SharedKey.error.couldNotNegotiate"));
                    return false;
                }
                if (new Version(session.getHostProperties().getDaemonVersion()).compareTo(new Version("4.0.17.7.650")) != -1 && !BNativeUserTable.checkStatus(null, session, (XmlResponseMessage)new SystemPasswordMessage(null, opw, true, sharedKey))) {
                    BDialog.error((BWidget)owner, (Object)lex.getText("SystemPassword.error.badPassword"));
                    return false;
                }
                if (!BNativeUserTable.checkStatus(null, session, (XmlResponseMessage)new SystemPasswordMessage(npw1, null, true, sharedKey))) {
                    BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.invalidPasswordDefault"));
                    return false;
                }
                if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()))) {
                    BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.passwordMismatch"));
                    return false;
                }
                session.sendMessage((DaemonMessage)new SystemPasswordMessage(npw1, opw, false, sharedKey));
                boolean isFips = prompt.fipsModeCheckBox != null && prompt.fipsModeCheckBox.getSelected();
                FipsOptionsHelper.getInstance().updateSystemPassphraseCookie(isFips, session);
                BDialog.info((BWidget)owner, (Object)lex.getText("UserManager.success.passwordChanged"));
                return true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return false;
    }

    private SystemPasswordPrompt(BOptionDialog dialog, BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
        this.dialog = dialog;
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)new BLabel(lex.getText("SystemPasswordPrompt.description"), BHalign.left));
        this.noticeLabel = new BLabel(lex.getText("SystemPasswordPrompt.defaultNotice"), BHalign.left);
        content.add(null, (BValue)this.noticeLabel);
        this.noticeLabel.setForeground(BColor.red.toBrush());
        this.noticeLabel.setVisible(false);
        BGridPane editors = new BGridPane(2);
        this.currentPasswordFE = new BPasswordFE();
        this.newPasswordFE1 = new BPasswordFE();
        this.newPasswordFE2 = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)editors, (String)lex.getText("SystemPasswordPrompt.label.currentpassword"), (BWidget)this.currentPasswordFE);
        LabelUtil.addLabelWidgetPair((BPane)editors, (String)lex.getText("SystemPasswordPrompt.label.newpassword"), (BWidget)this.newPasswordFE1);
        LabelUtil.addLabelWidgetPair((BPane)editors, (String)lex.getText("SystemPasswordPrompt.label.newpassword2"), (BWidget)this.newPasswordFE2);
        content.add(null, (BValue)editors);
        if (FipsOptionsHelper.getInstance().showFipsOption(daemonSession)) {
            this.fipsModeCheckBox = new BCheckBox(lex.getText("SystemPasswordPrompt.label.fipsMode"));
            this.fipsModeCheckBox.setSelected(FipsOptionsHelper.getInstance().checkFipsOption(daemonSession));
            this.fipsModeCheckBox.setEnabled(!FipsOptionsHelper.getInstance().fipsOptionReadOnly(daemonSession));
            content.add(null, (BValue)this.fipsModeCheckBox);
        }
        dialog.setContent((BWidget)new BBorderPane((BWidget)content, 6.0, 6.0, 6.0, 6.0));
    }

    private BPasswordStrength getPasswordStrength() {
        return FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.fipsModeCheckBox != null && this.fipsModeCheckBox.getSelected(), this.daemonSession);
    }
}

