/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.console;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.appsurrogate.BAppSurrogateView;
import com.tridium.platDaemon.ui.appsurrogate.BStationSurrogateView;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BApplicationDirector
extends BDaemonSessionView {
    @Generated
    public static final Type TYPE = Sys.loadType(BApplicationDirector.class);
    public static BIcon ICON = BIcon.std((String)"navOnly/applicationDirector.png");
    private BTable table;
    private BLabel hostLabel;
    private AppSurrogateTableModel tableModel;
    private BSplitPane contentPane = new BSplitPane(BOrientation.vertical, -1.0);
    private boolean isActivated = false;
    private boolean inRefresh = false;
    private Object selectionToRestore = null;
    private BBorderPane appViewParent;
    BAppSurrogateView appView;
    private BStationSurrogateView stationView;
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    public static final int APP_NAME_COL = 0;
    public static final int APP_TYPE_COL = 1;
    public static final int APP_STATUS_COL = 2;
    public static final int MISC_COL = 3;
    public static final int AUTO_START_COL = 4;
    public static final int AUTO_RESTART_COL = 5;
    public static final ArrayList<Comparator<BAppSurrogate>> columnComparators = new ArrayList(6);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BApplicationDirector() {
        BEdgePane topPane = new BEdgePane();
        this.hostLabel = new BLabel("");
        topPane.setTop((BWidget)new BBorderPane((BWidget)this.hostLabel, 0.0, 0.0, 3.0, 0.0));
        this.hostLabel.setHalign(BHalign.left);
        this.tableModel = new AppSurrogateTableModel();
        this.table = new BTable((TableModel)this.tableModel, (TableController)new AppSurrogateTableController());
        this.table.setMultipleSelection(false);
        topPane.setCenter((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.none, BInsets.DEFAULT));
        this.contentPane.setWidget1((BWidget)new BBorderPane((BWidget)topPane, 3.0, 3.0, 0.0, 3.0));
        this.table.setSelection((TableSelection)new AppSurrogateTableSelection());
        this.stationView = new BStationSurrogateView(this);
        this.appView = this.stationView;
        this.setTransferWidget(this.appView.getTransferWidget());
        this.appViewParent = new BBorderPane((BWidget)this.appView, 3.0, 3.0, 0.0, 3.0);
        this.contentPane.setWidget2((BWidget)this.appViewParent);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)this.contentPane));
    }

    private void setAppView(BAppSurrogateView value) {
        if (this.appView != value) {
            this.appView = value;
            this.setTransferWidget(this.appView.getTransferWidget());
            this.appViewParent.setContent((BWidget)this.appView);
        }
    }

    private BAppSurrogateView getAppView(BAppSurrogate surrogate) {
        if (surrogate instanceof BStationSurrogate) {
            return this.stationView;
        }
        return null;
    }

    private void loadAppSurrogate(BAppSurrogate surrogate) {
        this.setAppView(this.getAppView(surrogate));
        this.appView.loadValue((BObject)surrogate);
    }

    public void activated() {
        super.activated();
        if (this.getCurrentValue() != null && this.isRunning()) {
            this.startRefreshTimer();
        }
        this.appView.activated();
        this.isActivated = true;
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
        this.appView.deactivated();
        this.isActivated = false;
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        this.hostLabel.setText(lex.getText("ApplicationDirector.label.connectedTo", new Object[]{session.getRemoteAddressString()}));
        this.inRefresh = true;
        this.startRefreshTimer();
        try {
            this.stationView.init(session, this.getCurrentValue());
            this.tableModel.loadApps();
            int rowToSelect = -1;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                BStationStatus status = this.tableModel.getAppSurrogate(i).getAppStatus();
                if (status == BStationStatus.running || status == BStationStatus.starting) {
                    rowToSelect = i;
                    break;
                }
                if (status != BStationStatus.failed || rowToSelect >= 0) continue;
                rowToSelect = i;
            }
            if (rowToSelect < 0) {
                rowToSelect = 0;
            }
            this.table.getSelection().select(rowToSelect);
        }
        catch (ConnectException rowToSelect) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            this.inRefresh = false;
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.isActivated && this.getCurrentValue() != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopRefreshTimer();
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public void doRefresh() {
        if (this.inRefresh) {
            return;
        }
        try {
            this.inRefresh = true;
            this.tableModel.loadApps();
        }
        catch (ConnectException ce) {
            this.stopRefreshTimer();
        }
        catch (AuthenticationException ae) {
            this.reauthenticate(ae);
        }
        finally {
            this.inRefresh = false;
        }
    }

    public BAppSurrogate getSelectedAppSurrogate() {
        int row = this.table.getSelection().getRow();
        return row < 0 ? null : this.tableModel.getAppSurrogate(row);
    }

    static {
        columnComparators.add(0, (s1, s2) -> {
            int result = s1.getAppName().compareTo(s2.getAppName());
            if (result == 0) {
                result = s1.getType().getDisplayName(null).compareTo(s2.getType().getDisplayName(null));
            }
            return result;
        });
        columnComparators.add(1, (s1, s2) -> {
            if (s1.getType().equals(s2.getType())) {
                return columnComparators.get(0).compare((BAppSurrogate)s1, (BAppSurrogate)s2);
            }
            String appType1 = lex.getText("ApplicationDirector.column.appType." + s1.getAppTypeString());
            String appType2 = lex.getText("ApplicationDirector.column.appType." + s2.getAppTypeString());
            return appType1.compareTo(appType2);
        });
        columnComparators.add(2, (s1, s2) -> {
            int result = s1.getAppStatus().toString().compareTo(s2.getAppStatus().toString());
            if (result == 0) {
                return columnComparators.get(0).compare((BAppSurrogate)s1, (BAppSurrogate)s2);
            }
            return result;
        });
        columnComparators.add(3, (s1, s2) -> 0);
        columnComparators.add(4, (s1, s2) -> {
            int result = String.valueOf(s1.getIsAutoStart()).compareTo(String.valueOf(s2.getIsAutoStart()));
            if (result == 0) {
                return columnComparators.get(0).compare((BAppSurrogate)s1, (BAppSurrogate)s2);
            }
            return result;
        });
        columnComparators.add(5, (s1, s2) -> {
            int result = String.valueOf(s1.getIsAutoRestart()).compareTo(String.valueOf(s2.getIsAutoRestart()));
            if (result == 0) {
                return columnComparators.get(0).compare((BAppSurrogate)s1, (BAppSurrogate)s2);
            }
            return result;
        });
    }

    private class AppSurrogateTableModel
    extends TableModel {
        private Array<BAppSurrogate> apps = new Array(BAppSurrogate.class);
        private boolean tableLoaded = false;
        private int sortCol = -1;
        private boolean sortAsc = true;

        private AppSurrogateTableModel() {
        }

        public synchronized void loadApps() throws ConnectException, AuthenticationException {
            if (BApplicationDirector.this.getCurrentValue() == null) {
                return;
            }
            if (this.getTable().getSelection().getRow() >= 0) {
                if (this.apps.size() > this.getTable().getSelection().getRow()) {
                    BApplicationDirector.this.selectionToRestore = this.apps.get(this.getTable().getSelection().getRow());
                } else {
                    BApplicationDirector.this.selectionToRestore = null;
                }
            }
            Array data = new Array(BAppSurrogate.class);
            data.addAll((Object[])BApplicationDirector.this.getAppSurrogatesWithExceptions());
            this.sort((Array<BAppSurrogate>)data, !this.tableLoaded);
            if (!this.tableLoaded) {
                BApplicationDirector.this.contentPane.getWidget1().computePreferredSize();
                BApplicationDirector.this.relayoutSync();
                int totalHeight = (int)BApplicationDirector.this.getHeight();
                if (totalHeight != 0) {
                    double minSplitPositionForBottom = (double)(totalHeight - BApplicationDirector.this.appView.getMinHeight()) - BApplicationDirector.this.contentPane.getDividerWidth() - 6.0;
                    double minSplitPositionForTop = BApplicationDirector.this.tableModel.getMinimumHeight() + BApplicationDirector.this.hostLabel.getPreferredHeight() + 6.0;
                    double preferredSplitPosition = Math.max(minSplitPositionForBottom, minSplitPositionForTop);
                    double absolutePos = Math.min(BApplicationDirector.this.contentPane.getWidget1().getPreferredHeight(), preferredSplitPosition);
                    if (absolutePos > BApplicationDirector.this.contentPane.getHeight()) {
                        BApplicationDirector.this.contentPane.setDividerPosition(25.0);
                    } else {
                        BApplicationDirector.this.contentPane.setAbsoluteDividerLocation(absolutePos);
                    }
                    BApplicationDirector.this.contentPane.relayout();
                    this.tableLoaded = true;
                }
            }
        }

        private synchronized void sort(Array<BAppSurrogate> data, boolean resizeColumns) {
            if (this.sortCol < 0) {
                this.apps = data;
                this.updateTable(resizeColumns);
                BApplicationDirector.this.selectionToRestore = null;
                this.getTable().getSelection().select(this.getTable().getSelection().getRow(), true);
            } else {
                if (BApplicationDirector.this.selectionToRestore == null && this.getTable().getSelection().getRow() >= 0) {
                    BApplicationDirector.this.selectionToRestore = data.get(this.getTable().getSelection().getRow());
                }
                data = this.sortAsc ? data.sort(columnComparators.get(this.sortCol)) : data.sort((o1, o2) -> -1 * columnComparators.get(this.sortCol).compare((BAppSurrogate)o1, (BAppSurrogate)o2));
                this.apps = data;
                this.updateTable(resizeColumns);
                if (BApplicationDirector.this.selectionToRestore != null) {
                    for (int i = 0; i < data.size(); ++i) {
                        if (BApplicationDirector.this.selectionToRestore != data.get(i)) continue;
                        BApplicationDirector.this.selectionToRestore = null;
                        this.getTable().getSelection().select(i, true);
                        break;
                    }
                }
            }
            BApplicationDirector.this.selectionToRestore = null;
        }

        public int getRowCount() {
            return this.apps.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public boolean isColumnSortable(int col) {
            return col != 3;
        }

        public synchronized void sortByColumn(int col, boolean ascending) {
            if (this.sortCol != col || ascending != this.sortAsc) {
                this.sortCol = col;
                this.sortAsc = ascending;
                this.sort(this.apps, false);
            }
        }

        public BAppSurrogate getAppSurrogate(int row) {
            return (BAppSurrogate)this.apps.get(row);
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("ApplicationDirector.column.appName");
                }
                case 1: {
                    return lex.getText("ApplicationDirector.column.appType");
                }
                case 4: {
                    return lex.getText("ApplicationDirector.column.isAutoStart");
                }
                case 5: {
                    return lex.getText("ApplicationDirector.column.isAutoRestart");
                }
                case 3: {
                    return lex.getText("ApplicationDirector.column.misc");
                }
                case 2: {
                    return lex.getText("ApplicationDirector.column.appStatus");
                }
            }
            throw new IllegalArgumentException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getAppSurrogate(row).getAppName();
                }
                case 1: {
                    return lex.getText("ApplicationDirector.column.appType." + this.getAppSurrogate(row).getAppTypeString());
                }
                case 4: {
                    return BBoolean.make((boolean)this.getAppSurrogate(row).getIsAutoStart()).toString();
                }
                case 5: {
                    return BBoolean.make((boolean)this.getAppSurrogate(row).getIsAutoRestart()).toString();
                }
                case 3: {
                    return BApplicationDirector.this.getAppView(this.getAppSurrogate(row)).getExtraDetails(this.getAppSurrogate(row), null);
                }
                case 2: {
                    return this.getAppSurrogate(row).getAppStatus();
                }
            }
            throw new IllegalArgumentException();
        }

        public double getMinimumHeight() {
            double minimumHeight = this.getTable().getHeaderRenderer().getHeaderHeight();
            if (this.getRowCount() > 0) {
                minimumHeight += this.getTable().getCellRenderer().getCellHeight();
            }
            return minimumHeight;
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)this.getAppSurrogate(row).getIcon());
        }
    }

    private class AppSurrogateTableController
    extends TableController {
        private AppSurrogateTableController() {
        }

        protected void cellPressed(BMouseEvent evt, int row, int column) {
            super.cellPressed(evt, row, column);
            if (evt.getClickCount() != 2) {
                return;
            }
            BAppSurrogate surrogate = BApplicationDirector.this.tableModel.getAppSurrogate(row);
            if (surrogate.getAppStatus() == BStationStatus.running && surrogate instanceof BStationSurrogate) {
                if (((BStationSurrogate)surrogate).getFoxsPort() != -1) {
                    BApplicationDirector.this.getWbShell().hyperlink(new HyperlinkInfo(((BStationSurrogate)surrogate).getFoxsOrd(), (BInputEvent)evt));
                } else if (((BStationSurrogate)surrogate).getFoxPort() != -1) {
                    BApplicationDirector.this.getWbShell().hyperlink(new HyperlinkInfo(((BStationSurrogate)surrogate).getFoxOrd(), (BInputEvent)evt));
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.startCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.stopCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.restartCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.killCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BApplicationDirector.this.appView.clearOutputCommand), null);
            menu.open((BWidget)BApplicationDirector.this.table, event.getX(), event.getY());
        }
    }

    private class AppSurrogateTableSelection
    extends TableSelection {
        private AppSurrogateTableSelection() {
        }

        public void updateTable() {
            if (BApplicationDirector.this.selectionToRestore == null) {
                if (this.isEmpty()) {
                    BApplicationDirector.this.appView.clearValue();
                } else {
                    BApplicationDirector.this.loadAppSurrogate(BApplicationDirector.this.tableModel.getAppSurrogate(this.getRow()));
                }
            }
            super.updateTable();
        }
    }
}

