/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.nre.util.LicenseMode;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platDaemon.ui.distinstall.HostIdCheckStep;
import com.tridium.platDaemon.ui.distinstall.StopAppsStep;
import com.tridium.platDaemon.ui.distinstall.TcpIpStep;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import java.util.HashSet;
import javax.baja.gx.BImage;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.xml.XElem;

public class DependenciesStep
extends DistInstallWizardStep {
    private int mode;
    private boolean skipped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependenciesStep(DistInstallWizardModel model) {
        super(model);
        BWidgetShell shell = model.getOwner().getShell();
        BDialog dlg = new BDialog(model.getOwner(), this.getLexicon().getText("DependenciesStep.analyzing.title"), false, (BWidget)new BBorderPane((BWidget)new BLabel(this.getLexicon().getText("DependenciesStep.analyzing.message"), BHalign.left), 10.0, 10.0, 10.0, 10.0));
        try {
            XElem platformElem;
            HashSet<RuntimeProfile> updatedRuntimeProfiles;
            this.mode = 0;
            if (shell != null) {
                shell.enterBusy();
            }
            dlg.setBoundsCenteredOnOwner();
            dlg.open();
            BDistribution dist = this.getWizardModel().getDistribution();
            BDaemonPlatform targetPlatform = model.getPlatform();
            targetPlatform.loadPreferredVerificationMode();
            if (dist.getUpdateRuntimeProfilesEnabled()) {
                updatedRuntimeProfiles = new HashSet<RuntimeProfile>();
                for (String profileName : dist.getEnabledRuntimeProfileNames().split(",")) {
                    updatedRuntimeProfiles.add(RuntimeProfile.valueOf((String)profileName));
                }
            } else {
                updatedRuntimeProfiles = targetPlatform.getEnabledRuntimeProfiles();
            }
            BDependency[] allDeps = dist.getIsStandalone() ? new BDependency[]{} : ((platformElem = dist.getUpdatedPlatformBog(targetPlatform)) == null ? DependencyUtil.getPlatformDependencies((BDaemonPlatform)targetPlatform, updatedRuntimeProfiles) : DependencyUtil.getBogModuleDeps((XElem)platformElem, updatedRuntimeProfiles, (boolean)targetPlatform.getIsNiagara4()));
            CertificateChainValidator certificateChainValidator = CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)targetPlatform));
            certificateChainValidator.setLaxValidation(dist.getInstallableName().equals("backupdist"));
            InstallScenario requiredScenario = InstallScenario.solve((BDaemonPlatform)targetPlatform, (DaemonSessionTaskListener)model.getTaskHandler(), null, (BDependency[])allDeps, (BInstallable[])new BInstallable[]{dist}, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)certificateChainValidator);
            if (!requiredScenario.canCommit()) {
                if (requiredScenario.getExcludedInstallables().length > 0) {
                    this.formatExcluded(requiredScenario);
                    this.mode = 0;
                    model.setDependenciesVerified(false);
                    return;
                }
                this.formatUnavailable(requiredScenario);
                this.mode = 0;
                model.setDependenciesVerified(false);
                return;
            }
            model.setRequiredScenario(requiredScenario);
            this.mode = 4;
            model.setDependenciesVerified(true);
            if (requiredScenario.getToInstall().length == 1) {
                this.skipped = true;
                this.getWizardModel().setDependenciesVerified(true);
            } else {
                this.formatRequiredSoftware(requiredScenario);
            }
            long flags = requiredScenario.getProcessingFlags();
            DistInstallWizardStep tail = this;
            LicenseMode remoteLicenseMode = model.getSession().getHostProperties().getHostIdSettings().getLicenseMode();
            if (dist.getLicenseMode().equals("Subscription") && remoteLicenseMode == LicenseMode.SUBSCRIPTION) {
                HostIdCheckStep hostIdCheckStep = new HostIdCheckStep(model, dist.getHostId());
                tail.setNextStep(hostIdCheckStep);
                hostIdCheckStep.setPriorStep(tail);
                tail = hostIdCheckStep;
                this.mode = 2;
            }
            if ((flags & 1L) != 0L || (flags & 2L) != 0L || (flags & 4L) != 0L) {
                StopAppsStep stopAppsStep = new StopAppsStep(model, (flags & 1L) != 0L);
                tail.setNextStep(stopAppsStep);
                stopAppsStep.setPriorStep(tail);
                tail = stopAppsStep;
                this.mode = 2;
            }
            if ((flags & 0x80000L) != 0L) {
                BTcpIpHostSettings changes = model.getDistribution().getTcpIpChanges();
                BTcpIpHostSettings targetPlatformSettings = new BTcpIpHostSettings();
                TcpUtil.loadFromSession((BTcpIpHostSettings)targetPlatformSettings, (BDaemonSession)model.getSession());
                model.setUpdateTcpIp(false);
                if (changes != null && !changes.getIsReadonly() && !targetPlatformSettings.getIsReadonly()) {
                    TcpIpStep tcpIpStep = new TcpIpStep(model);
                    tail.setNextStep(tcpIpStep);
                    tcpIpStep.setPriorStep(tail);
                    this.mode = 2;
                }
            }
        }
        catch (Throwable t) {
            this.setContent((BWidget)new BTextOutputPane(t));
            this.mode = 0;
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
            dlg.close();
        }
    }

    @Override
    public String getStepName() {
        return "DependenciesStep";
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean exit() {
        return true;
    }

    @Override
    public int getMode() {
        if (this.mode == 2) {
            DistInstallWizardStep next;
            for (next = this.getNextStep(); next != null && next.isSkipped(); next = next.getNextStep()) {
            }
            if (next == null) {
                return 4;
            }
        }
        return this.mode;
    }

    private void formatExcluded(InstallScenario scenario) {
        BIndentPane pane = new BIndentPane();
        pane.add(this.getLexiconText("DependenciesStep.excludedHeader"));
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 3.0, 3.0, 3.0, 3.0));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)scroll);
    }

    private void formatUnavailable(InstallScenario scenario) {
        Array unmetSet = new Array((Object[])scenario.getUnmeetableDependencies());
        unmetSet = unmetSet.sort(Comparator.comparing(UnmeetableDependency::toString));
        BIndentPane pane = new BIndentPane();
        pane.add(this.getLexiconText("DependenciesStep.unavailableHeader"));
        pane.indent();
        for (UnmeetableDependency dep : unmetSet) {
            pane.add((BWidget)new BLabel(BImage.make((BIcon)dep.getIcon()), dep.toString(null)));
        }
        pane.unindent();
        pane.add(this.getLexiconText("DependenciesStep.unavailableFooter"));
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 3.0, 3.0, 3.0, 3.0));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)scroll);
    }

    private void formatRequiredSoftware(InstallScenario scenario) {
        Array reqSet = new Array((Object[])scenario.getToInstall());
        reqSet = reqSet.sort((Comparator)BDistribution.INSTALLABLE_SUMMARY_COMPARATOR);
        BIndentPane pane = new BIndentPane();
        pane.add(this.getLexiconText("DependenciesStep.requiredHeader"));
        pane.indent();
        for (BInstallable installable : reqSet) {
            if (installable == this.getWizardModel().getDistribution()) continue;
            if (installable.getParts().getSlotCount() == 0) {
                pane.add((BWidget)new BLabel(BImage.make((BIcon)installable.getIcon()), installable.toString()));
                continue;
            }
            if (installable.getParts().getSlotCount() == 1) {
                pane.add((BWidget)new BLabel(BImage.make((BIcon)installable.getPart().getIcon()), installable.toString()));
                continue;
            }
            SlotCursor c = installable.getParts().getProperties();
            while (c.next()) {
                BPart part = (BPart)c.get();
                BVersion partVersion = part.getVersion();
                String vendor = !partVersion.getVendor().isEmpty() ? partVersion.getVendor() : part.getInstallable().getVersion().getVendor();
                pane.add((BWidget)new BLabel(BImage.make((BIcon)part.getIcon()), part.getPartName() + " (" + vendor + " " + partVersion.getVendorVersion() + ")"));
            }
        }
        pane.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 3.0, 3.0, 3.0, 3.0));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)scroll);
    }
}

