/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.filetransfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.filetransfer.BFileTransferClient;
import com.tridium.platDaemon.ui.widget.BReplaceDialog;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.MkDirFileTransferMessageElement;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.ui.theme.Theme;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.space.Mark;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType
public class BDirectoryTable
extends BCommandBoundTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BDirectoryTable.class);
    static Lexicon lex = BFileTransferClient.TYPE.getModule().getLexicon();
    static DecimalFormat numFormat = new DecimalFormat(lex.getText("Formats.num"));
    private TableSelection otherSelection = null;
    private BWbView view;
    private DaemonSessionTaskListener listener;
    private boolean dragEnabled = true;
    public static final int NAME_COL = 0;
    public static final int SIZE_COL = 1;
    public static final int CRC_COL = 2;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDirectoryTable() {
        throw new UnsupportedOperationException();
    }

    public BDirectoryTable(BWbView pView) {
        this(pView, true, true);
    }

    public BDirectoryTable(BWbView pView, boolean includeCrc, boolean includeSize) {
        super((TableModel)new Model(includeCrc, includeSize));
        this.setSelection((TableSelection)new Selection());
        this.view = pView;
    }

    public void load(BDirectory value, DaemonSessionTaskListener pListener) {
        this.load(value, null, pListener);
    }

    public void load(BDirectory value, PatternFilter[] excludePattern, DaemonSessionTaskListener pListener) {
        ((Model)this.getModel()).load(value, excludePattern);
        this.listener = pListener;
    }

    public void setOtherTable(BTable table) {
        this.otherSelection = table.getSelection();
    }

    public boolean isDirectory(int row) {
        return ((Model)this.getModel()).isDirectory(row);
    }

    public BDirectory getDirectory(int row) {
        return ((Model)this.getModel()).getDirectory(row);
    }

    public BDirectory getDirectory() {
        return ((Model)this.getModel()).getDirectory();
    }

    public BIFile getFile(int row) {
        return ((Model)this.getModel()).getFile(row);
    }

    public FilePath getFilePath(int row) {
        return ((Model)this.getModel()).getFilePath(row);
    }

    public int indexOf(String fileName) {
        return ((Model)this.getModel()).indexOf(fileName);
    }

    public void refresh() {
        ((Model)this.getModel()).refresh();
    }

    public void makeSubDirectory(String name) {
        try {
            FilePath newPath = this.getDirectory().getFilePath().merge(name);
            BIFile existing = this.getDirectory().getFileSpace().findFile(newPath);
            if (existing != null) {
                BDialog.warning((BWidget)this, (String)lex.getText("FileTransferClient.dirExists.dlgTitle", new Object[]{name}), (Object)lex.getText("FileTransferClient.dirExists.dlgMessage", new Object[]{name}));
                return;
            }
            if (this.getDirectory().getFileSpace() instanceof BDaemonFileSpace) {
                BDaemonFileSpace dfs = (BDaemonFileSpace)this.getDirectory().getFileSpace();
                DaemonFileUtil.transfer((BDaemonSession)dfs.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)newPath, (BDaemonFileSpace)dfs), null, null);
            } else {
                this.getDirectory().getFileSpace().makeDir(newPath);
            }
            this.refresh();
        }
        catch (Throwable t) {
            BDialog.error((BWidget)this, (String)lex.getText("FileTransferClient.transferError.dlgTitle"), (Object)lex.getText("FileTransferClient.transferError.dlgMessage"), (Throwable)t);
        }
    }

    public BIFile[] getSelectedFiles() {
        int[] sel = this.getSelection().getRows();
        BIFile[] files = new BIFile[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            files[i] = this.getFile(sel[i]);
        }
        return files;
    }

    public Mark getSelectedFilesAsMark() {
        BIFile[] f = this.getSelectedFiles();
        if (f.length == 0) {
            return null;
        }
        String[] names = new String[f.length];
        BObject[] objects = new BObject[f.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = f[i].getFileName();
            objects[i] = (BObject)f[i];
        }
        return new Mark(objects, names);
    }

    public int dragOver(TransferContext cx) {
        if (this.dragEnabled && cx.getEnvelope().supports(TransferFormat.mark)) {
            BFileSpace targetSpace;
            String targetPath;
            int row = this.getRowAt(cx.getY());
            if (row < 0 || this.getDirectory(row) == null) {
                targetPath = this.getDirectory().getFilePath().getBody();
                targetSpace = this.getDirectory().getFileSpace();
            } else {
                targetPath = this.getDirectory(row).getFilePath().getBody();
                targetSpace = this.getDirectory(row).getFileSpace();
            }
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            for (BObject val : mark.getValues()) {
                if (val == null || !(val instanceof BIFile)) {
                    return 0;
                }
                BIFile dragged = (BIFile)val;
                if (dragged.getFileSpace() != targetSpace || !dragged.getFilePath().getBody().equals(targetPath) && !dragged.getFilePath().getParent().getBody().equals(targetPath)) continue;
                return 0;
            }
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.dragEnabled && cx.getEnvelope().supports(TransferFormat.mark)) {
            int row = this.getRowAt(cx.getY());
            BDirectory dir = row < 0 || this.getDirectory(row) == null ? this.getDirectory() : this.getDirectory(row);
            if (4 != BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("FileTransferClient.transfer.confirmTitle"), (Object)this.getLexicon().getText("FileTransferClient.transfer.confirmMessage", new Object[]{DaemonFileUtil.getNormalizedFilePath((BIFileStore)dir.getStore()).getBody()}))) {
                return null;
            }
            return this.insertTransferData(cx);
        }
        return null;
    }

    public void mouseDragStarted(BMouseEvent event) {
        if (this.dragEnabled) {
            int[] rows = this.getSelection().getRows();
            if (rows.length == 0) {
                return;
            }
            int eventRow = this.getRowAt(event.getY());
            boolean found = false;
            for (int row : rows) {
                if (eventRow != row) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            Mark mark = this.getSelectedFilesAsMark();
            SimpleDragRenderer dragRenderer = new SimpleDragRenderer(mark);
            dragRenderer.font = Theme.table().getCellFont();
            this.startDrag(event, TransferEnvelope.make((Mark)mark), (DragRenderer)dragRenderer);
        }
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        if (cx.getEnvelope().supports(TransferFormat.mark)) {
            return this.insertTransferData(this.getRowAt(cx.getY()), (Mark)cx.getEnvelope().getData(TransferFormat.mark));
        }
        return null;
    }

    public CommandArtifact insertTransferData(Mark mark) throws Exception {
        return this.insertTransferData(-1, mark);
    }

    public CommandArtifact insertTransferData(int row, Mark mark) throws Exception {
        BFileSpace targetSpace;
        FilePath targetPath;
        if (mark == null || mark.getValues().length == 0) {
            return null;
        }
        if (row < 0 || this.getDirectory(row) == null) {
            targetPath = this.getDirectory().getFilePath();
            targetSpace = this.getDirectory().getFileSpace();
        } else {
            targetPath = this.getDirectory(row).getFilePath();
            targetSpace = this.getDirectory(row).getFileSpace();
        }
        if (targetSpace instanceof BDaemonFileSpace) {
            BDaemonSession targetSession = ((BDaemonFileSpace)targetSpace).getDaemonSession();
            for (BObject aToTransfer : mark.getValues()) {
                BDaemonSession sourceSession;
                BFileSpace sourceSpace = ((BIFile)aToTransfer).getFileSpace();
                if (!(sourceSpace instanceof BDaemonFileSpace) || !(sourceSession = ((BDaemonFileSpace)sourceSpace).getDaemonSession()).getHostProperties().getHostId().equals(targetSession.getHostProperties().getHostId())) continue;
                throw new LocalizableRuntimeException("platDaemon", "DirectoryTable.sourceTargetSameSession", new Object[]{sourceSession.getHost().getNavDisplayName(null)});
            }
        }
        new TransferWorker(targetSpace, targetPath, mark.getValues()).open();
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.isDeleteEnabled()) {
            return null;
        }
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        BObject[] vals = mark.getValues();
        if (vals.length == 0) {
            return null;
        }
        if (4 != BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("FileTransferClient.delete.confirmTitle"), (Object)this.getLexicon().getText("FileTransferClient.delete.confirmMessage"))) {
            return null;
        }
        FileTransferMessage msg = null;
        BDaemonSession dsession = null;
        for (BObject val : vals) {
            BIFile file = (BIFile)val;
            if (file.getFileSpace() instanceof BDaemonFileSpace) {
                if (msg == null) {
                    msg = new FileTransferMessage((BDaemonFileSpace)file.getFileSpace());
                    dsession = ((BDaemonFileSpace)file.getFileSpace()).getDaemonSession();
                }
                msg.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(file.getFilePath(), (BDaemonFileSpace)file.getFileSpace()));
                continue;
            }
            file.delete();
        }
        if (msg != null) {
            DaemonFileUtil.transfer(dsession, msg, null, (DaemonSessionTaskListener)this.listener);
        }
        this.refresh();
        this.getSelection().deselectAll();
        return null;
    }

    public void deactivated() {
        Model model = (Model)this.getModel();
        model.deactivated();
    }

    private class TransferWorker
    implements Runnable {
        private FileTransferMessage msg = null;
        private BDaemonSession dsession = null;
        private BObject[] vals;
        private FilePath targetFilePath;
        private BFileSpace targetFileSpace;
        private CancelableDaemonSessionTask task;

        public TransferWorker(BFileSpace pTargetFileSpace, FilePath pTargetFilePath, BObject[] pVals) {
            this.targetFileSpace = pTargetFileSpace;
            if (this.targetFileSpace instanceof BDaemonFileSpace) {
                this.msg = new FileTransferMessage((BDaemonFileSpace)this.targetFileSpace);
                this.dsession = ((BDaemonFileSpace)this.targetFileSpace).getDaemonSession();
            }
            this.targetFilePath = pTargetFilePath;
            this.vals = pVals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BWbShell shell = BWbShell.getWbShell((BWidget)BDirectoryTable.this);
            if (shell != null) {
                shell.enterBusy();
            }
            this.task = this.msg == null ? new CancelableDaemonSessionTask(BDirectoryTable.this.getLexicon(), "DirectoryTable.transferringFiles", "DirectoryTable.transferringFiles", 100) : new CancelableDaemonSessionTask(BDirectoryTable.this.getLexicon(), "DirectoryTable.transferringFiles", "DirectoryTable.transferringFiles");
            this.task.setImmediate(true);
            BDirectoryTable.this.listener.taskStarted((DaemonSessionTask)this.task);
            try {
                Array items = new Array(Object.class);
                BReplaceDialog replace = new BReplaceDialog((BWidget)BDirectoryTable.this);
                for (BObject val : this.vals) {
                    if (this.addTransferItems(replace, (BIFile)val, this.targetFilePath, (Array<Object>)items, this.msg)) continue;
                    BDialog.message((BWidget)BDirectoryTable.this, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.transferCancelled")), 10.0, 20.0, 10.0, 20.0));
                    return;
                }
                if (this.msg != null) {
                    BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
                    DaemonFileUtil.transfer((BDaemonSession)this.dsession, (FileTransferMessage)this.msg, null, (DaemonSessionTaskListener)BDirectoryTable.this.listener);
                } else {
                    for (int i = 0; i < items.size(); ++i) {
                        this.transferLocal(items.get(i));
                    }
                }
                BDirectoryTable.this.refresh();
                BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
                BDialog.message((BWidget)BDirectoryTable.this, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(BDirectoryTable.this.getLexicon().getText("FileTransferClient.transfer.transferComplete")), 10.0, 20.0, 10.0, 20.0));
            }
            catch (Exception e) {
                BDialog.error((BWidget)BDirectoryTable.this.view, (String)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transferError.dlgTitle"), (Object)BDirectoryTable.this.getLexicon().getText("FileTransferClient.transferError.dlgMessage"), (Throwable)e);
            }
            finally {
                if (shell != null) {
                    shell.exitBusy();
                }
                BDirectoryTable.this.listener.taskFinished((DaemonSessionTask)this.task);
            }
        }

        private boolean addTransferItems(BReplaceDialog replaceDialog, BIFile sourceFile, FilePath targetDirPath, Array<Object> list, FileTransferMessage msg) throws Exception {
            if (this.task.isCanceled()) {
                return false;
            }
            FilePath targetPath = targetDirPath.merge(sourceFile.getFileName());
            BIFile existingFile = this.targetFileSpace.findFile(targetPath);
            this.task.setMessage(BDirectoryTable.this.getLexicon().getText("DirectoryTable.checking", new Object[]{targetPath.getBody()}));
            BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
            int promptResult = existingFile == null || existingFile.isDirectory() ? 4 : replaceDialog.promptResult(existingFile, sourceFile);
            if (promptResult == 4) {
                if (sourceFile.isDirectory()) {
                    if (msg == null) {
                        list.add((Object)new MakeDirItem(targetPath));
                    } else {
                        msg.addElement((FileTransferMessageElement)new MkDirFileTransferMessageElement(targetPath, (BDaemonFileSpace)this.targetFileSpace));
                    }
                    for (BIFile kid : ((BIDirectory)sourceFile).listFiles()) {
                        if (this.addTransferItems(replaceDialog, kid, targetPath, list, msg)) continue;
                        return false;
                    }
                } else if (msg != null) {
                    PBEEncodingInfo pbeEncodingInfo;
                    if (sourceFile instanceof BBogFile && (pbeEncodingInfo = ((BBogFile)sourceFile).getPBEEncodingInfo()) != null) {
                        if (msg.getPBEEncodingInfo() != null) {
                            throw new LocalizableRuntimeException("platDaemon", "DirectoryTable.multiplePbeItems");
                        }
                        msg.setPBEEncodingInfo(pbeEncodingInfo);
                    }
                    msg.addElement((FileTransferMessageElement)new FileFileTransferElement(targetPath, sourceFile, (BDaemonFileSpace)this.targetFileSpace));
                } else {
                    list.add((Object)new TransferItem(sourceFile, targetPath));
                }
                return true;
            }
            return promptResult != 2;
        }

        private void transferLocal(Object item) throws Exception {
            if (this.task.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
            if (item instanceof MakeDirItem) {
                MakeDirItem md = (MakeDirItem)item;
                this.targetFileSpace.makeDir(md.targetPath);
            } else if (item instanceof TransferItem) {
                TransferItem ti = (TransferItem)item;
                if (ti.source.isDirectory()) {
                    this.targetFileSpace.makeDir(ti.targetPath);
                    this.task.setMessage(Lexicon.make((String)"platform").getText("FileTransferMessageElement.progress", new Object[]{ti.targetPath.getBody()}));
                    this.task.setProgress(100);
                    BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                } else {
                    byte[] buf = new byte[4096];
                    long bytesRead = 0L;
                    long bytesTotal = ti.source.getSize();
                    boolean madeFile = false;
                    BIFile targetFile = this.targetFileSpace.findFile(ti.targetPath);
                    if (targetFile == null) {
                        targetFile = this.targetFileSpace.makeFile(ti.targetPath);
                        madeFile = true;
                    }
                    boolean inputFailed = false;
                    try (OutputStream out = targetFile.getOutputStream();
                         InputStream in = ti.source.getInputStream();){
                        if (in != null) {
                            this.task.setMessage(Lexicon.make((String)"platform").getText("FileTransferMessageElement.progress", new Object[]{ti.targetPath.getBody()}));
                            if (bytesTotal > 0L) {
                                int nRead;
                                this.task.setProgress((int)(100L * bytesRead / bytesTotal));
                                BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                                while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                                    out.write(buf, 0, nRead);
                                    this.task.setProgress((int)(100L * (bytesRead += (long)nRead) / bytesTotal));
                                    BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                                }
                            }
                            this.task.setProgress(100);
                            BDirectoryTable.this.listener.taskUpdated((DaemonSessionTask)this.task);
                        } else {
                            inputFailed = true;
                        }
                    }
                    if (inputFailed) {
                        if (madeFile) {
                            this.targetFileSpace.delete(ti.targetPath);
                        }
                        throw new BajaRuntimeException(BDirectoryTable.this.getLexicon().get("FileTransferClient.transfer.transferErrorInputStream"));
                    }
                }
            }
        }

        public void open() throws Exception {
            new Thread(this).start();
        }
    }

    private class MakeDirItem {
        public FilePath targetPath;

        public MakeDirItem(FilePath pTargetPath) {
            this.targetPath = pTargetPath;
        }
    }

    private class TransferItem {
        public BIFile source;
        public FilePath targetPath;

        public TransferItem(BIFile pSource, FilePath pTargetPath) {
            this.source = pSource;
            this.targetPath = pTargetPath;
        }
    }

    private static class Model
    extends TableModel {
        private CrcWorker crcWorker = null;
        private BlockingQueue<Item> crcQueue = new LinkedBlockingQueue<Item>();
        private BDirectory dir = null;
        private PatternFilter[] fileExcludePatterns = null;
        private final Array<Item> items = new Array(Item.class);
        private boolean includeCrc;
        private boolean includeSize;
        private static final long MAX_FILE_SIZE_CRC = 0x20000000L;

        public Model(boolean includeCrc, boolean includeSize) {
            this.includeCrc = includeCrc;
            this.includeSize = includeSize;
        }

        public int getColumnCount() {
            return 1 + (this.includeCrc ? 1 : 0) + (this.includeSize ? 1 : 0);
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.name");
                }
                case 1: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.size");
                }
                case 2: {
                    return BDaemonSessionView.lexicon.getText("DirectoryTable.column.crc");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Array<Item> array = this.items;
            synchronized (array) {
                return this.items.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Item getItem(int row) {
            Array<Item> array = this.items;
            synchronized (array) {
                return (Item)this.items.get(row);
            }
        }

        public BImage getRowIcon(int row) {
            return this.getItem((int)row).icon;
        }

        public BHalign getColumnAlignment(int col) {
            if (col == 0) {
                return BHalign.left;
            }
            return BHalign.right;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getItem((int)row).file.getFileName();
                }
                case 1: {
                    return this.getItem((int)row).size;
                }
                case 2: {
                    return this.getItem((int)row).crc;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(BDirectory value, PatternFilter[] excludeFiles) {
            this.dir = value;
            this.fileExcludePatterns = excludeFiles;
            if (this.dir.getStore() instanceof BDaemonDirectoryStore) {
                ((BDaemonDirectoryStore)this.dir.getStore()).reset();
            }
            BIFile[] kids = this.dir.listFiles();
            Array<Item> array = this.items;
            synchronized (array) {
                this.items.clear();
                if (this.crcQueue != null) {
                    this.resetQueue();
                }
                for (BIFile kid : kids) {
                    boolean skip = false;
                    if (this.fileExcludePatterns != null) {
                        for (PatternFilter fileExcludePattern : this.fileExcludePatterns) {
                            if (!fileExcludePattern.accept(kid)) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (skip) continue;
                    Item item = new Item(kid, this.includeCrc, this.includeSize);
                    if (item.shouldCalcCrc()) {
                        try {
                            if (this.crcWorker == null) {
                                this.crcWorker = new CrcWorker(this.crcQueue);
                            }
                            this.crcQueue.put(item);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.items.add((Object)item);
                }
                SortUtil.sort((Object[])this.items.trim());
                if (this.crcWorker != null) {
                    this.crcWorker.start();
                }
            }
            this.updateTable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivated() {
            Array<Item> array = this.items;
            synchronized (array) {
                this.resetQueue();
            }
        }

        private void resetQueue() {
            if (this.crcQueue != null) {
                this.crcQueue.clear();
            }
            if (this.crcWorker != null) {
                this.crcWorker.interrupt();
            }
            this.crcWorker = null;
        }

        public void refresh() {
            this.load(this.dir, this.fileExcludePatterns);
        }

        public boolean isDirectory(int row) {
            try {
                return this.getFile(row).isDirectory();
            }
            catch (Exception e) {
                return false;
            }
        }

        public BDirectory getDirectory(int row) {
            try {
                return (BDirectory)this.getFile(row);
            }
            catch (Exception e) {
                return null;
            }
        }

        public BDirectory getDirectory() {
            return this.dir;
        }

        public BIFile getFile(int row) {
            return this.getItem((int)row).file;
        }

        public FilePath getFilePath(int row) {
            try {
                return this.getFile(row).getFilePath();
            }
            catch (Exception e) {
                return null;
            }
        }

        public int indexOf(String fileName) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getFile(i).getFileName().equalsIgnoreCase(fileName)) continue;
                return i;
            }
            return -1;
        }

        public static boolean tooLargeForCRC(BIFile file) {
            return file.getSize() > 0x20000000L;
        }

        private class Item
        implements Comparable<Object> {
            public BIFile file;
            public String size;
            public String crc;
            public BImage icon;
            public boolean includeCrc;
            public boolean calcCrc = false;
            public boolean includeSize;

            public Item(BIFile pFile, boolean calcCrc, boolean calcSize) {
                this.file = pFile;
                this.icon = BImage.make((BIcon)((BObject)this.file).getIcon());
                this.includeCrc = calcCrc;
                this.includeSize = calcSize;
                this.size = this.file.isDirectory() || !this.includeSize ? "" : DaemonFileUtil.fileSize((long)this.file.getSize());
                if (this.file.isDirectory() || !this.includeCrc || Model.tooLargeForCRC(this.file)) {
                    this.crc = "";
                } else {
                    this.crc = TYPE.getModule().getLexicon().getText("FileTransferClient.calculating");
                    this.calcCrc = true;
                }
            }

            public void setCrc(String crc) {
                this.crc = crc;
                Model.this.getModel().updateTable(true);
            }

            public boolean shouldCalcCrc() {
                return this.calcCrc;
            }

            @Override
            public int compareTo(Object o) {
                Item i = (Item)o;
                if (this.file.isDirectory()) {
                    if (i.file.isDirectory()) {
                        return this.file.getFileName().compareTo(i.file.getFileName());
                    }
                    return -1;
                }
                if (i.file.isDirectory()) {
                    return 1;
                }
                return this.file.getFileName().compareTo(i.file.getFileName());
            }
        }

        private class CrcWorker
        extends Thread {
            private BlockingQueue<Item> queue;

            public CrcWorker(BlockingQueue<Item> queue) {
                super("CrcWorkerThread");
                this.queue = queue;
            }

            @Override
            public void run() {
                Item item;
                while ((item = (Item)this.queue.poll()) != null) {
                    String crc;
                    try {
                        crc = Long.toHexString(DaemonFileUtil.getCrc((BIFile)item.file));
                    }
                    catch (Exception e) {
                        crc = "Failed";
                    }
                    item.setCrc(crc);
                }
            }
        }
    }

    private class Selection
    extends CommandBindings.TableSelection {
        private Selection() {
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.checkOtherSelection();
            this.checkTransfer();
        }

        public void deselect(int row) {
            super.deselect(row);
            this.checkTransfer();
        }

        public void deselectAll() {
            super.deselectAll();
            this.checkTransfer();
        }

        private void checkTransfer() {
            if (this.isEmpty()) {
                BDirectoryTable.this.setDeleteEnabled(false);
            } else {
                BDirectoryTable.this.view.setTransferWidget((BTransferWidget)BDirectoryTable.this);
                BDirectoryTable.this.setDeleteEnabled(true);
            }
        }

        private void checkOtherSelection() {
            if (BDirectoryTable.this.otherSelection != null && !this.isEmpty()) {
                BDirectoryTable.this.otherSelection.deselectAll();
            }
        }
    }
}

