/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetAccessTokenPollStatusMessage;
import com.tridium.platform.daemon.message.RegisterDeviceMessage;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.web.BUrlTextField;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public class BRegisterDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BRegisterDialog.class);
    private static final Logger logger = Logger.getLogger("platDaemon");
    private static final int REGISTER_TIMEOUT = 30000;
    private static final BImage INFO32 = BImage.make((String)"module://icons/x32/info.png");
    private BDaemonSession session;
    private BLicenseManager manager;
    private BButton okButton;
    private BButton cancelButton;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BRegisterDialog() {
    }

    public BRegisterDialog(BDaemonSession session, BLicenseManager manager, BWidget owner, String title) {
        super(owner, title, true);
        this.session = session;
        this.manager = manager;
    }

    public static void open(BDaemonSession session, BLicenseManager manager, BWidget owner, String title, String userCode, String verificationUrl) {
        BRegisterDialog dialog = new BRegisterDialog(session, manager, owner, title);
        BEdgePane content = dialog.buildContent(userCode, verificationUrl);
        dialog.open((BWidget)content);
    }

    public void open(BWidget content) {
        this.setContent(content);
        this.relayout();
        this.requestFocus();
        this.setDefaultButton(this.getOkButton());
        this.setBoundsCenteredOnOwner();
        this.setResizable(false);
        this.open();
    }

    private BButton getOkButton() {
        return this.okButton;
    }

    private BButton getCancelButton() {
        return this.cancelButton;
    }

    public void windowClosing(BWindowEvent event) {
        new CancelCommand(true).doInvoke();
    }

    private BLabel getLexiconAsBoldLabel(String lexKey) {
        BLabel label = new BLabel(this.getLexicon().getText(lexKey));
        label.setFont(Theme.gridPane().getBoldText());
        return label;
    }

    public BEdgePane buildContent(String userCode, String verificationUrl) {
        String instructionsTitle = this.getLexicon().getText("LicenseManager.registerNreIdDialog.headerTitle");
        String instructionsMessage = this.getLexicon().getText("LicenseManager.registerNreIdDialog.headerDesc");
        BTextField subKeyField = new BTextField();
        BWizardHeader header = new BWizardHeader(INFO32, instructionsTitle, instructionsMessage);
        BGridPane buttons = new BGridPane(2);
        buttons.setColumnAlign(BHalign.fill);
        buttons.setHalign(BHalign.right);
        buttons.setUniformColumnWidth(true);
        this.okButton = new BButton((Command)new OkCommand(subKeyField), true, true);
        this.cancelButton = new BButton((Command)new CancelCommand(true), true, true);
        buttons.add("ok", (BValue)this.okButton);
        buttons.add("cancel", (BValue)this.cancelButton);
        BEdgePane footer = new BEdgePane();
        footer.setTop((BWidget)new BSeparator(BOrientation.horizontal));
        footer.setCenter((BWidget)new BBorderPane((BWidget)buttons, 8.0, 8.0, 8.0, 8.0));
        BIndentPane contentTop = new BIndentPane();
        BLabel keyLabel = this.getLexiconAsBoldLabel("LicenseManager.registerNreIdDialog.subscriptionKey.label");
        BLabel urlLabel = this.getLexiconAsBoldLabel("LicenseManager.registerNreIdDialog.verificationUrl.label");
        BLabel codeLabel = this.getLexiconAsBoldLabel("LicenseManager.registerNreIdDialog.code.label");
        BGridPane labelAndFieldGrid = new BGridPane(2);
        labelAndFieldGrid.setRowGap(4.0);
        labelAndFieldGrid.add("keyLabel", (BValue)keyLabel);
        labelAndFieldGrid.add("keyField", (BValue)subKeyField);
        labelAndFieldGrid.add("urlLabel", (BValue)new BBorderPane((BWidget)urlLabel, 0.0, 0.0, 0.0, 0.0));
        labelAndFieldGrid.add("urlField", (BValue)new BUrlTextField(verificationUrl, 60));
        labelAndFieldGrid.add("codeLabel", (BValue)new BBorderPane((BWidget)codeLabel, 0.0, 0.0, 0.0, 0.0));
        labelAndFieldGrid.add("codeField", (BValue)new BTextField(userCode, 60, false));
        contentTop.add("codeUriGrid", (BValue)labelAndFieldGrid);
        BIndentPane contentBottom = new BIndentPane();
        BLabel instructionsHeader = new BLabel(this.getLexicon().getText("LicenseManager.registerNreIdDialog.instructions.title"));
        instructionsHeader.setFont(Theme.label().getBoldText());
        instructionsHeader.setHalign(BHalign.left);
        contentBottom.add("instructionHeader", (BValue)instructionsHeader);
        BLabel instructions = new BLabel(this.getLexicon().getText("LicenseManager.registerNreIdDialog.instructions.message"));
        instructions.setHalign(BHalign.left);
        contentBottom.add("instructions", (BValue)instructions);
        BEdgePane centerContent = new BEdgePane((BWidget)new BBorderPane((BWidget)contentTop, 5.0, 0.0, 0.0, 0.0), (BWidget)new BBorderPane((BWidget)contentBottom, 100.0, 0.0, 5.0, 0.0), null, null, null);
        BEdgePane content = new BEdgePane();
        content.setTop((BWidget)header);
        content.setCenter((BWidget)new BBorderPane((BWidget)centerContent, 8.0, 8.0, 8.0, 8.0));
        content.setBottom((BWidget)footer);
        return content;
    }

    class OkCommand
    extends Command {
        private final BTextField subKeyField;

        OkCommand(BTextField subscriptionField) {
            super((BWidget)BRegisterDialog.this, BLicenseManager.lex.module, "ok");
            this.subKeyField = subscriptionField;
        }

        public CommandArtifact doInvoke() {
            if (SubscriptionLicenseUtil.isKeyValid((String)this.subKeyField.getText())) {
                String accessTokenResponseJSONString;
                String registrationFailureTitle = BRegisterDialog.this.getLexicon().getText("LicenseManager.registrationFailureDialog.title");
                try (InputStream inputStream = BRegisterDialog.this.session.getInputStream((DaemonMessage)new GetAccessTokenPollStatusMessage(), 30000);){
                    accessTokenResponseJSONString = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Get access token status response: " + accessTokenResponseJSONString);
                    }
                    BRegisterDialog.this.session.updateHostProperties();
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.SEVERE, "Failed to send \"getAccessTokenPollStatus\" message to daemon session", e);
                    } else {
                        logger.log(Level.SEVERE, "Failed to send \"getAccessTokenPollStatus\" message to daemon session");
                    }
                    BDialog.error((BWidget)this.getOwner(), (String)registrationFailureTitle, (Object)BRegisterDialog.this.getLexicon().getText("LicenseManager.accessTokenPollStatusFetchFailed.message"), (Throwable)e);
                    BRegisterDialog.this.manager.stopAccessTokenPoll();
                    BRegisterDialog.this.close();
                    return null;
                }
                JSONObject accessTokenResponseJson = new JSONObject();
                String accessTokenErrorMessage = "";
                try {
                    accessTokenResponseJson = new JSONObject(accessTokenResponseJSONString);
                }
                catch (JSONException e) {
                    accessTokenErrorMessage = accessTokenResponseJSONString;
                }
                if (!accessTokenResponseJson.has("isComplete")) {
                    logger.log(Level.SEVERE, "Failed to get access token status: " + accessTokenErrorMessage);
                    BDialog.error((BWidget)this.getOwner(), (String)registrationFailureTitle, (Object)accessTokenErrorMessage);
                    BRegisterDialog.this.manager.stopAccessTokenPoll();
                    BRegisterDialog.this.close();
                    return null;
                }
                if (Boolean.parseBoolean(accessTokenResponseJson.getString("isComplete"))) {
                    if (Boolean.parseBoolean(accessTokenResponseJson.getString("isFailure"))) {
                        logger.log(Level.SEVERE, "Access token fetch was unsuccessful, cannot proceed with registration.");
                        BDialog.error((BWidget)this.getOwner(), (String)registrationFailureTitle, (Object)accessTokenResponseJson.getString("failureMessage"));
                        BRegisterDialog.this.manager.stopAccessTokenPoll();
                        BRegisterDialog.this.close();
                        return null;
                    }
                    logger.log(Level.FINE, "Sending registration message for key: " + this.subKeyField.getText());
                    try (InputStream inputStream = BRegisterDialog.this.session.getInputStream((DaemonMessage)new RegisterDeviceMessage(this.subKeyField.getText()));){
                        XElem mainElem;
                        XElem[] errorElems;
                        String responseText = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Registration response: " + responseText);
                        }
                        if ((errorElems = (mainElem = XParser.make((InputStream)new ByteArrayInputStream(responseText.getBytes(StandardCharsets.UTF_8))).parse()).elems("error")) != null && errorElems.length > 0) {
                            StringBuilder errorMessage = new StringBuilder();
                            for (XElem errorElem : errorElems) {
                                errorMessage.append(": ").append(errorElem.string());
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.SEVERE, "Error response from the entitlement system during registration request" + errorMessage);
                            } else {
                                logger.log(Level.SEVERE, "Error response from the entitlement system during registration request.");
                            }
                            BDialog.error((BWidget)this.getOwner(), (String)registrationFailureTitle, (Object)errorMessage);
                        } else {
                            logger.log(Level.INFO, "Registration Successful");
                            BRegisterDialog.this.session.updateHostProperties();
                        }
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.SEVERE, "Failed to send registration request to remote device.", e);
                        } else {
                            logger.log(Level.SEVERE, "Failed to send registration request to remote device: " + e.getMessage());
                        }
                        BDialog.error((BWidget)this.getOwner(), (String)registrationFailureTitle, (Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    logger.log(Level.FINE, "Device registration not approved yet.");
                    BDialog.info((BWidget)this.getOwner(), (Object)BRegisterDialog.this.getLexicon().getText("LicenseManager.registrationUnapproved.message"));
                    return null;
                }
                BRegisterDialog.this.close();
            } else {
                logger.log(Level.FINE, "Invalid subscription key: " + this.subKeyField.getText());
                BDialog.error((BWidget)this.getOwner(), (Object)BRegisterDialog.this.getLexicon().getText("LicenseManager.invalidSubscriptionKey.message"));
            }
            return null;
        }
    }

    class CancelCommand
    extends Command {
        private final boolean confirm;

        CancelCommand(boolean confirm) {
            super((BWidget)BRegisterDialog.this, BLicenseManager.lex.module, "cancel");
            this.confirm = confirm;
        }

        public CommandArtifact doInvoke() {
            int r;
            if (this.confirm && (r = BDialog.confirm((BWidget)this.getOwner(), (Object)BLicenseManager.lex.getText("cancel.confirm"))) != 4) {
                return null;
            }
            logger.log(Level.FINE, "Registration cancelled.");
            BRegisterDialog.this.manager.stopAccessTokenPoll();
            BRegisterDialog.this.close();
            return null;
        }
    }
}

