/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platDaemon.ui.softwaremanager.BSignatureDetailsPane;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.ui.util.LabelUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType
public class BPartDetailsPane
extends BGridPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BPartDetailsPane.class);
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
    private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
    private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");
    private static final BImage UNKNOWN = BImage.make((String)"module://icons/x16/questionMark.png");
    private BEdgePane partPaneHolder;
    private BBorderPane modulePane;
    private BLabel moduleBorderLabel;
    private BLabel moduleDesc;
    private BLabel moduleCurrentVersion;
    private BLabel moduleAvailVersion;
    private BLabel moduleCurrentReleaseDate;
    private BLabel moduleAvailReleaseDate;
    private BLabel moduleCurrentStatus;
    private BLabel moduleAvailStatus;
    private BLabel moduleJace;
    private BLabel moduleCurrentJace;
    private BLabel moduleAvailJace;
    private BVersion moduleJaceVersionN4Requirement = new BVersion("4.0");
    private BVersion moduleJaceVersionAXRequirement = new BVersion("3.0");
    private BBorderPane partPane;
    private BLabel partBorderLabel;
    private BLabel partDesc;
    private BLabel partCurrentVersion;
    private BLabel partAvailVersion;
    private BBorderPane unspecifiedVmPane;
    private BEdgePane instPaneHolder;
    private BNullWidget instPaneNull;
    private BBorderPane instPane;
    private BLabel instPath;
    private BLabel instSize;
    private BBorderPane reqPane;
    private CertificateChainValidator certValidator;
    private ModuleVerificationMode verificationMode;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPartDetailsPane(CertificateChainValidator certValidator, ModuleVerificationMode verificationMode) {
        super(1);
        this.setStretchColumn(0);
        this.setColumnAlign(BHalign.fill);
        this.setValign(BValign.top);
        BGridPane moduleGrid = new BGridPane(3);
        moduleGrid.setValign(BValign.top);
        moduleGrid.setColumnGap(10.0);
        moduleGrid.setRowGap(6.0);
        moduleGrid.setStretchColumn(2);
        moduleGrid.setColumnAlign(BHalign.left);
        this.moduleDesc = new BLabel();
        this.addTriple(moduleGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.partDescription"), (BWidget)this.moduleDesc, (BWidget)new BNullWidget());
        moduleGrid.add("moduleGridUpperLeftSpacer", (BValue)new BNullWidget());
        moduleGrid.add("moduleGridCurrentHeading", (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.column.currentVersion"), (boolean)true));
        moduleGrid.add("moduleGridAvailHeading", (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.column.availableVersion"), (boolean)true));
        this.moduleCurrentVersion = new BLabel();
        this.moduleAvailVersion = new BLabel();
        this.addTriple(moduleGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.partVersion"), (BWidget)this.moduleCurrentVersion, (BWidget)this.moduleAvailVersion);
        this.moduleCurrentReleaseDate = new BLabel();
        this.moduleAvailReleaseDate = new BLabel();
        this.addTriple(moduleGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.releaseDate"), (BWidget)this.moduleCurrentReleaseDate, (BWidget)this.moduleAvailReleaseDate);
        this.moduleCurrentStatus = new BLabel();
        this.moduleAvailStatus = new BLabel();
        this.addTriple(moduleGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.moduleStatus"), (BWidget)this.moduleCurrentStatus, (BWidget)this.moduleAvailStatus);
        this.moduleJace = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.moduleJace"), (boolean)true);
        this.moduleCurrentJace = new BLabel();
        this.moduleAvailJace = new BLabel();
        this.addTriple(moduleGrid, (BWidget)this.moduleJace, (BWidget)this.moduleCurrentJace, (BWidget)this.moduleAvailJace);
        this.moduleJace.setVisible(false);
        this.moduleCurrentJace.setVisible(false);
        this.moduleAvailJace.setVisible(false);
        this.modulePane = new BBorderPane((BWidget)moduleGrid);
        this.moduleBorderLabel = LabelUtil.makeLabel((String)"", (boolean)true);
        this.modulePane.setLabel((BWidget)this.moduleBorderLabel);
        BGridPane partGrid = new BGridPane(3);
        partGrid.setValign(BValign.top);
        partGrid.setColumnGap(10.0);
        partGrid.setRowGap(6.0);
        partGrid.setStretchColumn(2);
        partGrid.setColumnAlign(BHalign.left);
        this.partDesc = new BLabel();
        this.addTriple(partGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.partDescription"), (BWidget)this.partDesc, (BWidget)new BNullWidget());
        partGrid.add("partGridUpperLeftSpacer", (BValue)new BNullWidget());
        partGrid.add("partGridCurrentHeading", (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.column.currentVersion"), (boolean)true));
        partGrid.add("partGridAvailHeading", (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.column.availableVersion"), (boolean)true));
        this.partCurrentVersion = new BLabel();
        this.partAvailVersion = new BLabel();
        this.addTriple(partGrid, LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.partVersion"), (BWidget)this.partCurrentVersion, (BWidget)this.partAvailVersion);
        this.partPane = new BBorderPane((BWidget)partGrid);
        this.partBorderLabel = LabelUtil.makeLabel((String)"", (boolean)true);
        this.partPane.setLabel((BWidget)this.partBorderLabel);
        this.partPaneHolder = new BEdgePane(null, null, null, null, (BWidget)this.partPane);
        this.add(null, (BValue)this.partPaneHolder);
        BGridPane instGrid = new BGridPane(2);
        instGrid.setValign(BValign.top);
        instGrid.setColumnGap(10.0);
        instGrid.setRowGap(6.0);
        instGrid.setStretchColumn(1);
        instGrid.setColumnAlign(BHalign.left);
        this.instPath = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)instGrid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.installablePath"), (BWidget)this.instPath);
        this.instSize = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)instGrid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PartDetailsPane.label.installableSize"), (BWidget)this.instSize);
        this.instPane = new BBorderPane((BWidget)instGrid, this.getLexicon().getText("PartDetailsPane.section.installable"));
        this.instPaneNull = new BNullWidget();
        this.instPaneHolder = new BEdgePane(null, null, null, null, (BWidget)this.instPaneNull);
        this.add(null, (BValue)this.instPaneHolder);
        this.add("installedSignature", (BValue)new BNullWidget());
        this.add("availableSignature", (BValue)new BNullWidget());
        this.reqPane = new BBorderPane((BWidget)new BNullWidget(), this.getLexicon().getText("PartDetailsPane.section.depend"));
        this.add(null, (BValue)this.reqPane);
        BFlowPane flow = new BFlowPane(BHalign.left);
        flow.add(null, (BValue)new BLabel(Lexicon.make((String)"platform").getText("unspecifiedVm.description")));
        this.unspecifiedVmPane = new BBorderPane((BWidget)flow, this.getLexicon().getText("SoftwareManager.type.vm"));
        this.certValidator = certValidator;
        this.verificationMode = verificationMode;
    }

    public void loadValue(BPart currentPart, BPart availPart, String type, List<BDependency> forwardDependencies, List<BPart> dependentParts) {
        BInstallable installable;
        BPart part = availPart == null ? currentPart : availPart;
        BInstallable bInstallable = installable = availPart == null ? null : availPart.getInstallable();
        if (part instanceof BModulePart) {
            BSignatureDetailsPane pane;
            if (currentPart != null) {
                pane = new BSignatureDetailsPane(this.certValidator, this.verificationMode, 440);
                pane.setLabel(LEX.getText("PartDetailsPane.installedSignature"));
                pane.loadValue((BModulePart)currentPart);
                this.set("installedSignature", (BValue)pane);
            }
            if (availPart != null) {
                pane = new BSignatureDetailsPane(this.certValidator, this.verificationMode, 440);
                pane.setLabel(LEX.getText("PartDetailsPane.availableSignature"));
                pane.loadValue((BModulePart)availPart);
                this.set("availableSignature", (BValue)pane);
            }
            this.partPaneHolder.setCenter((BWidget)this.modulePane);
            BModulePart module = (BModulePart)part;
            module.init();
            this.moduleBorderLabel.setText(this.getLexicon().getText("PartDetailsPane.section.part", new Object[]{type, part.getPartName()}));
            this.moduleDesc.setText(part.getDescription());
            this.loadModuleFields((BModulePart)currentPart, this.moduleCurrentVersion, this.moduleCurrentReleaseDate, this.moduleCurrentStatus, this.moduleCurrentJace);
            this.loadModuleFields((BModulePart)availPart, this.moduleAvailVersion, this.moduleAvailReleaseDate, this.moduleAvailStatus, this.moduleAvailJace);
        } else if (part instanceof BVmPart && ((BVmPart)part).getUnspecified()) {
            this.partPaneHolder.setCenter((BWidget)this.unspecifiedVmPane);
        } else {
            this.partPaneHolder.setCenter((BWidget)this.partPane);
            this.partDesc.setText(part.getDescription());
            this.partBorderLabel.setText(this.getLexicon().getText("PartDetailsPane.section.part", new Object[]{type, part.getPartName()}));
            this.loadPartFields(currentPart, this.partCurrentVersion);
            this.loadPartFields(availPart, this.partAvailVersion);
        }
        if (installable == null) {
            this.instPaneHolder.setCenter((BWidget)this.instPaneNull);
        } else {
            this.instPaneHolder.setCenter((BWidget)this.instPane);
            try {
                this.instPath.setText(installable.getLocalInstallableFile().getCanonicalPath());
            }
            catch (IOException ioe) {
                this.instPath.setText("");
            }
            this.instSize.setText(DaemonFileUtil.fileSize((long)installable.getInstallableFileSize()));
        }
        BIndentPane dependContent = new BIndentPane();
        if (forwardDependencies.size() > 0) {
            dependContent.add(LexiconText.make((Type)TYPE, (String)"PartDetailsPane.forwardDep.text"), new Object[]{part.getPartName()});
            dependContent.indent();
            for (BDependency dep : forwardDependencies) {
                dependContent.add((BWidget)new BLabel(BImage.make((BIcon)dep.getIcon()), dep.toString()));
            }
            dependContent.unindent();
        }
        if (dependentParts.size() > 0) {
            if (forwardDependencies.size() > 0) {
                dependContent.add(null, (BValue)new BBox(0.0, 5.0));
            }
            dependContent.add(LexiconText.make((Type)TYPE, (String)"PartDetailsPane.reverseDep.text"), new Object[]{part.getPartName()});
            dependContent.indent();
            for (BPart depPart : dependentParts) {
                dependContent.add((BWidget)new BLabel(BImage.make((BIcon)depPart.getIcon()), depPart.getPartName()));
            }
            dependContent.unindent();
        }
        this.reqPane.setContent((BWidget)dependContent);
        this.relayout();
    }

    private void loadPartFields(BPart part, BLabel versionLabel) {
        if (part == null) {
            versionLabel.setText("-");
        } else {
            versionLabel.setText(part.getVersion().toString());
        }
    }

    private void loadModuleFields(BModulePart module, BLabel versionLabel, BLabel releaseDateLabel, BLabel statusLabel, BLabel jaceLabel) {
        if (module == null) {
            versionLabel.setText("-");
            statusLabel.setText("-");
            jaceLabel.setText("-");
            releaseDateLabel.setText("-");
        } else {
            versionLabel.setText(module.getVersion().toString());
            statusLabel.setText(module.getStatus().toString());
            Optional releaseDateLong = module.getReleaseDate();
            if (releaseDateLong.isPresent()) {
                releaseDateLabel.setText(LicenseUtil.formatDate((long)((Long)releaseDateLong.get())));
            } else {
                releaseDateLabel.setText("-");
            }
            if (module.getVersion().meetsVersionRequirement(this.moduleJaceVersionN4Requirement, BVersionRelation.minimum)) {
                jaceLabel.setText("-");
            } else if (module.getVersion().meetsVersionRequirement(this.moduleJaceVersionAXRequirement, BVersionRelation.minimum)) {
                this.moduleJace.setVisible(true);
                this.moduleCurrentJace.setVisible(true);
                this.moduleAvailJace.setVisible(true);
                if (module.getArchiveHost().trim().length() > 0) {
                    jaceLabel.setText(this.getLexicon().getText("PartDetailsPane.value.archiveDate", new Object[]{module.getArchiveDate(), module.getArchiveHost()}));
                } else {
                    jaceLabel.setText(this.getLexicon().getText("PartDetailsPane.value.notArchived"));
                }
            } else {
                jaceLabel.setText("-");
            }
            if (module.getStatus().equals((Object)BModuleStatus.ok)) {
                List statuses = module.getSignatureStatus(this.certValidator);
                boolean isError = false;
                for (ModuleSignatureStatusEnum status : statuses) {
                    if (status.isAcceptable(this.verificationMode)) continue;
                    isError = true;
                    break;
                }
                if (isError) {
                    statusLabel.setText(LEX.getText("PartDetailsPane.signatureErrorStatus"));
                } else if (!statuses.contains(ModuleSignatureStatusEnum.OK) && !statuses.contains(ModuleSignatureStatusEnum.UNKNOWN)) {
                    statusLabel.setText(LEX.getText("PartDetailsPane.signatureWarningStatus"));
                }
            }
        }
    }

    private void addTriple(BGridPane grid, LexiconText text, BWidget widget2, BWidget widget3) {
        grid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)text, (boolean)true));
        grid.add(null, (BValue)widget2);
        grid.add(null, (BValue)widget3);
    }

    private void addTriple(BGridPane grid, BWidget widget1, BWidget widget2, BWidget widget3) {
        grid.add(null, (BValue)widget1);
        grid.add(null, (BValue)widget2);
        grid.add(null, (BValue)widget3);
    }
}

