/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableRowFilter;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.gx.BImage;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.table.TableModel;

public class InstallerTableModel
extends TableModel {
    public static final int NAME_COL = 0;
    public static final int CURRENT_VER_COL = 1;
    public static final int AVAIL_VER_COL = 2;
    public static final int COMMENT_COL = 3;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_LATER = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_EARLIER = 3;
    public static final int STATUS_DIFFERENT = 4;
    public static final int STATUS_EQUIVALENT = 5;
    public static final int STATUS_NOT_INSTALLED = 6;
    public static final int STATUS_BAD_INSTALLABLE = 7;
    public static final int STATUS_BAD_TARGET = 8;
    public static final int STATUS_BOTH_BAD = 9;
    public static final int STATUS_NO_DETAILS = 10;
    public static final int STATUS_NO_LOCAL = 11;
    public static final int STATUS_EARLIER_COMMISSION = 12;
    public static final int STATUS_NOT_INSTALLED_COMMISSION = 13;
    private int sortColumn = 3;
    private boolean sortAscending = true;
    private boolean needsSort = true;
    protected InstallScenario scenario;
    protected InstallScenario oodScenario;
    private Map<PartSpec, InstallerTableRow> rowsByPartSpec = new TreeMap<PartSpec, InstallerTableRow>();
    protected List<InstallerTableRow> rows = new ArrayList<InstallerTableRow>();
    private BInstallerTableRowFilter filter = null;
    protected DaemonSessionTaskListener taskListener;
    private long elapsed = 0L;
    protected CertificateChainValidator certValidator;
    private static final Comparator<InstallerTableRow> COMMENT_COLUMN_COMPARATOR = InstallerTableRow::compareComment;
    private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
    private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
    private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");
    private static final BImage UNKNOWN = BImage.make((String)"module://icons/x16/questionMark.png");

    public BPartInstallStatus getInstallStatusAt(int row) {
        return this.getRow(row).getInstallStatus();
    }

    public BImage getCellIcon(int row, int col) {
        InstallerTableRow instRow = this.getRow(row);
        int signingStatus = 0;
        if (col == 1) {
            signingStatus = instRow.getCurrentSigningStatus();
        } else if (col == 2) {
            signingStatus = instRow.getInstallableSigningStatus();
        }
        switch (signingStatus) {
            case 4: {
                return SECURITY_HIGH;
            }
            case 3: {
                return SECURITY_MEDIUM;
            }
            case 2: {
                return SECURITY_LOW;
            }
            case 1: {
                return UNKNOWN;
            }
        }
        return null;
    }

    public ModuleVerificationMode getModuleVerificationMode() {
        return this.scenario.getVerificationMode();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.currentVersion");
            }
            case 0: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.installableFile");
            }
            case 2: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.availableVersion");
            }
            case 3: {
                return "";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int indexOf(PartSpec spec) {
        InstallerTableRow row = this.getRow(spec);
        if (row == null) {
            return -1;
        }
        return this.rows.indexOf(row);
    }

    public BPart getCurrentPartAt(int row) {
        return this.getRow(row).getCurrentPart();
    }

    public BVersion getCurrentVersionAt(int row) {
        return this.getRow(row).getCurrentVersion();
    }

    public List<BDependency> getForwardDependenciesAt(int row) {
        return this.getRow(row).getForwardDeps();
    }

    public BInstallable getInstallableAt(int row) {
        return this.getRow(row).getInstallable();
    }

    public BPart getInstallablePartAt(int row) {
        return this.getRow(row).getInstallablePart();
    }

    public BVersion getInstallableVersionAt(int row) {
        return this.getRow(row).getHighestInstallableVersion();
    }

    public InstallScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(InstallScenario value) {
        if (!value.canCommit()) {
            throw new IllegalArgumentException("Install scenario has unmet dependencies");
        }
        this.scenario = value;
        this.rebuild(false);
    }

    public CertificateChainValidator getCertValidator() {
        return this.certValidator;
    }

    public String getNameAt(int row) {
        return this.getRow(row).getPartName();
    }

    public List<InstallerTableRow> getReverseDependenciesAt(int row) {
        Map<InstallerTableRow, BDependency> reverseDeps = this.getRow(row).getReverseDeps();
        return new ArrayList<InstallerTableRow>(reverseDeps.keySet());
    }

    public List<BPart> getDependentPartsAt(int row) {
        return this.getRow(row).getDependentParts();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public BImage getRowIcon(int row) {
        return this.getCellIcon(row, 0);
    }

    public int getStatusAt(int row) {
        return this.getRow(row).getStatus();
    }

    public String getTypeAt(int row) {
        return this.getRow(row).getType();
    }

    public DaemonSessionTaskListener getTaskListener() {
        return this.taskListener;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 1: {
                return InstallerTableModel.nvl(this.getRow(row).getCurrentVersion(), "-");
            }
            case 0: {
                return InstallerTableModel.nvl(this.getRow(row).getPartName(), "-");
            }
            case 2: {
                return InstallerTableModel.nvl(this.getRow(row).getHighestInstallableVersion(), "-");
            }
            case 3: {
                return this.getRow(row).getComment();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void init(BDaemonSession targetSession, DaemonSessionTaskListener taskListener) throws AuthenticationException {
        this.init(targetSession, taskListener, true);
    }

    public void init(BDaemonSession targetSession, DaemonSessionTaskListener taskListener, boolean sort) throws AuthenticationException {
        DaemonSessionTask task = new DaemonSessionTask(BDaemonSessionView.lexicon, "SoftwareManager.initializing", "SoftwareManager.loadingRemote");
        try {
            if (taskListener != null) {
                taskListener.taskStarted(task);
                taskListener.taskUpdated(task);
            }
            this.certValidator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(targetSession));
            BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)targetSession, (DaemonSessionTaskListener)taskListener);
            platform.loadPreferredVerificationMode();
            if (taskListener != null) {
                task.setMessage(BDaemonSessionView.lexicon.getText("SoftwareManager.buildingScenario"));
                taskListener.taskUpdated(task);
            }
            this.scenario = new InstallScenario((BDaemonPlatform)platform, null, null, null, null, null, null, null, new SolutionParameters(taskListener, true, "default"), (InstallableRegistry)LocalInstallableRegistry.getInstance(), this.certValidator);
            if (taskListener != null) {
                task.setMessage(BDaemonSessionView.lexicon.getText("SoftwareManager.analyzingOutOfDate"));
                taskListener.taskUpdated(task);
            }
            this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            this.taskListener = taskListener;
            this.rebuild(sort);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            if (taskListener != null) {
                taskListener.taskFinished(task);
            }
        }
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public boolean isModule(int row) {
        return this.getRow(row).isModule();
    }

    public void rebuild() throws AuthenticationException {
        this.rebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean sort) throws AuthenticationException {
        this.rowsByPartSpec = new TreeMap<PartSpec, InstallerTableRow>();
        DaemonSessionTask sessionTask = new DaemonSessionTask(BDaemonSessionView.lexicon, "SoftwareManager.rebuilding", "SoftwareManager.rebuilding");
        try {
            if (this.taskListener != null) {
                this.taskListener.taskStarted(sessionTask);
            }
            if (this.scenario != null) {
                BDaemonPlatform platform = this.scenario.getTargetPlatform();
                if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                    BDaemonSessionView.log.fine("model rebuild: fetched platform " + this.getElapsed());
                }
                platform.getModuleList().init(this.taskListener);
                SlotCursor c = platform.getModuleList().getModules().getProperties();
                while (c.next()) {
                    this.addCurrentPart((BPart)((BModuleInstallable)c.get()).getModulePart());
                }
                if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                    BDaemonSessionView.log.fine("model rebuild: added remote modules " + this.getElapsed());
                }
                try {
                    HashSet<String> installableNames = new HashSet<String>();
                    for (BInstallable toInstall : this.scenario.getToInstall()) {
                        if (!(toInstall instanceof BModuleInstallable)) continue;
                        this.addInstallable(toInstall);
                        installableNames.add(toInstall.getInstallableName());
                    }
                    HashMap rejected = new HashMap();
                    IterableCursor c2 = LocalInstallableRegistry.getInstance().getInstallables(false, this.taskListener, null, "*.dist");
                    while (c2.next()) {
                        BInstallable inst = (BInstallable)c2.get();
                        if (!(inst instanceof BModuleInstallable) || inst.getUnmetPlatformDependencies(platform).size() != 0 || !InstallScenario.listModule((InstallScenario)this.scenario, (BModuleInstallable)((BModuleInstallable)inst), rejected)) continue;
                        if (installableNames.contains(inst.getInstallableName())) {
                            InstallerTableRow row = this.getRow(inst.getPartSpec());
                            if (row.getHighestInstallableVersion() != null && row.getHighestInstallableVersion().getVendorVersion().compareTo(inst.getVersion().getVendorVersion()) >= 0) continue;
                            row.setLatestAvailableInstallable(inst);
                            continue;
                        }
                        this.addInstallable(inst);
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                BDaemonSessionView.log.fine("model rebuild: added local modules " + this.getElapsed());
            }
            Iterator<PartSpec> iterator = this.rowsByPartSpec.keySet().iterator();
            while (iterator.hasNext()) {
                PartSpec o;
                PartSpec spec = o = iterator.next();
                InstallerTableRow row = this.rowsByPartSpec.get(spec);
                TreeMap<PartSpec, BDependency> resultMap = new TreeMap<PartSpec, BDependency>();
                TreeSet<PartSpec> checked = new TreeSet<PartSpec>();
                this.checkDependencies(spec, resultMap, checked, null);
                row.setForwardDeps(new ArrayList<BDependency>(resultMap.values()));
            }
            this.updateValues(sort);
        }
        finally {
            if (this.taskListener != null) {
                this.taskListener.taskFinished(sessionTask);
            }
        }
    }

    public void reload() throws AuthenticationException {
        try {
            this.getTable().getSelection().deselectAll();
            if (this.scenario != null) {
                this.scenario.getTargetPlatform().getModuleList().reload(this.taskListener);
                this.scenario.getTargetPlatform().getDaemonSession().reloadHostProperties();
            }
            this.rebuild();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public long getSizeDeltaOnCommit() {
        long result = 0L;
        for (int i = 0; i < this.getRowCount(); ++i) {
            result += this.getRow(i).getSizeDeltaOnCommit();
        }
        return result;
    }

    public void resetScenario() {
        try {
            this.scenario = new InstallScenario(this.scenario.getTargetPlatform(), this.taskListener, null, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), this.certValidator);
            this.updateValues(true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void sortByColumn(int col, boolean ascending) {
        if (!this.needsSort && col == this.sortColumn && ascending == this.sortAscending) {
            return;
        }
        this.sortColumn = col;
        this.sortAscending = ascending;
        this.updateValues(true);
    }

    public void setFilter(BInstallerTableRowFilter value) {
        this.filter = value;
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.updateValues(true);
        }
    }

    public BInstallerTableRowFilter getFilter() {
        return this.filter;
    }

    public void updateTable(boolean resizeColumns) {
        this.needsSort = true;
        for (InstallerTableRow row : this.rows) {
            row.updateRow();
        }
        super.updateTable(resizeColumns);
    }

    private void addCurrentPart(BPart part) {
        if (part == null || part.isNull()) {
            return;
        }
        InstallerTableRow row = this.rowsByPartSpec.get(part.getPartSpec());
        if (row == null) {
            row = this.makeRow();
            this.rowsByPartSpec.put(part.getPartSpec(), row);
        }
        row.setCurrentPart(part);
        row.updateRow();
    }

    protected InstallerTableRow makeRow() {
        return new InstallerTableRow(this);
    }

    private void checkDependencies(PartSpec spec, Map<PartSpec, BDependency> dependencyByPartSpec, Set<PartSpec> checkedPartSpecs, BDependency dep) {
        BPart part;
        if (checkedPartSpecs.contains(spec)) {
            return;
        }
        checkedPartSpecs.add(spec);
        InstallerTableRow row = this.rowsByPartSpec.get(spec);
        if (row == null) {
            return;
        }
        if (dep == null) {
            part = row.getInstallablePart() == null ? row.getCurrentPart() : row.getInstallablePart();
        } else {
            part = row.getCurrentPart();
            if (part == null || !part.meets(dep)) {
                part = row.getHighestVersionedPart();
            }
            if (part == null) {
                part = row.getInstallablePart();
            }
        }
        if (part != null) {
            for (BDependency depend : part.getDependencyArray()) {
                BDependency oldDep = dependencyByPartSpec.get(depend.getPartSpec());
                if (oldDep == null) {
                    dependencyByPartSpec.put(depend.getPartSpec(), depend);
                    this.checkDependencies(depend.getPartSpec(), dependencyByPartSpec, checkedPartSpecs, depend);
                } else if (depend.supersedes(oldDep)) {
                    dependencyByPartSpec.put(depend.getPartSpec(), depend);
                }
                InstallerTableRow depRow = this.rowsByPartSpec.get(depend.getPartSpec());
                if (depRow == null) continue;
                depRow.addReverseDep(row, depend);
            }
        }
    }

    private void addInstallable(BInstallable installable) {
        BInstallable old;
        if (installable == null || installable.getPart() == null) {
            return;
        }
        InstallerTableRow row = this.rowsByPartSpec.get(installable.getPart().getPartSpec());
        if (row == null) {
            row = this.makeRow();
            this.rowsByPartSpec.put(installable.getPart().getPartSpec(), row);
        }
        if (this.isUpgrade(installable, old = row.getInstallable())) {
            row.setInstallable(installable);
            row.updateRow();
        }
    }

    private boolean isUpgrade(BInstallable i1, BInstallable i2) {
        if (i1 == null) {
            return false;
        }
        if (i2 == null) {
            return true;
        }
        switch (i2.getVersion().checkVersionRequirement(i1.getVersion())) {
            case 2: {
                if (i2 instanceof BModuleInstallable) {
                    BModulePart m1 = (BModulePart)i1.getPart();
                    BModulePart m2 = (BModulePart)i2.getPart();
                    if (m1.getBuildAbsTime() != null && m2.getBuildAbsTime() != null) {
                        int dateComp = m1.getBuildAbsTime().compareTo((Object)m2.getBuildAbsTime());
                        if (dateComp > 0) {
                            return true;
                        }
                        if (dateComp < 0) {
                            return false;
                        }
                    }
                }
                return false;
            }
            case 8: 
            case 16: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BModuleContent getTargetModuleContent() {
        return this.getScenario().getTargetPlatform().getModuleContent();
    }

    public boolean getTargetStripLineNumbers() {
        return this.getScenario().getTargetPlatform().getStripLineNumbers();
    }

    protected InstallerTableRow getRow(int row) {
        return this.rows.get(row);
    }

    protected InstallerTableRow getRow(PartSpec spec) {
        return this.rowsByPartSpec.get(spec);
    }

    private static String nvl(Object objectIn, String forNull) {
        return objectIn == null ? forNull : objectIn.toString();
    }

    protected void updateValues(boolean resort) {
        OriginalOrderComparator originalOrder = new OriginalOrderComparator(this.rows);
        this.needsSort = false;
        this.rows = new ArrayList<InstallerTableRow>(this.rowsByPartSpec.values());
        if (resort) {
            this.rows.sort(new InstallerTableRowComparator());
        } else {
            this.rows.sort(originalOrder);
        }
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.rows = this.rows.stream().filter(this.filter::accept).collect(Collectors.toList());
        }
        this.getTable().getSelection().deselectAll();
        this.updateTable(true);
    }

    private String getElapsed() {
        long prior = this.elapsed;
        this.elapsed = Clock.ticks();
        return prior == 0L ? "" : this.elapsed - prior + " ms";
    }

    private class InstallerTableRowComparator
    implements Comparator<InstallerTableRow> {
        private final List<Comparator<InstallerTableRow>> comparators;

        public InstallerTableRowComparator() {
            int i;
            int[] sortColumns = new int[4];
            sortColumns[0] = InstallerTableModel.this.sortColumn;
            int next = 1;
            for (i = 0; i < sortColumns.length; ++i) {
                if (i == InstallerTableModel.this.sortColumn) continue;
                sortColumns[next++] = i;
            }
            this.comparators = new ArrayList<Comparator<InstallerTableRow>>();
            for (i = 0; i < 4; ++i) {
                this.comparators.add(new InstallerColumnComparator(sortColumns[i], InstallerTableModel.this.sortAscending));
            }
        }

        @Override
        public int compare(InstallerTableRow o1, InstallerTableRow o2) {
            for (Comparator<InstallerTableRow> c : this.comparators) {
                int result = c.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    protected class OriginalOrderComparator
    implements Comparator<InstallerTableRow> {
        Map<String, Integer> sequenceMapByPartName = new HashMap<String, Integer>();

        public OriginalOrderComparator(List<InstallerTableRow> pRows) {
            if (pRows != null) {
                for (int i = 0; i < pRows.size(); ++i) {
                    this.sequenceMapByPartName.put(pRows.get(i).getInstallableName(), i);
                }
            }
        }

        @Override
        public int compare(InstallerTableRow r1, InstallerTableRow r2) {
            Integer s1 = this.sequenceMapByPartName.get(r1.getInstallableName());
            Integer s2 = this.sequenceMapByPartName.get(r2.getInstallableName());
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private static class InstallerColumnComparator
    implements Comparator<InstallerTableRow> {
        private final int comparatorSortColumn;
        private final boolean comparatorAscending;

        public InstallerColumnComparator(int comparatorSortColumn, boolean comparatorAscending) {
            this.comparatorSortColumn = comparatorSortColumn;
            this.comparatorAscending = comparatorAscending;
        }

        @Override
        public int compare(InstallerTableRow row1, InstallerTableRow row2) {
            int sortDirection = this.comparatorAscending ? 1 : -1;
            switch (this.comparatorSortColumn) {
                case 3: {
                    return sortDirection * COMMENT_COLUMN_COMPARATOR.compare(row1, row2);
                }
                case 0: {
                    if (row1.getInstallableName() == null) {
                        if (row2.getInstallableName() == null) {
                            return 0;
                        }
                        return sortDirection;
                    }
                    if (row2.getInstallableName() == null) {
                        return sortDirection * -1;
                    }
                    return sortDirection * TextUtil.toLowerCase((String)row1.getInstallableName()).compareTo(TextUtil.toLowerCase((String)row2.getInstallableName()));
                }
                case 1: {
                    if (row1.getCurrentPart() == null) {
                        if (row2.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1 * sortDirection;
                    }
                    if (row2.getCurrentPart() == null) {
                        return sortDirection;
                    }
                    int result = row1.getCurrentPart().getVersion().compareTo((Object)row2.getCurrentPart().getVersion());
                    result = result == 0 ? Integer.compare(row1.getCurrentSigningStatus(), row2.getCurrentSigningStatus()) : result;
                    return sortDirection * result;
                }
                case 2: {
                    if (row1.getInstallable() == null) {
                        if (row2.getInstallable() == null) {
                            return 0;
                        }
                        return -1 * sortDirection;
                    }
                    if (row2.getInstallable() == null) {
                        return sortDirection;
                    }
                    int result = row1.getInstallablePart().getVersion().compareTo((Object)row2.getInstallablePart().getVersion());
                    result = result == 0 ? Integer.compare(row1.getInstallableSigningStatus(), row2.getInstallableSigningStatus()) : result;
                    return sortDirection * result;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

