/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDeleteFileInstallable;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.StationWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class FinalStep
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private StationWizardModel wizardModel;
    private String lastText = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private List<TaskDetailPane.TaskItem> items;
    private DaemonSessionTaskListener taskListener;
    private TaskDetailPane.TaskItem stopStationItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.stopStation"));
    private TaskDetailPane.TaskItem saveStationItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.saveStation"));
    private TaskDetailPane.TaskItem stopAllStationsItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.stopAllStations"));
    private TaskDetailPane.TaskItem deleteItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.delete"));
    private TaskDetailPane.TaskItem transferItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.transfer"));
    private TaskDetailPane.TaskItem startStationsItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.startStations"));
    private TaskDetailPane.TaskItem rebootItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.reboot"));

    public FinalStep(StationWizardModel wizardModel) {
        try {
            BStationSurrogate[] subdir;
            this.wizardModel = wizardModel;
            this.items = new ArrayList<TaskDetailPane.TaskItem>();
            if (wizardModel.isLocalToRemote() && wizardModel.getDependencyAnalysis().getSolution().getToInstall().length > 0 && BStationSurrogate.isAnyStationRunning((BDaemonSession)wizardModel.getDaemonSession())) {
                this.items.add(this.stopAllStationsItem);
            } else if (wizardModel.getStationSurrogate() != null && wizardModel.getStationSurrogate().isStationRunning()) {
                if (wizardModel.isLocalToRemote()) {
                    this.items.add(this.stopStationItem);
                } else {
                    this.items.add(this.saveStationItem);
                }
            }
            if (wizardModel.getStationDisposition() == BStationDispositionEnum.clean && (subdir = (BStationSurrogate[])wizardModel.getTargetStationsRoot().getNavChild(wizardModel.getTargetStationName())) != null) {
                this.items.add(this.deleteItem);
            }
            this.items.add(this.transferItem);
            if (wizardModel.shouldReboot()) {
                this.items.add(this.rebootItem);
            } else if (wizardModel.allowStationRestart() && (this.items.contains(this.stopStationItem) || this.items.contains(this.stopAllStationsItem) || wizardModel.startStation())) {
                if (wizardModel.startStation()) {
                    this.items.add(this.startStationsItem);
                } else {
                    for (BStationSurrogate station : BStationSurrogate.makeAll((BDaemonSession)wizardModel.getDaemonSession())) {
                        if (station.getStationName().equals(wizardModel.getTargetStationName())) continue;
                        this.items.add(this.startStationsItem);
                        break;
                    }
                }
            }
            this.init((BWidget)wizardModel.getWizard());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public StationWizardModel getWizardModel() {
        return this.wizardModel;
    }

    @Override
    public String getHeadingTitle() {
        return lex.getText("StationCopier.FinalStep.dialogHeading");
    }

    @Override
    public String getDialogTitle() {
        return lex.getText("StationCopier.FinalStep.dialogTitle");
    }

    @Override
    public BImage getHeadingIcon() {
        return StationWizardModel.WIZ_IMAGE;
    }

    @Override
    public String getItemListHeading() {
        return lex.getText("StationCopier.FinalStep.itemHeading");
    }

    @Override
    public TaskDetailPane.TaskItem[] makeTaskItems() {
        return this.items.toArray(new TaskDetailPane.TaskItem[0]);
    }

    public void taskStarted(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
        if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask task) {
        this.taskListener.taskFinished(task);
    }

    @Override
    public void run() {
        block26: {
            try {
                BDirectory subdir;
                BDirectory targetStations = this.getWizardModel().getTargetStationsRoot();
                this.taskListener = new DaemonSessionTaskHandler((BWidget)this.getDialog());
                LinkedHashSet<String> namesToStart = new LinkedHashSet<String>();
                if (this.items.contains(this.stopAllStationsItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.stopAll"));
                    this.setCurrentItem(this.stopAllStationsItem, BJobState.running);
                    for (BStationSurrogate stopped : BStationSurrogate.stopAllStations((BDaemonSession)this.getWizardModel().getDaemonSession(), (ICancelHint)this, (DaemonSessionTaskListener)this.taskListener)) {
                        if (stopped.getStationName().equals(this.getWizardModel().getTargetStationName())) continue;
                        namesToStart.add(stopped.getStationName());
                    }
                    if (this.wizardModel.startStation()) {
                        namesToStart.add(this.getWizardModel().getTargetStationName());
                    }
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.items.contains(this.stopStationItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.stopOne", new Object[]{this.getWizardModel().getTargetStationName()}));
                    this.setCurrentItem(this.stopStationItem, BJobState.running);
                    this.getWizardModel().getStationSurrogate().stopStation((ICancelHint)this, this.taskListener);
                    if (this.wizardModel.startStation()) {
                        namesToStart.add(this.getWizardModel().getTargetStationName());
                    }
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.items.contains(this.saveStationItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.saving", new Object[]{this.getWizardModel().getSourceStationName()}));
                    this.setCurrentItem(this.saveStationItem, BJobState.running);
                    this.getWizardModel().getStationSurrogate().saveStation((ICancelHint)this, this.taskListener);
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.wizardModel.startStation()) {
                    namesToStart.add(this.getWizardModel().getTargetStationName());
                }
                if (this.getWizardModel().getStationDisposition() == BStationDispositionEnum.clean && (subdir = (BDirectory)targetStations.getNavChild(this.getWizardModel().getTargetStationName())) != null) {
                    this.setCurrentItem(this.deleteItem, BJobState.running);
                    DaemonFileUtil.deleteFile((BIFile)subdir);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.deleted"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                }
                ArrayList<BInstallable> installables = null;
                if (this.getWizardModel().isLocalToRemote()) {
                    installables = new ArrayList<BInstallable>();
                    for (String stationName2 : this.getWizardModel().getStationsToDelete()) {
                        BStationSurrogate.stopStation((BDaemonSession)this.getWizardModel().getDaemonSession(), (String)stationName2, (ICancelHint)this, (DaemonSessionTaskListener)this.taskListener);
                        installables.add((BInstallable)new BDeleteFileInstallable(SystemFilePaths.getStationsDirPath((boolean)true).merge(stationName2)));
                    }
                }
                this.setCurrentItem(this.transferItem, BJobState.running);
                for (BIFile transferContent : this.getWizardModel().getTransferContents()) {
                    this.checkCanceled();
                    this.transfer(transferContent, installables);
                }
                if (installables != null) {
                    this.checkCanceled();
                    InstallScenario solution = this.getWizardModel().getDependencyAnalysis().getSolution().solve((DaemonSessionTaskListener)this, null, null, installables.toArray(new BInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                    if (!solution.canCommit()) {
                        for (UnmeetableDependency unmet : solution.getUnmeetableDependencies()) {
                            this.getLog().append(lex.getText("StationCopier.FinalStep.unmetDependenciesMain", new Object[]{unmet}));
                            this.getLog().append("\n");
                        }
                        this.getLog().append(lex.getText("StationCopier.FinalStep.failure"));
                        this.getLog().append("\n");
                        this.updateCurrentItemState(BJobState.failed);
                        this.setBottomLabelText(lex.getText("StationCopier.FinalStep.failure"));
                        return;
                    }
                    solution.commit((DaemonSessionTaskListener)this, new StoreCache(), (ICancelHint)this, false, Optional.of(this.getWizardModel().makeFileTransferInitializer()));
                    this.checkCanceled();
                    this.setCancelEnabled(true);
                    ArrayList<UpdateStationMessage> messages = new ArrayList<UpdateStationMessage>();
                    this.getWizardModel().getStationsToDelete().forEach(stationName -> messages.add((UpdateStationMessage)new DeleteStationMessage(stationName)));
                    messages.add(new UpdateStationMessage());
                    messages.add(new UpdateStationMessage(this.getWizardModel().getTargetStationName(), false, this.getWizardModel().isAutoStart(), this.getWizardModel().isAutoRestart(), true));
                    this.getWizardModel().getDaemonSession().sendMessages(messages.toArray(new XmlResponseMessage[0]), BDaemonSession.DEFAULT_TIMEOUT);
                }
                this.updateCurrentItemState(BJobState.success);
                if (this.items.contains(this.startStationsItem)) {
                    this.setCurrentItem(this.startStationsItem, BJobState.running);
                    for (String stationName3 : namesToStart) {
                        BStationSurrogate toStart;
                        if (this.getWizardModel().getStationsToDelete().contains(stationName3) || (toStart = BStationSurrogate.make((BDaemonSession)this.getWizardModel().getDaemonSession(), (String)stationName3)) == null) continue;
                        toStart.startStationAsync();
                        this.getLog().append(lex.getText("StationCopier.FinalStep.started", new Object[]{toStart.getStationName()}));
                        this.getLog().append("\n");
                    }
                    this.updateCurrentItemState(BJobState.success);
                }
                if (this.items.contains(this.rebootItem)) {
                    this.setCurrentItem(this.rebootItem, BJobState.running);
                    this.getWizardModel().getDaemonSession().sendRebootRequest();
                    this.getLog().append(lex.getText("StationCopier.FinalStep.reboot"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.success"));
                    this.getLog().append("\n");
                    break block26;
                }
                this.getLog().append(lex.getText("StationCopier.FinalStep.success"));
                this.getLog().append("\n");
                if (!this.getWizardModel().isLocalToRemote()) break block26;
                if (this.getWizardModel().getDependencyAnalysis().getSolution().getToInstall().length > 0) {
                    try {
                        this.getWizardModel().getRemoteModuleList().reset();
                    }
                    catch (Exception solution) {
                        // empty catch block
                    }
                }
                ArrayList<UpdateStationMessage> messages = new ArrayList<UpdateStationMessage>();
                messages.add(new UpdateStationMessage());
                messages.add(new UpdateStationMessage(this.getWizardModel().getTargetStationName(), false, this.getWizardModel().isAutoStart(), this.getWizardModel().isAutoRestart(), true));
                this.getWizardModel().getDaemonSession().sendMessages(messages.toArray(new XmlResponseMessage[0]), BDaemonSession.DEFAULT_TIMEOUT);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.success"));
            }
            catch (ICancelHint.CanceledException ce) {
                this.getLog().append("\n");
                this.getLog().append(lex.getText("StationCopier.FinalStep.canceled"));
                this.getLog().append("\n");
                this.cancel(false);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.canceled"));
            }
            catch (Exception e) {
                this.setCancelEnabled(true);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.failure"));
                this.getLog().append("\n");
                this.getLog().append(lex.getText("StationCopier.FinalStep.failure"));
                this.getLog().append("\n");
                this.getLog().append((Throwable)e);
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.failed);
                e.printStackTrace();
            }
        }
    }

    private void transfer(BIFile file, List<BInstallable> installables) throws AuthenticationException, ConnectException {
        if (installables == null) {
            this.getLog().append(file.getFilePath().getBody());
            this.getLog().append("\n");
            FilePath destination = this.getDestDir(file.getFilePath()).merge(file.getFileName());
            BIFileStore store = file.getStore();
            boolean localTransferResult = false;
            if (store instanceof BDaemonFileStore) {
                localTransferResult = ((BDaemonFileStore)file.getStore()).copyToLocalHost(destination);
            } else if (store instanceof BDaemonDirectoryStore) {
                localTransferResult = ((BDaemonDirectoryStore)file.getStore()).copyToLocalHost(destination);
            } else {
                throw new BajaRuntimeException("Unsupported store: " + store);
            }
            if (!localTransferResult) {
                if (file instanceof BBogFile) {
                    throw new LocalizableRuntimeException("platform", "RemoteFile.exception.localCopyBog", new Object[]{file.getFilePath().getBody()});
                }
                throw new LocalizableRuntimeException("platform", "RemoteFile.exception.localCopy", new Object[]{file.getFilePath().getBody()});
            }
        } else if (file instanceof BDirectory) {
            installables.add((BInstallable)new BFileInstallable((BDirectory)file, this.getDestDir(file.getFilePath()), true));
        } else {
            installables.add((BInstallable)new BFileInstallable(file, this.getDestDir(file.getFilePath())));
        }
    }

    private FilePath getDestDir(FilePath sourcePath) {
        FilePath result = this.getWizardModel().getTargetStationsRoot().getFilePath().merge(this.getWizardModel().getTargetStationName());
        for (int i = this.getWizardModel().getStationDirectory().getFilePath().depth(); i < sourcePath.depth() - 1; ++i) {
            result = result.merge(sourcePath.nameAt(i));
        }
        return result;
    }
}

