/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BToolTipTextField;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraTopic(name="dirModified", eventType="BWidgetEvent")
public class BDirectoryChoice
extends BEdgePane {
    @Generated
    public static final Topic dirModified = BDirectoryChoice.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDirectoryChoice.class);
    private BToolTipTextField text;
    private BDirectory dirValue;
    private boolean showNormalized = true;
    private BFileSpace fileSpace;
    private ChangeDirectoryCommand command;

    @Generated
    public void fireDirModified(BWidgetEvent event) {
        this.fire(dirModified, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDirectoryChoice(BDirectory value, Command selectCommand) {
        this(selectCommand, (BFileSpace)BFileSystem.INSTANCE, true, 30);
        this.setDirectory(value);
    }

    public BDirectoryChoice(BDirectory value) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, true, 30);
        this.setDirectory(value);
    }

    public BDirectoryChoice(boolean showChangeButton) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, showChangeButton, 30);
    }

    public BDirectoryChoice(boolean showChangeButton, int visibleColumns) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, showChangeButton, visibleColumns);
    }

    public BDirectoryChoice() {
        this(null, (BFileSpace)BFileSystem.INSTANCE, true, 30);
    }

    public BDirectoryChoice(Command selectCommand, BFileSpace fileSpace) {
        this(selectCommand, fileSpace, true, 30);
    }

    public BDirectoryChoice(Command selectCommand, BFileSpace fileSpace, boolean showChangeButton, int visibleColumns) {
        this.text = new BToolTipTextField("", visibleColumns);
        this.text.setEditable(false);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.text, 3.0, 0.0, 0.0, 0.0));
        this.command = new ChangeDirectoryCommand(selectCommand);
        if (showChangeButton) {
            BButton changeButton = new BButton((Command)this.command, false, true);
            changeButton.setButtonStyle(BButtonStyle.toolBar);
            BToolBar buttons = new BToolBar();
            buttons.add("edit", (BValue)changeButton);
            this.setRight((BWidget)buttons);
        }
        this.setFileSpace(fileSpace);
    }

    public void setDirectory(BDirectory value) {
        if (value != null && !value.isDirectory()) {
            throw new IllegalArgumentException("Argument must be a directory");
        }
        this.dirValue = value;
        this.text.setText(this.getDisplayPath());
        if (this.dirValue != null) {
            this.setFileSpace(this.dirValue.getFileSpace());
        }
        this.fireDirModified(new BWidgetEvent(1, (BWidget)this));
    }

    public BDirectory getDirectory() {
        return this.dirValue;
    }

    public File getDirectoryFile() {
        if (this.dirValue == null) {
            return null;
        }
        return ((BLocalFileStore)this.dirValue.getStore()).getLocalFile();
    }

    public String getDisplayPath() {
        if (this.dirValue == null) {
            return null;
        }
        if (this.showNormalizedPath()) {
            return this.getNormalizedFilePath().getBody();
        }
        return this.getFilePath().getBody();
    }

    public BFileSpace getFileSpace() {
        return this.fileSpace;
    }

    public void setFileSpace(BFileSpace value) {
        this.fileSpace = value;
    }

    public FilePath getFilePath() {
        if (this.dirValue == null) {
            return null;
        }
        return this.dirValue.getFilePath();
    }

    public ChangeDirectoryCommand getChangeDirectoryCommand() {
        return this.command;
    }

    public FilePath getNormalizedFilePath() {
        if (this.dirValue == null) {
            return null;
        }
        return DaemonFileUtil.getNormalizedFilePath((BIFileStore)this.dirValue.getStore());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.command.setEnabled(enabled);
    }

    public boolean showNormalizedPath() {
        return this.showNormalized;
    }

    public void setShowNormalizedPath(boolean value) {
        this.showNormalized = value;
    }

    private static class DirectoryTreeNode
    extends TreeNode {
        private BDirectory dir;
        private Array<DirectoryTreeNode> children = null;
        private Map<String, DirectoryTreeNode> childByName = null;

        public DirectoryTreeNode(BDirectory dir, TreeNode parent) {
            super(parent);
            this.dir = dir;
        }

        public String getText() {
            return this.dir.getNavDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.dir.getNavIcon());
        }

        public boolean hasChildren() {
            if (this.children == null) {
                return true;
            }
            return this.children.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int getChildCount() {
            if (this.children == null) {
                try {
                    if (!(this.dir.getFileSpace() instanceof BFileSystem)) {
                        this.getTree().enterBusy();
                    }
                    this.children = new Array(DirectoryTreeNode.class);
                    this.childByName = new HashMap<String, DirectoryTreeNode>();
                    if (this.dir.hasNavChildren()) {
                        BIFile[] kids;
                        for (BIFile kid : kids = this.dir.listFiles()) {
                            if (!(kid instanceof BDirectory)) continue;
                            DirectoryTreeNode child = new DirectoryTreeNode((BDirectory)kid, this);
                            this.children.add((Object)child);
                            this.childByName.put(kid.getFileName(), child);
                        }
                    }
                }
                finally {
                    if (!(this.dir.getFileSpace() instanceof BFileSystem)) {
                        this.getTree().exitBusy();
                    }
                }
            }
            return this.children.size();
        }

        public TreeNode getChild(int index) {
            this.getChildCount();
            return (TreeNode)this.children.get(index);
        }

        public DirectoryTreeNode getChild(String name) {
            this.getChildCount();
            return this.childByName.get(name);
        }

        public BDirectory getDirectory() {
            return this.dir;
        }

        public FilePath getFilePath() {
            return this.dir.getFilePath();
        }

        public String toString() {
            return this.dir.getFilePath().getBody();
        }
    }

    private static class DirectoryTreeRoot
    extends TreeNode {
        private BFileSpace fileSpace;
        private Array<DirectoryTreeNode> children;

        public DirectoryTreeRoot(BFileSpace fileSpace, TreeModel model) {
            super(model);
            BIFile[] kids;
            this.fileSpace = fileSpace;
            this.children = new Array(DirectoryTreeNode.class);
            for (BIFile kid : kids = fileSpace.listFiles()) {
                if (!(kid instanceof BDirectory)) continue;
                BDirectory dir = (BDirectory)kid;
                DirectoryTreeNode child = new DirectoryTreeNode(dir, this);
                this.children.add((Object)child);
            }
            this.setExpanded(true);
        }

        public String getText() {
            return this.fileSpace.getNavDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.fileSpace.getNavIcon());
        }

        public int getChildCount() {
            return this.children.size();
        }

        public TreeNode getChild(int index) {
            return (TreeNode)this.children.get(index);
        }

        public DirectoryTreeNode getChild(FilePath path) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                DirectoryTreeNode child = (DirectoryTreeNode)this.getChild(i);
                if (!DaemonFileUtil.isSubPath((FilePath)path, (FilePath)child.getFilePath())) continue;
                return child;
            }
            return null;
        }
    }

    private static class DirectoryTreeModel
    extends TreeModel {
        private DirectoryTreeRoot root;

        public DirectoryTreeModel(BFileSpace fileSpace) {
            this.root = new DirectoryTreeRoot(fileSpace, this);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }

        public DirectoryTreeNode findNode(FilePath path) {
            DirectoryTreeNode node;
            block2: {
                if (path == null) {
                    return null;
                }
                node = this.root.getChild(path);
                if (node == null) break block2;
                while (node.getFilePath().depth() < path.depth() && (node = node.getChild(path.nameAt(node.getFilePath().depth()))) != null) {
                }
            }
            return node;
        }
    }

    private static class DirectoryTreeSelection
    extends TreeSelection {
        private BTextField textField;

        public DirectoryTreeSelection(BTextField textField) {
            this.textField = textField;
        }

        public void select(TreeNode node) {
            if (node instanceof DirectoryTreeNode) {
                super.select(node);
                BDirectory dir = ((DirectoryTreeNode)node).getDirectory();
                this.textField.setText(dir.getFilePath().getBody());
            }
        }

        public void deselectAll() {
            super.deselectAll();
            if (this.getNode() == null) {
                this.textField.setText("");
            }
        }

        public void deselect(TreeNode node) {
            super.deselect(node);
            if (this.getNode() == null) {
                this.textField.setText("");
            }
        }
    }

    private static class DirectoryTreeController
    extends TreeController {
        private BOptionDialog dialog;

        private DirectoryTreeController(BOptionDialog dialog) {
            this.dialog = dialog;
        }

        protected void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
            if (this.dialog.getOkButton().isEnabled()) {
                this.dialog.close(1);
            }
        }
    }

    private static class DirectoryPathTextModel
    extends TextModel {
        private BButton button;

        public DirectoryPathTextModel(BButton button) {
            this.button = button;
        }

        protected void textModified() {
            this.button.setEnabled(this.getText().trim().length() > 0);
        }
    }

    public class ChangeDirectoryCommand
    extends AsyncCommand {
        private Command selectCommand;

        public ChangeDirectoryCommand(Command pSelectCommand) {
            super((BWidget)BDirectoryChoice.this, TYPE.getModule(), "DirectoryChoice.changeDirectory");
            this.selectCommand = pSelectCommand;
        }

        public void doInvokeAsync() {
            DirectoryTreeNode selectedNode;
            DirectoryTreeModel model = new DirectoryTreeModel(BDirectoryChoice.this.fileSpace);
            BToolTipTextField currentPathTextField = new BToolTipTextField("", 30);
            BTree tree = new BTree((TreeModel)model);
            BScrollPane scrollPane = new BScrollPane((BWidget)tree);
            scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            BEdgePane textPane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platDaemon", (String)"DirectoryChoice.changeDirectory.path"), (boolean)true), 0.0, 5.0, 0.0, 0.0), null, (BWidget)currentPathTextField);
            tree.setSelection((TreeSelection)new DirectoryTreeSelection((BTextField)currentPathTextField));
            BOptionDialog dialog = new BOptionDialog((BWidget)BDirectoryChoice.this, BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.dlgTitle"), (BWidget)new BEdgePane((BWidget)new BBox(400.0, 0.0), (BWidget)new BBorderPane((BWidget)textPane, 0.0, 10.0, 10.0, 10.0), (BWidget)new BBox(0.0, 350.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 10.0, 5.0, 10.0)), 3, null, null);
            currentPathTextField.setModel((TextModel)new DirectoryPathTextModel(dialog.getOkButton()));
            tree.setController((TreeController)new DirectoryTreeController(dialog));
            dialog.setBoundsCenteredOnScreen();
            if (BDirectoryChoice.this.dirValue != null && (selectedNode = model.findNode(DaemonFileUtil.getNormalizedFilePath((BIFileStore)BDirectoryChoice.this.dirValue.getStore()))) != null) {
                tree.getSelection().select((TreeNode)selectedNode);
                tree.scrollNodeToVisible((TreeNode)selectedNode);
            }
            dialog.open();
            if (dialog.getResult() == 1) {
                FilePath newPath;
                try {
                    newPath = new FilePath(currentPathTextField.getText());
                }
                catch (Exception e) {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.badFilePath"));
                    return;
                }
                BIFile newFile = BDirectoryChoice.this.fileSpace.findFile(newPath);
                if (newFile == null) {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.notFound", new Object[]{newPath.getBody()}));
                } else if (newFile instanceof BDirectory) {
                    BDirectoryChoice.this.dirValue = (BDirectory)newFile;
                    BDirectoryChoice.this.text.setText(BDirectoryChoice.this.getDisplayPath());
                    BDirectoryChoice.this.fireDirModified(new BWidgetEvent(1, (BWidget)BDirectoryChoice.this));
                    if (this.selectCommand != null) {
                        this.selectCommand.invoke();
                    }
                } else {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.notDirectory", new Object[]{newPath.getBody()}));
                }
            }
        }

        public void setLabel(String value) {
            this.label = value;
        }

        public void setDescription(String value) {
            this.description = value;
        }
    }
}

