/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial.command;

import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.sys.BRelTime;

public final class SmsSendMsgCommand
extends SmsCommand {
    private String telephoneNum = "";
    private String message = "";
    private static final int MAX_MESSAGE_LENGTH = 140;

    public SmsSendMsgCommand(SmsCommand.ICommsImplementer comms, String newTelephoneNum, String newMessage) {
        super(comms);
        this.telephoneNum = newTelephoneNum;
        this.message = newMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doRun() {
        boolean success;
        block7: {
            success = false;
            if (this.message.length() > 140) {
                this.message = this.message.substring(0, 139);
            }
            try {
                this.comms.write("AT+CMGS=\"" + this.telephoneNum + "\"\r", ">", BRelTime.make((long)6000L));
                this.comms.write(this.message + "\u001a\r", "OK\r\n", BRelTime.make((long)8000L));
                SmsSendMsgCommand smsSendMsgCommand = this;
                synchronized (smsSendMsgCommand) {
                    this.wait(500L);
                }
                success = true;
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("SMSSendMsgCommand.execute(CommsManager): We have successfully sent the text message!");
                }
            }
            catch (Exception e) {
                if (!SmsToolkit.log.isLoggable(Level.FINE)) break block7;
                SmsToolkit.log.fine("SMSSendMsgCommand.execute(CommsManager): Failed to send message through SMS manager");
            }
        }
        return success;
    }

    public String toString() {
        return SmsToolkit.getText("smsCommand.send");
    }
}

