/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.BProgramService;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.RobotEditorCommands;
import com.tridium.program.ui.signing.BCertificateNotTrustedDialog;
import com.tridium.workbench.console.BConsole;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.JavaParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"program:ProgramService"})})
public class BRobotEditor
extends BWbComponentView
implements BConsole.HyperlinkInterceptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BRobotEditor.class);
    static String defaultDepends = "baja; program";
    static String defaultCode = "// depends: " + defaultDepends + "\n\nimport javax.baja.sys.*;\nimport com.tridium.program.*;\n\npublic class RobotImpl\n  extends Robot\n{\n\n  public void run()\n    throws Exception\n  {\n    process(Sys.getStation());\n  }\n\n  public void process(BComponent c)\n    throws Exception\n  {\n    // do something here\n    log.println(c.toPathString() + \" [\" + c.getType() + \"]\");\n    \n    // recurse\n    BComponent[] kids = c.getChildComponents();\n    for(int i=0; i<kids.length; ++i)\n      process(kids[i]);\n  }\n\n}\n";
    static Lexicon lex = Lexicon.make((String)"program");
    RobotEditorCommands commands = new RobotEditorCommands(this);
    BProgramService service;
    BTextEditor editor;
    RobotCompiler compiler = new RobotCompiler(this);
    BRobotCode robotCode = new BRobotCode();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRobotEditor() {
        this.editor = new BTextEditor();
        this.editor.setParser((TextParser)new JavaParser());
        this.editor.setText(defaultCode);
        this.setTransferWidget((BTransferWidget)this.editor);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(9, true);
        this.setCommandEnabled(10, true);
        BTextEditorPane editorPane = new BTextEditorPane(this.editor);
        this.setContent((BWidget)editorPane);
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    public void doLoadValue(BObject value, Context cx) {
        this.service = (BProgramService)value;
    }

    public void deactivated() {
        super.deactivated();
        defaultCode = this.editor.getText();
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 6: {
                return this.editor.doFind();
            }
            case 8: {
                return this.editor.doFindNext();
            }
            case 7: {
                return this.editor.doFindPrev();
            }
            case 9: {
                return this.editor.doReplace();
            }
            case 10: {
                return this.editor.doGoto();
            }
        }
        return super.invokeCommand(id);
    }

    public boolean consoleHyperlink(File file, int line1, int col1, int line2, int col2) {
        if (!file.equals(this.compiler.java)) {
            return false;
        }
        this.highlight(line1, col1, line2, col2);
        return true;
    }

    public void highlight(int line1, int col1, int line2, int col2) {
        this.highlight(this.editor, line1, col1, line2, col2);
    }

    void highlight(BTextEditor text, int line1, int col1, int line2, int col2) {
        Position end = text.getModel().getEndPosition();
        Position p1 = new Position(line1 - 1, col1 - 1);
        Position p2 = new Position(line2 - 1, col2);
        if (p1.compareTo(end) > 0) {
            p1 = end;
        }
        if (p2.compareTo(end) > 0) {
            p2 = end;
        }
        text.getSelection().select(p1, p2);
        text.moveCaretPosition(p2);
        text.requestFocus();
    }

    public void run() {
        BRobotResult r = this.service.runRobot(this.robotCode);
        BBlob certBlob = r.getUntrustedCertificate();
        if (certBlob.length() > 0) {
            try {
                byte[] certBytes = certBlob.copyBytes();
                try (ByteArrayInputStream inputBytes = new ByteArrayInputStream(certBytes);){
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(inputBytes);
                    NX509Certificate cert = NX509Certificate.make((X509Certificate)x509Certificate);
                    if (BCertificateNotTrustedDialog.installUntrustedCertificate(cert, (BWidget)this, (BComponent)this.service)) {
                        this.run();
                    } else {
                        BDialog.error((BWidget)this, (Object)lex.getText("robot.certNotTrusted"));
                    }
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)lex.getText("program.couldNotInstallCert"), (Throwable)e);
            }
        } else {
            BTextEditor out = new BTextEditor(r.getLog(), false);
            BTextEditorPane pane = new BTextEditorPane(out, 20, 80);
            BDialog.open((BWidget)this, (String)"Log Output", (Object)pane, (int)1);
        }
    }

    public String parseDepends(String text) throws Exception {
        if (text.startsWith("// depends:")) {
            int colon = text.indexOf(58);
            int nl = text.indexOf(10);
            if (colon >= 0 && nl >= 0) {
                HashSet<String> deps = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(text.trim().substring(colon + 1, nl), ";");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    if (name.length() <= 0 || BProgram.isSpecialModule((String)name)) continue;
                    this.accumDepends(deps, Sys.getRegistry().getModule(name, RuntimeProfile.rt).getModulePartName());
                }
                StringBuilder result = new StringBuilder();
                for (String dep : deps) {
                    if (result.length() > 0) {
                        result.append("; ");
                    }
                    result.append(dep);
                }
                return result.toString();
            }
        }
        return defaultDepends;
    }

    protected void accumDepends(Set<String> acc, String modulePartName) throws Exception {
        DependencyInfo[] deps;
        if (acc.contains(modulePartName)) {
            return;
        }
        acc.add(modulePartName);
        for (DependencyInfo dep : deps = Sys.getRegistry().moduleForDependency(modulePartName).getDependencies()) {
            this.accumDepends(acc, dep.getModulePartName());
        }
    }

    class RobotCompiler
    extends Compiler {
        boolean runOnSuccess;

        RobotCompiler(BRobotEditor editor) {
            super((BWidget)editor);
        }

        public void compile(boolean runOnSuccess) throws Exception {
            this.runOnSuccess = runOnSuccess;
            String source = BRobotEditor.this.editor.getText();
            String className = BCode.generateClassName();
            int x = source.indexOf("RobotImpl");
            if (x < 0) {
                throw new Exception("Class name must be RobotImpl");
            }
            source = TextUtil.replace((String)source, (String)"RobotImpl", (String)className);
            BRobotEditor.this.robotCode.setDependencies(BRobotEditor.this.parseDepends(source));
            this.compile(className, (BCode)BRobotEditor.this.robotCode, source);
        }

        @Override
        public void compileSuccess(BConsole console) throws Exception {
            super.compileSuccess(console);
            if (this.runOnSuccess) {
                BRobotEditor.this.run();
            }
        }
    }
}

