/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.ui.BMacAddressFE;
import com.tridium.platwifi.ui.BWifiWhiteListEditorDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiMacAddressVector"})})
@NiagaraActions(value={@NiagaraAction(name="handleFocusChange", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="setEnabledStates", flags=4)})
public class BWifiMacAddressVectorEditor
extends BWbView {
    @Generated
    public static final Action handleFocusChange = BWifiMacAddressVectorEditor.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action setEnabledStates = BWifiMacAddressVectorEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiMacAddressVectorEditor.class);
    private final BGridPane contentPane;
    private BMacAddressFE focusedEditor;
    private final Command addCommand;
    private final Command deleteCommand;
    private final BWifiWhiteListEditorDialog dialog;
    private int maxWifiMacs = 20;
    private static final String MAX_WIFI_MACS = "maxWifiMacs";
    private static final Logger log = Logger.getLogger("wifi");

    @Generated
    public void handleFocusChange(BFocusEvent parameter) {
        this.invoke(handleFocusChange, (BValue)parameter, null);
    }

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiMacAddressVectorEditor(BWifiWhiteListEditorDialog dialog) {
        this.dialog = dialog;
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.contentPane = new BGridPane(1);
        this.contentPane.setHalign(BHalign.center);
        BBorderPane contentBorder = new BBorderPane((BWidget)this.contentPane, new BLabel("Whitelist MAC Addresses"), BBorder.ridge);
        contentBorder.setMargin(BInsets.make((double)20.0, (double)20.0, (double)20.0, (double)20.0));
        BEdgePane contentEdgePane = new BEdgePane();
        contentEdgePane.setTop((BWidget)contentBorder);
        contentEdgePane.setBottom((BWidget)toolbarPane);
        this.setEnabled(true);
        this.setContent((BWidget)contentEdgePane);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.maxWifiMacs = cx == null ? 20 : cx.getFacets().geti(MAX_WIFI_MACS, 20);
        BVector vector = (BVector)value;
        this.contentPane.removeAll();
        SlotCursor c = vector.loadSlots().getProperties();
        while (c.next(BWifiMacAddress.class)) {
            this.addElement(c.get());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BWifiMacAddressVector vector = (BWifiMacAddressVector)value;
        vector.lease();
        vector.removeAll();
        if (vector.getSlotCount() > 0) {
            throw new Exception("Failed to remove WiFi MAC slots");
        }
        for (BWidget child : this.contentPane.getChildWidgets()) {
            BWifiMacAddress fieldValue = (BWifiMacAddress)((BMacAddressFE)child).saveValue(cx);
            if (fieldValue.getMac().trim().length() == 0) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.emptyAddress");
            }
            String propName = SlotPath.escape((String)fieldValue.getMac());
            if (vector.getProperty(propName) != null) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.duplicate", new Object[]{fieldValue});
            }
            vector.add(propName, (BValue)fieldValue, 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:MacAddressFE")), null);
        }
        if (vector.getSlotCount() != this.contentPane.getChildWidgets().length) {
            throw new Exception("Failed to add WiFi MAC slots");
        }
        return vector;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.deleteCommand.setEnabled(isEnabled && this.focusedEditor != null);
        BWidget[] children = this.contentPane.getChildWidgets();
        this.addCommand.setEnabled(isEnabled && children.length < this.maxWifiMacs);
        for (BWidget child : children) {
            child.setEnabled(isEnabled);
        }
    }

    protected void doSetReadonly(boolean readonly) {
        BWidget[] children;
        this.setEnabled(!readonly);
        for (BWidget child : children = this.contentPane.getChildWidgets()) {
            ((BWbFieldEditor)child).setReadonly(readonly);
        }
    }

    public void addElements(BValue[] values) {
        for (BValue value : values) {
            this.addElement(value);
        }
    }

    public void addElement(BValue value) {
        BMacAddressFE editor = new BMacAddressFE();
        editor.loadValue((BObject)value);
        this.contentPane.add(null, (BValue)editor, 0);
        this.contentPane.requestFocus();
        this.focusedEditor = editor;
        editor.setEnabled(this.isEnabled());
        this.getContent().relayout();
        this.relayout();
        this.dialog.relayout();
        this.dialog.setScreenSizeToPreferredSize();
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.isEnabled());
    }

    public void doHandleFocusChange(BFocusEvent evt) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (evt.getId() == 1005) {
                if (this.focusedEditor == evt.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (evt.getId() == 1004) {
                this.focusedEditor = (BMacAddressFE)evt.getWidget();
            }
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception occurred while handling focus change", e);
        }
    }

    public void doSetEnabledStates() {
    }

    public BMacAddressFE getFocusedEditor() {
        return this.focusedEditor;
    }

    public static Property[] getDynamicPropertiesArray(BObject obj, boolean autoLoad) {
        if (autoLoad) {
            obj.asComplex().loadSlots();
        }
        Property[] allProps = obj.asComplex().getPropertiesArray();
        for (int i = 0; i < allProps.length; ++i) {
            if (allProps[i].isFrozen()) continue;
            Property[] result = new Property[allProps.length - i];
            System.arraycopy(allProps, i, result, 0, result.length);
            return result;
        }
        return new Property[0];
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
        }

        public CommandArtifact doInvoke() {
            BWifiMacAddressVectorEditor.this.addElement((BValue)new BWifiMacAddress(""));
            BWifiMacAddressVectorEditor.this.computePreferredSize();
            BWifiMacAddressVectorEditor.this.relayout();
            super.setEnabled(BWifiMacAddressVectorEditor.this.contentPane.getChildWidgets().length < BWifiMacAddressVectorEditor.this.maxWifiMacs);
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BWifiMacAddressVectorEditor.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor c = BWifiMacAddressVectorEditor.this.contentPane.loadSlots().getProperties();
                while (c.next(BWbFieldEditor.class)) {
                    if (c.get() != BWifiMacAddressVectorEditor.this.focusedEditor) continue;
                    BWifiMacAddressVectorEditor.this.contentPane.remove(c.property());
                    BWifiMacAddressVectorEditor.this.focusedEditor = null;
                    BWifiMacAddressVectorEditor.this.deleteCommand.setEnabled(false);
                    BWifiMacAddressVectorEditor.this.addCommand.setEnabled(true);
                    BWifiMacAddressVectorEditor.this.setModified();
                    BWifiMacAddressVectorEditor.this.relayout();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }
}

