/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.security;

import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.PasswordTextController;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiWPAPSKSettings"})})
@NiagaraActions(value={@NiagaraAction(name="setEnabledStates"), @NiagaraAction(name="handleShowPasswordChecked"), @NiagaraAction(name="handlePskChanged", flags=4)})
public class BWifiWPAPSKEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BWifiWPAPSKEditor.newAction((int)0, null);
    @Generated
    public static final Action handleShowPasswordChecked = BWifiWPAPSKEditor.newAction((int)0, null);
    @Generated
    public static final Action handlePskChanged = BWifiWPAPSKEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiWPAPSKEditor.class);
    private BPasswordFE wpa_pskNetworkKeyFE = null;
    private BLimitedFrozenEnumFE pairwise_cipherFE = null;
    private BLimitedFrozenEnumFE groupwise_cipherFE = null;
    private BCheckBox wpa_pskShowPasswordFE = null;
    private boolean pskDirty = false;
    private boolean pskMustBeSet = false;

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void handleShowPasswordChecked() {
        this.invoke(handleShowPasswordChecked, null, null);
    }

    @Generated
    public void handlePskChanged() {
        this.invoke(handlePskChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void doLoadValue(BObject value, Context contextIn) {
        BFacets contextInFacets;
        int configurationMode;
        if (contextIn == null) {
            contextIn = new BasicContext((Context)BFacets.make((String)"configureMode", (int)0));
        }
        if ((configurationMode = (contextInFacets = contextIn.getFacets()).geti("configureMode", 0)) > 2 || configurationMode < 0) {
            configurationMode = 0;
        }
        this.pskMustBeSet = configurationMode != 0;
        BGridPane pane = new BGridPane();
        pane.setColumnAlign(BHalign.fill);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.setColumnGap(10.0);
        pane.setRowGap(6.0);
        this.pairwise_cipherFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.pairwise_cipher.label"), (BWidget)this.left((BWidget)this.pairwise_cipherFE));
        this.linkTo(null, (BComponent)this.pairwise_cipherFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.groupwise_cipherFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.group_cipher.label"), (BWidget)this.left((BWidget)this.groupwise_cipherFE));
        this.linkTo(null, (BComponent)this.groupwise_cipherFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpa_pskNetworkKeyFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPA_PSKNetworkKey.label"), (BWidget)this.wpa_pskNetworkKeyFE);
        this.linkTo(null, (BComponent)this.wpa_pskNetworkKeyFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa_pskNetworkKeyFE, (Slot)BPasswordFE.pluginModified, (Slot)handlePskChanged);
        this.wpa_pskShowPasswordFE = new BCheckBox();
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPA_PSKShowPassword.label"), (BWidget)this.wpa_pskShowPasswordFE);
        this.linkTo(null, (BComponent)this.wpa_pskShowPasswordFE, (Slot)BCheckBox.actionPerformed, (Slot)handleShowPasswordChecked);
        BWifiWPAPSKSettings settings = (BWifiWPAPSKSettings)value;
        this.pairwise_cipherFE.loadValue((BObject)settings.getPairwiseCipher(), (Context)new BasicContext(contextIn, BWifiWPAPSKSettings.pairwiseCipher.getFacets()));
        this.groupwise_cipherFE.loadValue((BObject)settings.getGroupCipher(), (Context)new BasicContext(contextIn, BWifiWPAPSKSettings.groupCipher.getFacets()));
        if (configurationMode == 0) {
            this.wpa_pskNetworkKeyFE.loadValue((BObject)settings.getNetworkKey(), contextIn);
        }
        this.pskDirty = false;
        this.setContent((BWidget)pane);
        this.doSetReadonly(this.isReadonly());
        this.doSetEnabledStates();
        this.pairwise_cipherFE.setReadonly(false);
        this.pairwise_cipherFE.setEnabled(true);
        this.groupwise_cipherFE.setReadonly(false);
        this.groupwise_cipherFE.setEnabled(true);
        if (configurationMode == 0) {
            this.wpa_pskShowPasswordFE.setSelected(false);
            this.wpa_pskShowPasswordFE.setEnabled(false);
        }
    }

    public final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BWifiWPAPSKSettings settings = (BWifiWPAPSKSettings)value;
        if (this.pskDirty) {
            BPassword password = (BPassword)this.wpa_pskNetworkKeyFE.saveValue(cx);
            String temp = AccessController.doPrivileged(() -> ((BPassword)password).getValue());
            if (temp.length() < 8) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyTooShort");
            } else if (temp.length() > 64) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyTooLong");
            } else if (temp.length() == 64) {
                if (!TextUtil.isHex((String)temp)) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyHexCharacter");
                }
            } else {
                char[] passwordChars;
                for (char passwordChar : passwordChars = temp.toCharArray()) {
                    if (passwordChar >= ' ' && passwordChar <= '~') continue;
                    this.saveError(this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyAsciiCharacter", new Object[]{String.valueOf(passwordChar)}));
                }
            }
            settings.setNetworkKey(password);
            this.pskDirty = false;
        } else if (this.pskMustBeSet) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.pskMustBeSet");
        }
        settings.setPairwiseCipher((BWifiEncryptionMethod)this.pairwise_cipherFE.saveValue(cx));
        settings.setGroupCipher((BWifiEncryptionMethod)this.groupwise_cipherFE.saveValue(cx));
        return settings;
    }

    private void saveError(String messageTag) throws CannotSaveException {
        throw new CannotSaveException(this.getLexicon().getText(messageTag));
    }

    private BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    public final void doSetEnabledStates() {
        boolean readonly = this.isReadonly();
        boolean enabledCondition = !readonly;
        boolean readonlyCondition = !enabledCondition;
        this.pairwise_cipherFE.setEnabled(enabledCondition);
        this.pairwise_cipherFE.setReadonly(readonlyCondition);
        this.wpa_pskNetworkKeyFE.setEnabled(enabledCondition);
        this.wpa_pskNetworkKeyFE.setReadonly(readonlyCondition);
        this.wpa_pskShowPasswordFE.setEnabled(enabledCondition);
    }

    public final void doEditorModified(BWidgetEvent event) {
    }

    public void doHandlePskChanged() {
        this.pskDirty = true;
        this.wpa_pskShowPasswordFE.setEnabled(true);
        this.setModified();
    }

    public void doHandleShowPasswordChecked() {
        boolean showPassword = this.wpa_pskShowPasswordFE.getSelected();
        BTextField passwordTextField = (BTextField)this.wpa_pskNetworkKeyFE.getContent();
        if (showPassword) {
            passwordTextField.setController(new TextController());
            passwordTextField.setRenderer(new TextRenderer());
            passwordTextField.setAllowCopying(true);
        } else {
            passwordTextField.setController((TextController)new PasswordTextController());
            passwordTextField.setRenderer((TextRenderer)new PasswordRenderer());
            passwordTextField.setAllowCopying(false);
        }
        this.wpa_pskNetworkKeyFE.relayout();
    }

    public void doSetReadonly(boolean readonly) {
        if (this.pairwise_cipherFE != null) {
            this.pairwise_cipherFE.setEnabled(!readonly);
            this.pairwise_cipherFE.setReadonly(readonly);
        }
        if (this.wpa_pskNetworkKeyFE != null) {
            this.wpa_pskNetworkKeyFE.setEnabled(!readonly);
            this.wpa_pskNetworkKeyFE.setReadonly(readonly);
        }
        if (this.wpa_pskShowPasswordFE != null) {
            this.wpa_pskShowPasswordFE.setEnabled(!readonly);
        }
    }
}

