/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.fox.sys.BFoxService;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.security.BISecurityService;
import com.tridium.signing.BIndividualSignedCertConfig;
import com.tridium.signing.ISwitchableSigningRequester;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.fox.BFoxSigningRequester;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="applyToFoxService", type="boolean", defaultValue="false"), @NiagaraProperty(name="applyToWebService", type="boolean", defaultValue="false"), @NiagaraProperty(name="applyToPlatform", type="boolean", defaultValue="false"), @NiagaraProperty(name="certToSignAndApply", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="signingRequesterType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"signingService:FoxSigningRequester\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"platCrypto:AbstractSigningRequester\")"), @Facet(name="BFacets.ALLOW_NULL", value="false"), @Facet(value="BFacets.make(\"showAbstract\", false)"), @Facet(value="BFacets.make(\"showInterface\", false)")}), @NiagaraProperty(name="signingRequester", type="BAbstractSigningRequester", defaultValue="new BFoxSigningRequester()"), @NiagaraProperty(name="lastSignedCertApplicationResults", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="onboardOnStarted", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="autoOnboardComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="onboard", parameterType="BString", defaultValue="BString.make(\"\")", flags=2048), @NiagaraAction(name="renew", flags=2048), @NiagaraAction(name="autoOnboard", parameterType="BFormat", defaultValue="BFormat.DEFAULT", flags=4)})
public final class BCombinedSignedCertConfig
extends BComponent
implements IRequesterComponent,
BIRestrictedComponent,
IPropertyValidator,
ISwitchableSigningRequester {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property applyToFoxService = BCombinedSignedCertConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property applyToWebService = BCombinedSignedCertConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property applyToPlatform = BCombinedSignedCertConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property certToSignAndApply = BCombinedSignedCertConfig.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property signingRequesterType = BCombinedSignedCertConfig.newProperty((int)0, (BValue)BTypeSpec.make((String)"signingService:FoxSigningRequester"), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"platCrypto:AbstractSigningRequester")), (BFacets)BFacets.make((String)"allowNull", (boolean)false)), (BFacets)BFacets.make((String)"showAbstract", (boolean)false)), (BFacets)BFacets.make((String)"showInterface", (boolean)false)));
    @Generated
    public static final Property signingRequester = BCombinedSignedCertConfig.newProperty((int)0, (BValue)new BFoxSigningRequester(), null);
    @Generated
    public static final Property lastSignedCertApplicationResults = BCombinedSignedCertConfig.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property onboardOnStarted = BCombinedSignedCertConfig.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property autoOnboardComment = BCombinedSignedCertConfig.newProperty((int)4, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Action onboard = BCombinedSignedCertConfig.newAction((int)2048, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action renew = BCombinedSignedCertConfig.newAction((int)2048, null);
    @Generated
    public static final Action autoOnboard = BCombinedSignedCertConfig.newAction((int)4, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCombinedSignedCertConfig.class);
    private static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"shield.png"), (BIcon)BIcon.std((String)"badges/ellipsis.png"));
    private static final Logger LOG = Logger.getLogger("signingService.requester");
    private static final Lexicon LEX = Lexicon.make(BCombinedSignedCertConfig.class);
    private static final String PLATFORM_LEX_TEXT = Lexicon.make((String)"fox").getText("nav.platform");
    private static final BString DEFAULT_REQUESTER_CERT_ALIAS_VALUE = BString.make((String)SigningServiceUtils.DEFAULT_REQUESTER_CERT_ALIAS);
    static final Context SKIP_UPDATE_CX = new BasicContext();

    @Generated
    public boolean getApplyToFoxService() {
        return this.getBoolean(applyToFoxService);
    }

    @Generated
    public void setApplyToFoxService(boolean v) {
        this.setBoolean(applyToFoxService, v, null);
    }

    @Generated
    public boolean getApplyToWebService() {
        return this.getBoolean(applyToWebService);
    }

    @Generated
    public void setApplyToWebService(boolean v) {
        this.setBoolean(applyToWebService, v, null);
    }

    @Generated
    public boolean getApplyToPlatform() {
        return this.getBoolean(applyToPlatform);
    }

    @Generated
    public void setApplyToPlatform(boolean v) {
        this.setBoolean(applyToPlatform, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertToSignAndApply() {
        return (BCertificateAliasAndPassword)this.get(certToSignAndApply);
    }

    @Generated
    public void setCertToSignAndApply(BCertificateAliasAndPassword v) {
        this.set(certToSignAndApply, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getSigningRequesterType() {
        return (BTypeSpec)this.get(signingRequesterType);
    }

    @Generated
    public void setSigningRequesterType(BTypeSpec v) {
        this.set(signingRequesterType, (BValue)v, null);
    }

    @Generated
    public BAbstractSigningRequester getSigningRequester() {
        return (BAbstractSigningRequester)this.get(signingRequester);
    }

    @Generated
    public void setSigningRequester(BAbstractSigningRequester v) {
        this.set(signingRequester, (BValue)v, null);
    }

    @Generated
    public String getLastSignedCertApplicationResults() {
        return this.getString(lastSignedCertApplicationResults);
    }

    @Generated
    public void setLastSignedCertApplicationResults(String v) {
        this.setString(lastSignedCertApplicationResults, v, null);
    }

    @Generated
    public boolean getOnboardOnStarted() {
        return this.getBoolean(onboardOnStarted);
    }

    @Generated
    public void setOnboardOnStarted(boolean v) {
        this.setBoolean(onboardOnStarted, v, null);
    }

    @Generated
    public String getAutoOnboardComment() {
        return this.getString(autoOnboardComment);
    }

    @Generated
    public void setAutoOnboardComment(String v) {
        this.setString(autoOnboardComment, v, null);
    }

    @Generated
    public void onboard(BString parameter) {
        this.invoke(onboard, (BValue)parameter, null);
    }

    @Generated
    public void renew() {
        this.invoke(renew, null, null);
    }

    @Generated
    public void autoOnboard(BFormat parameter) {
        this.invoke(autoOnboard, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.checkRequesterType();
        this.getCertToSignAndApply().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        BCombinedSignedCertConfig.updateCertAliasIfDefault(this.getCertToSignAndApply());
    }

    public void descendantsStarted() throws Exception {
        BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
        if (this.getOnboardOnStarted()) {
            this.setOnboardOnStarted(false);
            String comment = this.getAutoOnboardComment();
            if (comment.isEmpty() || comment.equals(DEFAULT_COMMENT)) {
                comment = LEX.getText("signedCertConfig.auto.onboard.message", new Object[]{this.toDisplayPathString(null), Sys.getStation().getStationName(), BAbsTime.now()});
            }
            this.onboard(BString.make((String)comment));
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning()) {
            if (signingRequester.equals(property)) {
                BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
                return;
            }
            if (certToSignAndApply.equals(property) && !SKIP_UPDATE_CX.equals(cx)) {
                BCombinedSignedCertConfig.updateCertAliasIfDefault(this.getCertToSignAndApply());
                return;
            }
        }
        if (this.shouldCheckRequesterType(property, cx)) {
            this.checkRequesterType();
        }
        super.changed(property, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISecurityService;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 9901 || x == 9900 && (BAbstractSigningRequester.onboard.equals(b) || BAbstractSigningRequester.renew.equals(b))) {
            BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BISecurityService.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BCombinedSignedCertConfig.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("baja", "DuplicateRestrictedComponentInParent", new Object[]{parent.getType(), this.getType()});
        }
        BCombinedSignedCertConfig.checkForUnauthorizedPreconfiguredSettings(this, applyToFoxService, BFoxService.TYPE, cx);
        BCombinedSignedCertConfig.checkForUnauthorizedPreconfiguredSettings(this, applyToWebService, BWebService.TYPE, cx);
        BCombinedSignedCertConfig.checkForUnauthorizedPreconfiguredSettings(this, applyToPlatform, BCertManagerService.TYPE, cx);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context cx) {
        Optional<Boolean> permissionToPlat;
        Optional<Boolean> permissionToWeb;
        Optional<Boolean> permissionToFox;
        List<Property> modifiedProps = Arrays.asList(validatable.getModifiedProperties());
        if (modifiedProps.contains(applyToFoxService) && ((BBoolean)validatable.getProposedValue(applyToFoxService).as(BBoolean.class)).getBoolean() && (!(permissionToFox = BCombinedSignedCertConfig.hasAdminWritePermissionToService(BFoxService.TYPE, cx)).isPresent() || !permissionToFox.get().booleanValue())) {
            throw new LocalizableRuntimeException("signingService", "combinedSignedCertConfig.unauthorizedApplyToService", new Object[]{this.getDisplayName((Slot)applyToFoxService, cx)});
        }
        if (modifiedProps.contains(applyToWebService) && ((BBoolean)validatable.getProposedValue(applyToWebService).as(BBoolean.class)).getBoolean() && (!(permissionToWeb = BCombinedSignedCertConfig.hasAdminWritePermissionToService(BWebService.TYPE, cx)).isPresent() || !permissionToWeb.get().booleanValue())) {
            throw new LocalizableRuntimeException("signingService", "combinedSignedCertConfig.unauthorizedApplyToService", new Object[]{this.getDisplayName((Slot)applyToWebService, cx)});
        }
        if (modifiedProps.contains(applyToPlatform) && ((BBoolean)validatable.getProposedValue(applyToPlatform).as(BBoolean.class)).getBoolean() && (!(permissionToPlat = BCombinedSignedCertConfig.hasAdminWritePermissionToService(BCertManagerService.TYPE, cx)).isPresent() || !permissionToPlat.get().booleanValue())) {
            throw new LocalizableRuntimeException("signingService", "combinedSignedCertConfig.unauthorizedApplyToService", new Object[]{this.getDisplayName((Slot)applyToPlatform, cx)});
        }
    }

    public String getCertAlias() {
        String alias = this.getCertToSignAndApply().getAlias();
        if (SigningServiceUtils.DEFAULT_REQUESTER_CERT_ALIAS.equals(alias)) {
            return "default";
        }
        return alias;
    }

    public BCertificateAliasAndPassword getCertificateAliasAndPassword() {
        BCertificateAliasAndPassword certAliasAndPassword = this.getCertToSignAndApply();
        if (!SigningServiceUtils.isDefaultOrEmptyAlias(certAliasAndPassword.getAlias())) {
            return certAliasAndPassword;
        }
        throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
    }

    public BPassword supplyCertificatePassword() {
        BCertificateAliasAndPassword certAliasAndPassword;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        if (!SigningServiceUtils.isDefaultOrEmptyAlias((certAliasAndPassword = this.getCertToSignAndApply()).getAlias())) {
            return BPassword.make((String)AccessController.doPrivileged(() -> certAliasAndPassword.getPassword().getValue()));
        }
        throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
    }

    public boolean requiresCertificateParameterTemplates() {
        return true;
    }

    public BCertificateParameter[] getCertificateParameters() {
        return (BCertificateParameter[])this.getChildren(BCertificateParameter.class);
    }

    public void certificateSigned(X509Certificate[] certificateChain) {
        BCertificateAliasAndPassword signedCertAliasAndPassword = this.getCertToSignAndApply();
        String alias = signedCertAliasAndPassword.getAlias();
        if (SigningServiceUtils.isDefaultOrEmptyAlias(alias)) {
            throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        BPassword password = !signedCertAliasAndPassword.isPasswordSet() ? BPassword.DEFAULT : BPassword.make((String)AccessController.doPrivileged(() -> signedCertAliasAndPassword.getPassword().getValue()));
        BCertificateAliasAndPassword newAliasAndPassword = new BCertificateAliasAndPassword(alias, password);
        StringJoiner results = new StringJoiner(" \n\n- ", LEX.getText("combinedSignedCertConfig.result.header", new Object[]{BAbsTime.now().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE))}) + " \n\n- ", "");
        this.applySignedCertificateToService(applyToFoxService, BFoxService.TYPE, newAliasAndPassword, certificateChain, results);
        this.applySignedCertificateToService(applyToWebService, BWebService.TYPE, newAliasAndPassword, certificateChain, results);
        this.applySignedCertificateToPlatform(newAliasAndPassword, results);
        this.setLastSignedCertApplicationResults(results.toString());
    }

    public boolean allowExistingCertReplacement() {
        return true;
    }

    @Override
    public Property getRequesterTypeProperty() {
        return signingRequesterType;
    }

    @Override
    public Property getRequesterProperty() {
        return signingRequester;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(onboard)) {
            return this.getSigningRequester().getActionParameterDefault(BAbstractSigningRequester.onboard);
        }
        if (action.equals(renew)) {
            return this.getSigningRequester().getActionParameterDefault(BAbstractSigningRequester.renew);
        }
        return super.getActionParameterDefault(action);
    }

    public void doOnboard(BString comment, Context cx) {
        this.getSigningRequester().invoke(BAbstractSigningRequester.onboard, (BValue)comment, cx);
    }

    public void doRenew(Context cx) {
        this.getSigningRequester().invoke(BAbstractSigningRequester.renew, null, cx);
    }

    public void doAutoOnboard(BFormat autoCertAliasFormat, Context cx) {
        String comment;
        if (!this.isRunning()) {
            return;
        }
        if (autoCertAliasFormat != null && !autoCertAliasFormat.equals((Object)BFormat.DEFAULT)) {
            if (BFormat.evaluatingFormatContainsErrors((BFormat)autoCertAliasFormat, (Object)this, (Context)cx)) {
                throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.auto.alias.format");
            }
            this.getCertToSignAndApply().set(BCertificateAliasAndPassword.alias, (BValue)BString.make((String)autoCertAliasFormat.format((Object)this, cx)), cx);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.toDisplayPathString(null) + " performing auto onboard");
        }
        if ((comment = this.getAutoOnboardComment()).isEmpty() || comment.equals(DEFAULT_COMMENT)) {
            comment = LEX.getText("signedCertConfig.auto.onboard.message", new Object[]{this.toDisplayPathString(null), Sys.getStation().getStationName(), BAbsTime.now()});
        }
        this.getSigningRequester().invoke(BAbstractSigningRequester.onboard, (BValue)BString.make((String)comment), cx);
    }

    private static BCertificateAliasAndPassword getCertificateAliasAndPasswordFromContainer(BICertificateAliasAndPasswordContainer container) {
        return (BCertificateAliasAndPassword)((BComponent)container.as(BComponent.class)).get(container.getCertificateAliasAndPasswordProperty(null));
    }

    private static Optional<Boolean> hasAdminWritePermissionToService(Type serviceType, Context cx) {
        Optional serviceOptional = Sys.findService((Type)serviceType);
        return serviceOptional.map(biService -> ((BComponent)biService.as(BComponent.class)).getPermissions(cx).hasAdminWrite());
    }

    private static void checkForExistingIndividualSignedCertConfig(BICertificateAliasAndPasswordContainer container) {
        if (((BIndividualSignedCertConfig[])((BComponent)container.as(BComponent.class)).getChildren(BIndividualSignedCertConfig.class)).length > 0) {
            throw new LocalizableRuntimeException("signingService", "combinedSignedCertConfig.result.serviceSelfManagesCert", new Object[]{container.getType().getDisplayName(null)});
        }
    }

    private static void checkForUnauthorizedPreconfiguredSettings(BCombinedSignedCertConfig signedCertConfig, Property applyProperty, Type serviceType, Context cx) {
        if (((BBoolean)signedCertConfig.get(applyProperty).as(BBoolean.class)).getBoolean()) {
            Optional<Boolean> permissionToService = BCombinedSignedCertConfig.hasAdminWritePermissionToService(serviceType, cx);
            if (permissionToService.isPresent()) {
                if (!permissionToService.get().booleanValue()) {
                    throw new LocalizableRuntimeException("signingService", "combinedSignedCertConfig.illegalAddWithUnauthorizedSettings");
                }
            } else {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "No " + serviceType.getDisplayName(null) + " detected in station. Reverting applicable properties to default values on " + TYPE + " instance being mounted in station.");
                }
                signedCertConfig.set(applyProperty, (BValue)BBoolean.FALSE);
            }
        }
    }

    private void applySignedCertificateToService(Property applyProperty, Type serviceType, BCertificateAliasAndPassword newAliasAndPassword, X509Certificate[] certificateChain, StringJoiner results) {
        block6: {
            if (((BBoolean)this.get(applyProperty).as(BBoolean.class)).getBoolean()) {
                try {
                    BICertificateAliasAndPasswordContainer container = (BICertificateAliasAndPasswordContainer)Sys.getService((Type)serviceType);
                    BCombinedSignedCertConfig.checkForExistingIndividualSignedCertConfig(container);
                    BCertificateAliasAndPassword certAliasAndPassword = BCombinedSignedCertConfig.getCertificateAliasAndPasswordFromContainer(container);
                    certAliasAndPassword.copyFrom((BComplex)newAliasAndPassword);
                    container.certificateSigned(container.getCertificateAliasAndPasswordProperty(null), certificateChain, null);
                    results.add(LEX.getText("combinedSignedCertConfig.result.successfullyApplied", new Object[]{newAliasAndPassword.getAlias(), serviceType.getDisplayName(null)}));
                }
                catch (Throwable e) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, this.toDisplayPathString(null) + " - Failed to apply signed cert for " + serviceType.getDisplayName(null), LOG.isLoggable(Level.FINE) ? e : null);
                    }
                    if (e instanceof Localizable) {
                        results.add(LEX.getText("combinedSignedCertConfig.result.failedToApply", new Object[]{newAliasAndPassword.getAlias(), serviceType.getDisplayName(null), ((Localizable)e).toString(null)}));
                        break block6;
                    }
                    results.add(LEX.getText("combinedSignedCertConfig.result.failedToApply", new Object[]{newAliasAndPassword.getAlias(), serviceType.getDisplayName(null), ""}));
                }
            } else {
                results.add(LEX.getText("combinedSignedCertConfig.result.applicationDisabled", new Object[]{newAliasAndPassword.getAlias(), serviceType.getDisplayName(null), this.getDisplayName((Slot)applyProperty, null)}));
            }
        }
    }

    private void applySignedCertificateToPlatform(BCertificateAliasAndPassword newAliasAndPassword, StringJoiner results) {
        block7: {
            if (this.getApplyToPlatform()) {
                try {
                    BCertificateAliasAndPassword finalAliasAndPassword = newAliasAndPassword;
                    boolean applied = AccessController.doPrivileged(() -> {
                        BDaemonSession daemon = LocalSessionUtil.getLocalSession();
                        BRemoteDaemonPlatform remoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)daemon, (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
                        BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
                        current.setKeyAlias(finalAliasAndPassword.getAlias());
                        current.setKeyPassphrase(finalAliasAndPassword.getPassword());
                        UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, false, daemon.generateSharedSecretKey("updateCertAliasAndPassword"));
                        return daemon.sendMessage((DaemonMessage)message);
                    });
                    if (applied) {
                        results.add(LEX.getText("combinedSignedCertConfig.result.successfullyApplied", new Object[]{newAliasAndPassword.getAlias(), PLATFORM_LEX_TEXT}));
                        break block7;
                    }
                    results.add(LEX.getText("combinedSignedCertConfig.result.failedToApply", new Object[]{newAliasAndPassword.getAlias(), PLATFORM_LEX_TEXT, ""}));
                }
                catch (Throwable e) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, this.toDisplayPathString(null) + " - Failed to apply signed cert for Platform", LOG.isLoggable(Level.FINE) ? e : null);
                    }
                    if (e instanceof Localizable) {
                        results.add(LEX.getText("combinedSignedCertConfig.result.failedToApply", new Object[]{newAliasAndPassword.getAlias(), PLATFORM_LEX_TEXT, ((Localizable)e).toString(null)}));
                        break block7;
                    }
                    results.add(LEX.getText("combinedSignedCertConfig.result.failedToApply", new Object[]{newAliasAndPassword.getAlias(), PLATFORM_LEX_TEXT, ""}));
                }
            } else {
                results.add(LEX.getText("combinedSignedCertConfig.result.applicationDisabled", new Object[]{newAliasAndPassword.getAlias(), PLATFORM_LEX_TEXT, this.getDisplayName((Slot)applyToPlatform, null)}));
            }
        }
    }

    static void updateOnboardAndRenewFlagsAndFacets(BComponent parentSignedCertConfig, Action parentOnboardAction, Action parentRenewAction, BAbstractSigningRequester childRequester) {
        if (!parentSignedCertConfig.isRunning()) {
            return;
        }
        Action childOnboardAction = childRequester.getAction("onboard");
        Action childRenewAction = childRequester.getAction("renew");
        parentSignedCertConfig.setFlags((Slot)parentOnboardAction, childRequester.getFlags((Slot)childOnboardAction) & 0xFFFFFFEF | 0x800);
        parentSignedCertConfig.setFlags((Slot)parentRenewAction, childRequester.getFlags((Slot)childRenewAction) & 0xFFFFFFEF | 0x800);
        parentSignedCertConfig.setFacets((Slot)parentOnboardAction, childRequester.getSlotFacets((Slot)childOnboardAction), null);
        parentSignedCertConfig.setFacets((Slot)parentRenewAction, childRequester.getSlotFacets((Slot)childRenewAction), null);
    }

    static void updateCertAliasIfDefault(BCertificateAliasAndPassword certAliasAndPassword) {
        if (SigningServiceUtils.isDefaultOrEmptyAlias(certAliasAndPassword.getAlias())) {
            certAliasAndPassword.set(BCertificateAliasAndPassword.alias, (BValue)DEFAULT_REQUESTER_CERT_ALIAS_VALUE, SKIP_UPDATE_CX);
        }
    }
}

