/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.signing.BCombinedSignedCertConfig;
import com.tridium.signing.ISwitchableSigningRequester;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.fox.BFoxSigningRequester;
import com.tridium.sys.schema.NProperty;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="parentPropertyToApplySignedCert", type="BDynamicEnum", defaultValue="BDynamicEnum.make(BEnumRange.make(new String[] { \"$20\" }))", flags=1), @NiagaraProperty(name="certToSignAndApply", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="signingRequesterType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"signingService:FoxSigningRequester\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"platCrypto:AbstractSigningRequester\")"), @Facet(name="BFacets.ALLOW_NULL", value="false"), @Facet(value="BFacets.make(\"showAbstract\", false)"), @Facet(value="BFacets.make(\"showInterface\", false)")}), @NiagaraProperty(name="signingRequester", type="BAbstractSigningRequester", defaultValue="new BFoxSigningRequester()"), @NiagaraProperty(name="onboardOnStarted", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="autoOnboardComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="onboard", parameterType="BString", defaultValue="BString.make(\"\")", flags=2048), @NiagaraAction(name="renew", flags=2048), @NiagaraAction(name="autoOnboard", parameterType="BFormat", defaultValue="BFormat.DEFAULT", flags=4)})
public final class BIndividualSignedCertConfig
extends BComponent
implements IRequesterComponent,
BIRestrictedComponent,
IPropertyValidator,
ISwitchableSigningRequester {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property parentPropertyToApplySignedCert = BIndividualSignedCertConfig.newProperty((int)1, (BValue)BDynamicEnum.make((BEnumRange)BEnumRange.make((String[])new String[]{"$20"})), null);
    @Generated
    public static final Property certToSignAndApply = BIndividualSignedCertConfig.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property signingRequesterType = BIndividualSignedCertConfig.newProperty((int)0, (BValue)BTypeSpec.make((String)"signingService:FoxSigningRequester"), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"platCrypto:AbstractSigningRequester")), (BFacets)BFacets.make((String)"allowNull", (boolean)false)), (BFacets)BFacets.make((String)"showAbstract", (boolean)false)), (BFacets)BFacets.make((String)"showInterface", (boolean)false)));
    @Generated
    public static final Property signingRequester = BIndividualSignedCertConfig.newProperty((int)0, (BValue)new BFoxSigningRequester(), null);
    @Generated
    public static final Property onboardOnStarted = BIndividualSignedCertConfig.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property autoOnboardComment = BIndividualSignedCertConfig.newProperty((int)4, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Action onboard = BIndividualSignedCertConfig.newAction((int)2048, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action renew = BIndividualSignedCertConfig.newAction((int)2048, null);
    @Generated
    public static final Action autoOnboard = BIndividualSignedCertConfig.newAction((int)4, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIndividualSignedCertConfig.class);
    private static final BIcon ICON = BIcon.std((String)"shield.png");
    public static final BFormat USE_RECOMMENDED_AUTO_ALIAS = BFormat.make((String)"<Use Recommended Auto Alias>");
    private static final Logger LOG = Logger.getLogger("signingService.requester");
    private static final Lexicon LEX = Lexicon.make(BIndividualSignedCertConfig.class);

    @Generated
    public BDynamicEnum getParentPropertyToApplySignedCert() {
        return (BDynamicEnum)this.get(parentPropertyToApplySignedCert);
    }

    @Generated
    public void setParentPropertyToApplySignedCert(BDynamicEnum v) {
        this.set(parentPropertyToApplySignedCert, (BValue)v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertToSignAndApply() {
        return (BCertificateAliasAndPassword)this.get(certToSignAndApply);
    }

    @Generated
    public void setCertToSignAndApply(BCertificateAliasAndPassword v) {
        this.set(certToSignAndApply, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getSigningRequesterType() {
        return (BTypeSpec)this.get(signingRequesterType);
    }

    @Generated
    public void setSigningRequesterType(BTypeSpec v) {
        this.set(signingRequesterType, (BValue)v, null);
    }

    @Generated
    public BAbstractSigningRequester getSigningRequester() {
        return (BAbstractSigningRequester)this.get(signingRequester);
    }

    @Generated
    public void setSigningRequester(BAbstractSigningRequester v) {
        this.set(signingRequester, (BValue)v, null);
    }

    @Generated
    public boolean getOnboardOnStarted() {
        return this.getBoolean(onboardOnStarted);
    }

    @Generated
    public void setOnboardOnStarted(boolean v) {
        this.setBoolean(onboardOnStarted, v, null);
    }

    @Generated
    public String getAutoOnboardComment() {
        return this.getString(autoOnboardComment);
    }

    @Generated
    public void setAutoOnboardComment(String v) {
        this.setString(autoOnboardComment, v, null);
    }

    @Generated
    public void onboard(BString parameter) {
        this.invoke(onboard, (BValue)parameter, null);
    }

    @Generated
    public void renew() {
        this.invoke(renew, null, null);
    }

    @Generated
    public void autoOnboard(BFormat parameter) {
        this.invoke(autoOnboard, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        NProperty prop = (NProperty)this.getContainer().getCertificateAliasAndPasswordProperty(null);
        int ordinal = prop.index;
        BEnumRange range = BEnumRange.make((int[])new int[]{ordinal}, (String[])new String[]{SlotPath.escape((String)this.getParent().getDisplayName((Slot)prop, null))});
        this.setParentPropertyToApplySignedCert(BDynamicEnum.make((int)ordinal, (BEnumRange)range));
        this.updatePurposeIdFacets();
        this.checkRequesterType();
        if (!Flags.has((BComplex)this, (Slot)certToSignAndApply, (int)0x10000000)) {
            String recommendedAlias;
            Flags.add((BComponent)this, (Slot)certToSignAndApply, null, (int[])new int[]{0x10000000});
            if (SigningServiceUtils.isDefaultOrEmptyAlias(this.getCertToSignAndApply().getAlias()) && (recommendedAlias = this.getContainer().getRecommendedCertificateAlias(null)) != null) {
                this.getCertToSignAndApply().setAlias(recommendedAlias);
            }
        }
        BCombinedSignedCertConfig.updateCertAliasIfDefault(this.getCertToSignAndApply());
    }

    public void descendantsStarted() throws Exception {
        BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
        if (this.getOnboardOnStarted()) {
            this.setOnboardOnStarted(false);
            String comment = this.getAutoOnboardComment();
            if (comment.isEmpty() || comment.equals(DEFAULT_COMMENT)) {
                BComponent parent = this.getParent().asComponent();
                comment = LEX.getText("signedCertConfig.auto.onboard.message", new Object[]{parent.toDisplayPathString(null) + '/' + parent.getDisplayName((Slot)this.getContainer().getCertificateAliasAndPasswordProperty(null), null), Sys.getStation().getStationName(), BAbsTime.now()});
            }
            this.onboard(BString.make((String)comment));
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning()) {
            if (signingRequester.equals(property)) {
                BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
                return;
            }
            if (certToSignAndApply.equals(property) && !BCombinedSignedCertConfig.SKIP_UPDATE_CX.equals(cx)) {
                BCombinedSignedCertConfig.updateCertAliasIfDefault(this.getCertToSignAndApply());
                return;
            }
        }
        if (this.shouldCheckRequesterType(property, cx)) {
            this.checkRequesterType();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BICertificateAliasAndPasswordContainer;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 9901 || x == 9900 && (BAbstractSigningRequester.onboard.equals(b) || BAbstractSigningRequester.renew.equals(b))) {
            BCombinedSignedCertConfig.updateOnboardAndRenewFlagsAndFacets(this, onboard, renew, this.getSigningRequester());
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BICertificateAliasAndPasswordContainer.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BIndividualSignedCertConfig.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("baja", "DuplicateRestrictedComponentInParent", new Object[]{parent.getType(), this.getType()});
        }
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        if (Arrays.asList(validatable.getModifiedProperties()).contains(parentPropertyToApplySignedCert)) {
            BIndividualSignedCertConfig.doValidateReadonlyPropertySet(context);
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (parentPropertyToApplySignedCert.equals(property)) {
            BIndividualSignedCertConfig.doValidateReadonlyPropertySet(context);
        }
    }

    private static void doValidateReadonlyPropertySet(Context context) {
        if (context != null && context.getUser() != null) {
            throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualPropertyChange");
        }
    }

    public String getCertAlias() {
        String alias = this.getCertToSignAndApply().getAlias();
        if (SigningServiceUtils.DEFAULT_REQUESTER_CERT_ALIAS.equals(alias)) {
            return "default";
        }
        return alias;
    }

    public BCertificateAliasAndPassword getCertificateAliasAndPassword() {
        BCertificateAliasAndPassword certAliasAndPassword = this.getCertToSignAndApply();
        if (!SigningServiceUtils.isDefaultOrEmptyAlias(certAliasAndPassword.getAlias())) {
            return certAliasAndPassword;
        }
        throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
    }

    public BPassword supplyCertificatePassword() {
        BCertificateAliasAndPassword certAliasAndPassword;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        if (!SigningServiceUtils.isDefaultOrEmptyAlias((certAliasAndPassword = this.getCertToSignAndApply()).getAlias())) {
            return BPassword.make((String)AccessController.doPrivileged(() -> certAliasAndPassword.getPassword().getValue()));
        }
        throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
    }

    public boolean requiresCertificateParameterTemplates() {
        return true;
    }

    public BCertificateParameter[] getCertificateParameters() {
        return (BCertificateParameter[])this.getChildren(BCertificateParameter.class);
    }

    public void certificateSigned(X509Certificate[] certificateChain) {
        BCertificateAliasAndPassword signedCertAliasAndPassword = this.getCertToSignAndApply();
        String alias = signedCertAliasAndPassword.getAlias();
        if (SigningServiceUtils.isDefaultOrEmptyAlias(alias)) {
            throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.alias");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        BPassword password = !signedCertAliasAndPassword.isPasswordSet() ? BPassword.DEFAULT : BPassword.make((String)AccessController.doPrivileged(() -> signedCertAliasAndPassword.getPassword().getValue()));
        BICertificateAliasAndPasswordContainer container = this.getContainer();
        BCertificateAliasAndPassword certAliasAndPassword = this.getCertificateAliasAndPasswordFromContainer();
        certAliasAndPassword.copyFrom((BComplex)new BCertificateAliasAndPassword(alias, password));
        container.certificateSigned(container.getCertificateAliasAndPasswordProperty(null), certificateChain, null);
    }

    public boolean allowExistingCertReplacement() {
        return true;
    }

    @Override
    public Property getRequesterTypeProperty() {
        return signingRequesterType;
    }

    @Override
    public Property getRequesterProperty() {
        return signingRequester;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(onboard)) {
            return this.getSigningRequester().getActionParameterDefault(BAbstractSigningRequester.onboard);
        }
        if (action.equals(renew)) {
            return this.getSigningRequester().getActionParameterDefault(BAbstractSigningRequester.renew);
        }
        return super.getActionParameterDefault(action);
    }

    public void doOnboard(BString comment, Context cx) {
        this.getSigningRequester().invoke(BAbstractSigningRequester.onboard, (BValue)comment, cx);
    }

    public void doRenew(Context cx) {
        this.getSigningRequester().invoke(BAbstractSigningRequester.renew, null, cx);
    }

    public void doAutoOnboard(BFormat autoCertAliasFormat, Context cx) {
        String comment;
        if (!this.isRunning()) {
            return;
        }
        if (autoCertAliasFormat != null) {
            if (USE_RECOMMENDED_AUTO_ALIAS.equals((Object)autoCertAliasFormat)) {
                String recommendedAlias = this.getContainer().getRecommendedCertificateAlias(null);
                if (recommendedAlias != null) {
                    this.getCertToSignAndApply().set(BCertificateAliasAndPassword.alias, (BValue)BString.make((String)recommendedAlias), cx);
                }
            } else if (!autoCertAliasFormat.equals((Object)BFormat.DEFAULT)) {
                if (BFormat.evaluatingFormatContainsErrors((BFormat)autoCertAliasFormat, (Object)this, (Context)cx)) {
                    throw new LocalizableRuntimeException("signingService", "signedCertConfig.invalid.auto.alias.format");
                }
                this.getCertToSignAndApply().set(BCertificateAliasAndPassword.alias, (BValue)BString.make((String)autoCertAliasFormat.format((Object)this, cx)), cx);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            BComponent parent = this.getParent().asComponent();
            LOG.fine(parent.toDisplayPathString(null) + '/' + parent.getDisplayName((Slot)this.getContainer().getCertificateAliasAndPasswordProperty(null), null) + " performing auto onboard");
        }
        if ((comment = this.getAutoOnboardComment()).isEmpty() || comment.equals(DEFAULT_COMMENT)) {
            BComponent parent = this.getParent().asComponent();
            comment = LEX.getText("signedCertConfig.auto.onboard.message", new Object[]{parent.toDisplayPathString(null) + '/' + parent.getDisplayName((Slot)this.getContainer().getCertificateAliasAndPasswordProperty(null), null), Sys.getStation().getStationName(), BAbsTime.now()});
        }
        this.getSigningRequester().invoke(BAbstractSigningRequester.onboard, (BValue)BString.make((String)comment), cx);
    }

    private BCertificateAliasAndPassword getCertificateAliasAndPasswordFromContainer() {
        return (BCertificateAliasAndPassword)this.getParent().get(this.getContainer().getCertificateAliasAndPasswordProperty(null));
    }

    private BICertificateAliasAndPasswordContainer getContainer() {
        return (BICertificateAliasAndPasswordContainer)this.getParent().as(BICertificateAliasAndPasswordContainer.class);
    }

    private void updatePurposeIdFacets() {
        BCertificateAliasAndPassword certAliasAndPasswordOnContainer = this.getCertificateAliasAndPasswordFromContainer();
        BFacets aliasFacetsOnContainer = certAliasAndPasswordOnContainer.getSlotFacets((Slot)BCertificateAliasAndPassword.alias);
        BIDataValue purposeIdVal = (BIDataValue)aliasFacetsOnContainer.getFacet("purposeId");
        BFacets aliasFacets = this.getCertToSignAndApply().getSlotFacets((Slot)BCertificateAliasAndPassword.alias);
        aliasFacets = purposeIdVal != null ? BFacets.make((BFacets)aliasFacets, (String)"purposeId", (BIDataValue)purposeIdVal) : BFacets.makeRemove((BFacets)aliasFacets, (String)"purposeId");
        this.getCertToSignAndApply().setFacets((Slot)BCertificateAliasAndPassword.alias, aliasFacets);
    }
}

