/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.fox;

import com.tridium.signing.SigningServiceException;
import com.tridium.signing.fox.BSigningChannel;
import com.tridium.signing.transport.BISigningTransport;
import com.tridium.signing.transport.BSessionToken;
import com.tridium.signing.transport.BSessionTokenStore;
import com.tridium.signing.transport.BSigningTransportFolder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="jwtMaxIatInFuture", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", flags=4, facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(1)")}), @NiagaraProperty(name="sessionTokenStore", type="BSessionTokenStore", defaultValue="new BSessionTokenStore()")})
public final class BFoxSigningTransport
extends BComponent
implements BISigningTransport,
BIRestrictedComponent {
    @Generated
    public static final Property enabled = BFoxSigningTransport.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property jwtMaxIatInFuture = BFoxSigningTransport.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeHours((int)1))));
    @Generated
    public static final Property sessionTokenStore = BFoxSigningTransport.newProperty((int)0, (BValue)new BSessionTokenStore(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxSigningTransport.class);
    private static final BIcon icon = BIcon.std((String)"fox.png");
    private static final String SIGNING_TRANSPORT_MODULE = "signingService";
    private static final Logger LOG = Logger.getLogger("signingService");

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getJwtMaxIatInFuture() {
        return (BRelTime)this.get(jwtMaxIatInFuture);
    }

    @Generated
    public void setJwtMaxIatInFuture(BRelTime v) {
        this.set(jwtMaxIatInFuture, (BValue)v, null);
    }

    @Generated
    public BSessionTokenStore getSessionTokenStore() {
        return (BSessionTokenStore)this.get(sessionTokenStore);
    }

    @Generated
    public void setSessionTokenStore(BSessionTokenStore v) {
        this.set(sessionTokenStore, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && enabled.equals(property)) {
            if (this.getEnabled()) {
                BSigningChannel.addSigningChannelUser();
            } else {
                BSigningChannel.removeSigningChannelUser();
            }
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getEnabled()) {
            BSigningChannel.addSigningChannelUser();
        }
        if (!Flags.has((BComplex)this, (Slot)jwtMaxIatInFuture, (int)0x10000000)) {
            this.setFlags((Slot)jwtMaxIatInFuture, Flags.add((int)(this.getFlags((Slot)jwtMaxIatInFuture) & 0xFFFFFFFB), (int[])new int[]{0x10000000}), null);
            if (BRelTime.makeSeconds((int)30).equals((Object)this.getJwtMaxIatInFuture())) {
                this.setJwtMaxIatInFuture(BRelTime.makeMinutes((int)5));
            }
        }
    }

    public void stopped() throws Exception {
        BSigningChannel.removeSigningChannelUser();
        super.stopped();
    }

    public BIcon getIcon() {
        return icon;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!(parent instanceof BSigningTransportFolder)) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{this.getType(), parent.getType()});
        }
        BIRestrictedComponent.checkForDuplicatesInParent((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    @Override
    public void certificateSignedForRequester(String requesterId, String profileId) {
        try {
            BSessionToken sessionToken = AccessController.doPrivileged(() -> {
                try {
                    return this.getSessionTokenStore().getSessionToken(requesterId);
                }
                catch (SigningServiceException signingServiceException) {
                    return null;
                }
            });
            if (sessionToken != null) {
                sessionToken.setTemporaryCode(BPassword.DEFAULT);
            }
        }
        catch (PrivilegedActionException e) {
            LOG.log(Level.WARNING, "Unexpected error updating session token after cert signed for " + this.toPathString(), LOG.isLoggable(Level.FINE) ? e : null);
        }
    }

    BPassword validateCode(String requesterId, BPassword temporaryCode) throws SigningServiceException {
        try {
            return AccessController.doPrivileged(() -> this.getSessionTokenStore().validateCode(requesterId, temporaryCode));
        }
        catch (PrivilegedActionException e) {
            throw (SigningServiceException)((Object)e.getException());
        }
    }

    void authorizeToken(String requesterId, BPassword token) throws SigningServiceException {
        try {
            if (!AccessController.doPrivileged(() -> this.getSessionTokenStore().validateToken(requesterId, token)).booleanValue()) {
                throw new SigningServiceException(SIGNING_TRANSPORT_MODULE, "session.token.failureForRequester", requesterId);
            }
        }
        catch (PrivilegedActionException e) {
            throw (SigningServiceException)((Object)e.getException());
        }
    }
}

