/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.profile;

import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningCertificateState;
import com.tridium.signing.profile.BSigningRecordStore;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BAbsTime;

public final class ExpiringRecordsReport {
    private static final Comparator<BCertificateSigningRecord> AUTO_REMOVAL_COMPARATOR = Comparator.comparing(BCertificateSigningRecord::getAutoRemovalTime);
    private final Queue<BCertificateSigningRecord> certsPendingExpiration = new PriorityQueue<BCertificateSigningRecord>(11, AUTO_REMOVAL_COMPARATOR);
    private final Queue<BCertificateSigningRecord> expiredCertsInGracePeriod = new PriorityQueue<BCertificateSigningRecord>(11, AUTO_REMOVAL_COMPARATOR);
    private final Queue<BCertificateSigningRecord> certsNotExpiringSoon = new PriorityQueue<BCertificateSigningRecord>(11, AUTO_REMOVAL_COMPARATOR);

    public ExpiringRecordsReport(BSigningRecordStore store) {
        for (BCertificateSigningRecord signingRecord : (BCertificateSigningRecord[])store.getChildren(BCertificateSigningRecord.class)) {
            if (signingRecord.getCertificate().equals((Object)BX509Certificate.DEFAULT) || !store.updateAndGetRecordValidity(signingRecord)) continue;
            if (signingRecord.getCertificateState().equals((Object)BSigningCertificateState.inGracePeriod)) {
                this.expiredCertsInGracePeriod.add(signingRecord);
                continue;
            }
            if (signingRecord.getCertificateState().equals((Object)BSigningCertificateState.active) && BAbsTime.now().getMillis() >= signingRecord.getCertificateValidityRange().getEndTime().subtract(store.getProximityToCertificateExpirationForAlerts()).getMillis()) {
                this.certsPendingExpiration.add(signingRecord);
                continue;
            }
            this.certsNotExpiringSoon.add(signingRecord);
        }
    }

    public boolean noRecords() {
        return this.certsPendingExpiration.isEmpty() && this.certsNotExpiringSoon.isEmpty() && this.expiredCertsInGracePeriod.isEmpty();
    }

    public Queue<BCertificateSigningRecord> getCertsPendingExpiration() {
        return this.certsPendingExpiration;
    }

    public Queue<BCertificateSigningRecord> getExpiredCertsInGracePeriod() {
        return this.expiredCertsInGracePeriod;
    }

    public Queue<BCertificateSigningRecord> getCertsNotExpiringSoon() {
        return this.certsNotExpiringSoon;
    }
}

