/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.sec;

import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.signing.SigningServiceUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"platCrypto:AbstractSigningRequester"})})
public class BSigningRequesterSecurityDashboardAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningRequesterSecurityDashboardAgent.class);
    private BAbstractSigningRequester requester;
    private SecurityDashboardItemBuilder builder;
    public static final String SECTION_HEADER = "securityDashboard.requester.sectionHeader";
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    public static final String ONBOARD_FAILED_SUMMARY = "securityDashboard.requester.onboard.summary";
    public static final String ONBOARD_FAILED_DESC = "securityDashboard.requester.onboard.desc";
    public static final String RENEW_FAILED_SUMMARY = "securityDashboard.requester.renew.summary";
    public static final String RENEW_FAILED_DESC = "securityDashboard.requester.renew.desc";
    public static final String CERT_MISSING_SUMMARY = "securityDashboard.requester.cert.missing.summary";
    public static final String CERT_MISSING_DESC = "securityDashboard.requester.cert.missing.desc";
    public static final String CERT_EXP_SOON_SUMMARY = "securityDashboard.requester.cert.expiring.summary";
    public static final String CERT_EXP_SOON_DESCRIPTION = "securityDashboard.requester.cert.expiring.desc";
    public static final String CERT_EXP_SUMMARY = "securityDashboard.requester.cert.exp.summary";
    public static final String CERT_EXP_DESCRIPTION = "securityDashboard.requester.cert.exp.desc";
    public static final String OK_SUMMARY = "securityDashboard.requester.ok.summary";
    public static final String OK_DESC = "securityDashboard.requester.ok.desc";
    public static final String INFO_SUMMARY = "securityDashboard.requester.info.summary";
    public static final String INFO_DESC = "securityDashboard.requester.info.desc";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.requester = (BAbstractSigningRequester)object.as(BAbstractSigningRequester.class);
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        String headerValue;
        if (this.requester == null) {
            headerValue = SigningServiceUtils.UNKNOWN;
        } else {
            BComplex requesterComponent = (BComplex)this.requester.getRequesterComponent();
            StringBuilder headerBuilder = new StringBuilder();
            if (requesterComponent.getParent() != null) {
                headerBuilder.append(requesterComponent.getParent().getDisplayName(cx)).append('/');
            }
            headerBuilder.append(requesterComponent.getDisplayName(cx));
            headerValue = headerBuilder.toString();
        }
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER, (String)headerValue);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.requester.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.requester != null) {
            boolean certOk;
            BRequesterState state = this.requester.getRequesterState();
            String alias = this.requester.getRequesterComponent().getCertAlias();
            boolean bl = certOk = state.onboardedAtLeastOnce() && this.checkCertificate(alias, items);
            if (!state.onboardedAtLeastOnce()) {
                if (this.requester.getFaultCause().isEmpty()) {
                    this.addItem(items, BSecurityItemStatus.securityStatusInfo, INFO_SUMMARY, INFO_DESC, new Object[0]);
                } else {
                    this.addItem(items, BSecurityItemStatus.securityStatusWarning, ONBOARD_FAILED_SUMMARY, ONBOARD_FAILED_DESC, this.requester.getFaultCause());
                }
            } else if (state == BRequesterState.renewalFailed) {
                this.addItem(items, BSecurityItemStatus.securityStatusAlert, RENEW_FAILED_SUMMARY, RENEW_FAILED_DESC, this.requester.getFaultCause());
            } else if ((state == BRequesterState.onboarded || state == BRequesterState.renewalCsrSubmitted) && certOk) {
                this.addItem(items, BSecurityItemStatus.securityStatusOK, OK_SUMMARY, OK_DESC, this.requester.getNextRenewalAttempt());
            }
        }
        return Collections.unmodifiableList(items);
    }

    private boolean checkCertificate(String certAlias, List<SecurityDashboardItem> items) {
        int itemsBefore = items.size();
        if (certAlias.isEmpty()) {
            this.addItem(items, BSecurityItemStatus.securityStatusAlert, CERT_MISSING_SUMMARY, CERT_MISSING_DESC, "");
        } else {
            try {
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                X509Certificate cert = cryptoManager.getKeyStore().getCertificate(certAlias);
                if (cert == null) {
                    this.addItem(items, BSecurityItemStatus.securityStatusAlert, CERT_MISSING_SUMMARY, CERT_MISSING_DESC, certAlias);
                } else {
                    this.checkCertValidity(certAlias, cert, items);
                }
            }
            catch (Exception e) {
                SigningServiceUtils.LOG.log(Level.WARNING, "Security Dashboard failed to check cert for requester", e);
            }
        }
        return itemsBefore == items.size();
    }

    private void checkCertValidity(String certAlias, X509Certificate cert, List<SecurityDashboardItem> items) {
        long advanceRenewalPeriod = this.requester.getAdvanceRenewal().getMillis();
        long certExpiry = cert.getNotAfter().getTime();
        long millisRemaining = certExpiry - BAbsTime.now().getMillis();
        if (millisRemaining < 0L) {
            this.addItem(items, BSecurityItemStatus.securityStatusAlert, CERT_EXP_SUMMARY, CERT_EXP_DESCRIPTION, certAlias);
        } else if (advanceRenewalPeriod > 0L && millisRemaining < advanceRenewalPeriod) {
            int daysRemaining = BRelTime.make((long)millisRemaining).getDays();
            items.add(this.builder.makeWarning().withSummary(CERT_EXP_SOON_SUMMARY, new Object[]{certAlias, daysRemaining}).withDescription(CERT_EXP_SOON_DESCRIPTION, new Object[]{certAlias}));
        }
    }

    private void addItem(List<SecurityDashboardItem> items, BSecurityItemStatus status, String summaryKey, String descriptionKey, Object ... descriptionParams) {
        items.add(this.builder.make(status).withSummary(summaryKey, new Object[0]).withDescription(descriptionKey, descriptionParams));
    }
}

