/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.transport;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.transport.BSessionTokenStore;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="temporaryCode", type="BPassword", defaultValue="BPassword.DEFAULT", flags=1), @NiagaraProperty(name="temporaryCodeExpiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="token", type="BPassword", defaultValue="BPassword.DEFAULT", flags=1), @NiagaraProperty(name="tokenExpiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="state", type="BApprovalState", defaultValue="BApprovalState.unapproved", flags=1), @NiagaraProperty(name="profile", type="String", defaultValue="", flags=1), @NiagaraProperty(name="metadata", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="publicCert", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="approve", parameterType="BValue", defaultValue="BString.DEFAULT", flags=128, facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="\"signingService:ProfilePickerFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"signingService:ProfilePicker\"")}), @NiagaraAction(name="reject", flags=128, facets={@Facet(name="BFacets.SECURITY", value="true")})})
public final class BSessionToken
extends BComponent
implements BIDeferOwnership,
IPropertyValidator {
    @Generated
    public static final Property temporaryCode = BSessionToken.newProperty((int)1, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property temporaryCodeExpiration = BSessionToken.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property token = BSessionToken.newProperty((int)1, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property tokenExpiration = BSessionToken.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property state = BSessionToken.newProperty((int)1, (BValue)BApprovalState.unapproved, null);
    @Generated
    public static final Property profile = BSessionToken.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property metadata = BSessionToken.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property publicCert = BSessionToken.newProperty((int)1, (BValue)BX509Certificate.DEFAULT, null);
    @Generated
    public static final Action approve = BSessionToken.newAction((int)128, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"signingService:ProfilePickerFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"signingService:ProfilePicker")));
    @Generated
    public static final Action reject = BSessionToken.newAction((int)128, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Type TYPE = Sys.loadType(BSessionToken.class);
    private static final BIcon UNAPPROVED_ICON = BIcon.std((String)"shapes/circleGray.png");
    private static final BIcon APPROVED_ICON = BIcon.make((BIcon)UNAPPROVED_ICON, (BIcon)BIcon.std((String)"badges/certificateGreen.png"));
    private static final BIcon REJECTED_ICON = BIcon.make((BIcon)UNAPPROVED_ICON, (BIcon)BIcon.std((String)"badges/certificateRed.png"));
    private static final BIcon EXPIRED_ICON = BIcon.make((BIcon)UNAPPROVED_ICON, (BIcon)BIcon.std((String)"badges/certificateYellow.png"));
    private static final int SECRET_SIZE = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String SUMMARY = "signing.token.summary.text";
    private static final String COMMENT_SUMMARY = "signing.token.summary.comment.text";

    @Generated
    public BPassword getTemporaryCode() {
        return (BPassword)this.get(temporaryCode);
    }

    @Generated
    public void setTemporaryCode(BPassword v) {
        this.set(temporaryCode, (BValue)v, null);
    }

    @Generated
    public BAbsTime getTemporaryCodeExpiration() {
        return (BAbsTime)this.get(temporaryCodeExpiration);
    }

    @Generated
    public void setTemporaryCodeExpiration(BAbsTime v) {
        this.set(temporaryCodeExpiration, (BValue)v, null);
    }

    @Generated
    public BPassword getToken() {
        return (BPassword)this.get(token);
    }

    @Generated
    public void setToken(BPassword v) {
        this.set(token, (BValue)v, null);
    }

    @Generated
    public BAbsTime getTokenExpiration() {
        return (BAbsTime)this.get(tokenExpiration);
    }

    @Generated
    public void setTokenExpiration(BAbsTime v) {
        this.set(tokenExpiration, (BValue)v, null);
    }

    @Generated
    public BApprovalState getState() {
        return (BApprovalState)this.get(state);
    }

    @Generated
    public void setState(BApprovalState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public String getProfile() {
        return this.getString(profile);
    }

    @Generated
    public void setProfile(String v) {
        this.setString(profile, v, null);
    }

    @Generated
    public String getMetadata() {
        return this.getString(metadata);
    }

    @Generated
    public void setMetadata(String v) {
        this.setString(metadata, v, null);
    }

    @Generated
    public BX509Certificate getPublicCert() {
        return (BX509Certificate)this.get(publicCert);
    }

    @Generated
    public void setPublicCert(BX509Certificate v) {
        this.set(publicCert, (BValue)v, null);
    }

    @Generated
    public void approve(BValue parameter) {
        this.invoke(approve, parameter, null);
    }

    @Generated
    public void reject() {
        this.invoke(reject, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BSessionToken makeUnapprovedSessionToken(BRelTime tempCodeExpirationPeriod, Map<String, String> metadata) {
        BSessionToken sessionToken = new BSessionToken();
        BPassword temporaryCode = BSessionToken.createRandomSecret();
        sessionToken.setTemporaryCode(temporaryCode);
        sessionToken.setState(BApprovalState.unapproved);
        sessionToken.setMetadata(SigningServiceUtils.convertMetadataToString(metadata));
        sessionToken.setTemporaryCodeExpiration(BAbsTime.now().add(tempCodeExpirationPeriod));
        return sessionToken;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(approve) && this.getSession() instanceof BFoxSession) {
            return this;
        }
        return super.getActionParameterDefault(action);
    }

    public void doApprove(BValue profileName, Context cx) {
        if (!(profileName instanceof BString)) {
            throw new LocalizableRuntimeException("signingService", "session.token.approve.invalidParamType", new Object[]{profileName.getType()});
        }
        AccessController.doPrivileged(() -> {
            Optional<BAbstractSigningProfile> profile;
            String unescapedProfileName = profileName.toString();
            if (unescapedProfileName.isEmpty() || !(profile = BSessionToken.findMatchingProfile(unescapedProfileName)).isPresent()) {
                throw new LocalizableRuntimeException("signingService", "session.token.approve.invalidProfileName");
            }
            if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)profile.get()).hasAdminWrite()) {
                throw new LocalizableRuntimeException("signingService", "session.token.approve.adminWrite");
            }
            if (this.getState().equals((Object)BApprovalState.expired)) {
                throw new LocalizableRuntimeException("signingService", "session.token.illegalStateChange", new Object[]{BApprovalState.expired.getDisplayTag(cx), BApprovalState.approved.getDisplayTag(cx)});
            }
            this.setProfile(SlotPath.escape((String)unescapedProfileName));
            if (this.getToken().isDefault()) {
                this.setToken(BSessionToken.createRandomSecret());
            }
            if (this.getTokenExpiration().equals((Object)BAbsTime.DEFAULT)) {
                this.setTokenExpiration(BAbsTime.now().add(this.getSessionTokenStore().getTokenExpirationPeriod()));
            }
            this.setState(BApprovalState.approved);
            return null;
        });
    }

    public void doReject(Context cx) throws Exception {
        AccessController.doPrivileged(() -> {
            if (this.getState().equals((Object)BApprovalState.expired)) {
                throw new LocalizableRuntimeException("signingService", "session.token.illegalStateChange", new Object[]{BApprovalState.expired.getDisplayTag(cx), BApprovalState.rejected.getDisplayTag(cx)});
            }
            this.setProfile("");
            this.setState(BApprovalState.rejected);
            return null;
        });
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSessionTokenStore;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public String toString(Context cx) {
        return this.buildSummaryStringFromMetadata(cx);
    }

    public BIcon getIcon() {
        switch (this.getState().getOrdinal()) {
            case 3: {
                return APPROVED_ICON;
            }
            case 1: {
                return REJECTED_ICON;
            }
            case 2: {
                return EXPIRED_ICON;
            }
        }
        return UNAPPROVED_ICON;
    }

    private String buildSummaryStringFromMetadata(Context cx) {
        String comment = SigningServiceUtils.readUserCommentFromMetadataString(this.getMetadata());
        String stationName = SigningServiceUtils.readStationNameFromMetadataString(this.getMetadata());
        if (!comment.isEmpty()) {
            return SigningServiceUtils.LEX.getText(COMMENT_SUMMARY, new Object[]{stationName, this.getState().toString(cx), comment});
        }
        return SigningServiceUtils.LEX.getText(SUMMARY, new Object[]{stationName, this.getState().toString(cx)});
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        BSessionToken.doValidateSet(context);
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        BSessionToken.doValidateSet(context);
    }

    private static void doValidateSet(Context context) {
        if (context != null && context.getUser() != null) {
            throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualPropertyChange");
        }
        SigningServiceUtils.checkSecurity();
    }

    private BSessionTokenStore getSessionTokenStore() {
        return (BSessionTokenStore)this.getParent();
    }

    private static Optional<BAbstractSigningProfile> findMatchingProfile(String unescapedProfileName) {
        BSigningService signingService;
        BValue profile;
        Optional service = Sys.findService((Type)BSigningService.TYPE);
        if (service.isPresent() && (profile = (signingService = (BSigningService)((Object)service.get())).getProfiles().get(SlotPath.escape((String)unescapedProfileName))) instanceof BAbstractSigningProfile) {
            return Optional.of(profile.as(BAbstractSigningProfile.class));
        }
        return Optional.empty();
    }

    private static BPassword createRandomSecret() {
        byte[] buffer = new byte[32];
        SECURE_RANDOM.nextBytes(buffer);
        return BPassword.make((String)Base64.getEncoder().encodeToString(buffer));
    }

    static void resetSessionToken(BSessionToken sessionToken, BRelTime tempCodeExpirationPeriod, Map<String, String> metadataMap) {
        BPassword tempCode = BSessionToken.createRandomSecret();
        sessionToken.setTemporaryCode(tempCode);
        sessionToken.setMetadata(SigningServiceUtils.convertMetadataToString(metadataMap));
        sessionToken.setTemporaryCodeExpiration(BAbsTime.now().add(tempCodeExpirationPeriod));
        for (Property prop : sessionToken.getFrozenPropertiesArray()) {
            if (temporaryCode.equals(prop) || temporaryCodeExpiration.equals(prop) || metadata.equals(prop)) continue;
            sessionToken.set(prop, prop.getDefaultValue());
        }
    }
}

