/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDASecurity;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcDeviceFolder;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.jni.client.common.OpcServer;
import com.tridium.opc.jni.client.da.OpcDaServer;
import java.security.AccessController;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serverState", type="String", defaultValue="", flags=3), @NiagaraProperty(name="serverCurrentTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverLastUpdateTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverStartTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverGroupCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="serverBandWidth", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="serverMajorVersion", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="serverMinorVersion", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="serverBuildNumber", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="serverVendorInfo", type="String", defaultValue="", flags=3), @NiagaraProperty(name="lastConnectTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastShutdownRequest", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="points", type="BOpcPointDeviceExt", defaultValue="new BOpcPointDeviceExt()"), @NiagaraProperty(name="security", type="BOpcDASecurity", defaultValue="new BOpcDASecurity()"), @NiagaraProperty(name="isUserLoggedIn", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="attach", flags=20, override=true), @NiagaraAction(name="detach", flags=20, override=true), @NiagaraAction(name="setSecurity", returnType="BLong", flags=4), @NiagaraAction(name="getServerSecured", returnType="BBoolean", flags=4), @NiagaraAction(name="setServerSecured", parameterType="BBoolean", defaultValue="BBoolean.FALSE", flags=4)})
public class BOpcDaClient
extends BOpcDevice {
    @Generated
    public static final Property serverState = BOpcDaClient.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property serverCurrentTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property serverLastUpdateTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property serverStartTime = BOpcDaClient.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property serverGroupCount = BOpcDaClient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property serverBandWidth = BOpcDaClient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property serverMajorVersion = BOpcDaClient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property serverMinorVersion = BOpcDaClient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property serverBuildNumber = BOpcDaClient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property serverVendorInfo = BOpcDaClient.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property lastConnectTime = BOpcDaClient.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastShutdownRequest = BOpcDaClient.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property points = BOpcDaClient.newProperty((int)0, (BValue)new BOpcPointDeviceExt(), null);
    @Generated
    public static final Property security = BOpcDaClient.newProperty((int)0, (BValue)new BOpcDASecurity(), null);
    @Generated
    public static final Property isUserLoggedIn = BOpcDaClient.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action attach = BOpcDaClient.newAction((int)20, null);
    @Generated
    public static final Action detach = BOpcDaClient.newAction((int)20, null);
    @Generated
    public static final Action setSecurity = BOpcDaClient.newAction((int)4, null);
    @Generated
    public static final Action getServerSecured = BOpcDaClient.newAction((int)4, null);
    @Generated
    public static final Action setServerSecured = BOpcDaClient.newAction((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcDaClient.class);
    private Object detachMutex = new Object();
    private Object attachMutex = new Object();
    private OpcDaServer server;
    boolean bNTSecurityInterfaceSupport = false;
    boolean bPrivateSecurityInterfaceSupport = false;
    Log opcLog = Log.getLog((String)"OpcDaLog");
    Log opcPingLog = Log.getLog((String)"OpcDaPingLog");

    @Generated
    public String getServerState() {
        return this.getString(serverState);
    }

    @Generated
    public void setServerState(String v) {
        this.setString(serverState, v, null);
    }

    @Generated
    public BAbsTime getServerCurrentTime() {
        return (BAbsTime)this.get(serverCurrentTime);
    }

    @Generated
    public void setServerCurrentTime(BAbsTime v) {
        this.set(serverCurrentTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getServerLastUpdateTime() {
        return (BAbsTime)this.get(serverLastUpdateTime);
    }

    @Generated
    public void setServerLastUpdateTime(BAbsTime v) {
        this.set(serverLastUpdateTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getServerStartTime() {
        return (BAbsTime)this.get(serverStartTime);
    }

    @Generated
    public void setServerStartTime(BAbsTime v) {
        this.set(serverStartTime, (BValue)v, null);
    }

    @Generated
    public int getServerGroupCount() {
        return this.getInt(serverGroupCount);
    }

    @Generated
    public void setServerGroupCount(int v) {
        this.setInt(serverGroupCount, v, null);
    }

    @Generated
    public int getServerBandWidth() {
        return this.getInt(serverBandWidth);
    }

    @Generated
    public void setServerBandWidth(int v) {
        this.setInt(serverBandWidth, v, null);
    }

    @Generated
    public int getServerMajorVersion() {
        return this.getInt(serverMajorVersion);
    }

    @Generated
    public void setServerMajorVersion(int v) {
        this.setInt(serverMajorVersion, v, null);
    }

    @Generated
    public int getServerMinorVersion() {
        return this.getInt(serverMinorVersion);
    }

    @Generated
    public void setServerMinorVersion(int v) {
        this.setInt(serverMinorVersion, v, null);
    }

    @Generated
    public int getServerBuildNumber() {
        return this.getInt(serverBuildNumber);
    }

    @Generated
    public void setServerBuildNumber(int v) {
        this.setInt(serverBuildNumber, v, null);
    }

    @Generated
    public String getServerVendorInfo() {
        return this.getString(serverVendorInfo);
    }

    @Generated
    public void setServerVendorInfo(String v) {
        this.setString(serverVendorInfo, v, null);
    }

    @Generated
    public BAbsTime getLastConnectTime() {
        return (BAbsTime)this.get(lastConnectTime);
    }

    @Generated
    public void setLastConnectTime(BAbsTime v) {
        this.set(lastConnectTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastShutdownRequest() {
        return (BAbsTime)this.get(lastShutdownRequest);
    }

    @Generated
    public void setLastShutdownRequest(BAbsTime v) {
        this.set(lastShutdownRequest, (BValue)v, null);
    }

    @Generated
    public BOpcPointDeviceExt getPoints() {
        return (BOpcPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BOpcPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BOpcDASecurity getSecurity() {
        return (BOpcDASecurity)this.get(security);
    }

    @Generated
    public void setSecurity(BOpcDASecurity v) {
        this.set(security, (BValue)v, null);
    }

    @Generated
    public boolean getIsUserLoggedIn() {
        return this.getBoolean(isUserLoggedIn);
    }

    @Generated
    public void setIsUserLoggedIn(boolean v) {
        this.setBoolean(isUserLoggedIn, v, null);
    }

    @Generated
    public BLong setSecurity() {
        return (BLong)this.invoke(setSecurity, null, null);
    }

    @Generated
    public BBoolean getServerSecured() {
        return (BBoolean)this.invoke(getServerSecured, null, null);
    }

    @Generated
    public void setServerSecured(BBoolean parameter) {
        this.invoke(setServerSecured, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAttach() {
        Object object = this.attachMutex;
        synchronized (object) {
            this.opcLog.trace("Connecting");
            if (!this.isRunning()) {
                return;
            }
            if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault()) {
                return;
            }
            try {
                this.setAttaching();
                this.server = this.getLocal() ? (this.getUseVersionIndependentProgId() ? OpcDaServer.newServer(this.getVersionIndependentProgramId()) : OpcDaServer.newServer(this.getProgramId())) : OpcDaServer.newServer(this.getClassId(), this.getAddress());
                if (this.server.getPeerObject() != 0L) {
                    this.bNTSecurityInterfaceSupport = false;
                    this.bPrivateSecurityInterfaceSupport = false;
                    try {
                        if (this.server.getNTSecurity() != null) {
                            this.bNTSecurityInterfaceSupport = true;
                        }
                        if (this.server.getPrivateSecurity() != null) {
                            this.bPrivateSecurityInterfaceSupport = true;
                        }
                    }
                    catch (Exception ex) {
                        this.opcLog.trace("Server does not support OpcSecurityNT/OpcSecurityPrivate interface");
                    }
                    this.MakeSlotsReadOnly();
                    this.setLoginSettingsToCurrentInstance();
                    this.setAttached();
                    OpcDaServer.Status status = this.server.getStatus();
                    this.setLastConnectTime(Clock.time());
                    boolean isOk = this.setServerStatusInfo(status);
                    if (isOk) {
                        this.pingOk();
                        this.opcPingLog.trace("Server is in running state, connected. Calling pingok()");
                    } else {
                        this.opcPingLog.warning("Server is not in running state ");
                    }
                    try {
                        this.server.setShutdownListener(new Shutdown());
                        this.opcLog.trace("Registered shutdown callback.");
                    }
                    catch (Throwable x) {
                        this.opcLog.message("Unable to register shutdown callback: " + x.toString(), x);
                    }
                } else {
                    this.pingFail("Cannot connect: Server creation failed ");
                    this.opcPingLog.warning("Cannot connect: Server creation failed, calling pingFail ");
                    this.setDetached();
                    return;
                }
                this.getPoints().attach();
            }
            catch (Throwable x) {
                this.pingFail("Cannot connect: " + x.toString());
                this.opcPingLog.warning("Cannot connect, calling pingfail ", x);
                this.setDetached();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDetach() {
        Object object = this.detachMutex;
        synchronized (object) {
            if (this.getState().isDetached()) {
                return;
            }
            try {
                this.opcLog.trace("Disconnecting");
                this.setDetaching();
                if (this.server != null) {
                    this.getPoints().detach();
                    this.server.release();
                    this.opcLog.trace("Server release() called");
                }
                this.opcLog.trace("Disconnected");
            }
            catch (Throwable x) {
                this.opcLog.error("Failure disconnecting", x);
                this.opcLog.trace("doDetach::AsyncIo set to false");
            }
            finally {
                this.server = null;
                this.setServerState("");
                this.setDetached();
                this.opcLog.trace("doDetach::Detached");
            }
        }
    }

    @Override
    public void doPing() {
        OpcEnv.initializeThread();
        this.opcPingLog.trace("doPing()::Initialized Threads");
        try {
            if (this.getState().isAttached()) {
                this.opcPingLog.trace("doPing()::Server is attached already. Refreshing status");
                OpcDaServer.Status status = this.server.getStatus();
                this.setServerStartTime(BAbsTime.make((long)status.startTime, (BTimeZone)BTimeZone.UTC));
                this.setServerCurrentTime(BAbsTime.make((long)status.currentTime, (BTimeZone)BTimeZone.UTC));
                this.setServerLastUpdateTime(BAbsTime.make((long)status.lastUpdateTime, (BTimeZone)BTimeZone.UTC));
                boolean isOk = this.setServerStatusInfo(status);
                if (isOk) {
                    this.pingOk();
                    this.opcPingLog.trace("doPing()::Ping is successful");
                } else {
                    this.pingFail(this.getServerState());
                    this.opcPingLog.trace("doPing()::Ping failed. The server state is:: " + this.getServerState());
                }
            } else if (this.getState().isDetached()) {
                this.opcPingLog.trace("doPing()::Currently server detached. calling Attach()");
                this.attach();
            }
        }
        catch (Throwable t) {
            this.opcPingLog.error("Ping failed", t);
            this.pingFail(t.getMessage());
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOpcNetwork || parent instanceof BOpcDeviceFolder;
    }

    private boolean setServerStatusInfo(OpcDaServer.Status status) {
        boolean isOk = this.updateServerState(status.state);
        this.setServerGroupCount(status.groupCount);
        this.setServerBandWidth(status.bandwidth);
        this.setServerMajorVersion(status.majorVersion);
        this.setServerMinorVersion(status.minorVersion);
        this.setServerBuildNumber(status.buildNumber);
        this.setServerVendorInfo(status.vendorInfo);
        return isOk;
    }

    public OpcDaServer getPeer() {
        return this.server;
    }

    private boolean updateServerState(int state) {
        String msg = null;
        boolean isOk = true;
        BOpcNetwork net = this.getOpcNetwork();
        if (net == null) {
            System.out.println("Network object is NULL");
            return isOk;
        }
        switch (state) {
            case 1: {
                msg = net.lex("daServerState.running");
                isOk = true;
                break;
            }
            case 2: {
                msg = net.lex("daServerState.failed");
                isOk = false;
                break;
            }
            case 3: {
                msg = net.lex("daServerState.noConfig");
                isOk = false;
                break;
            }
            case 4: {
                msg = net.lex("daServerState.suspended");
                isOk = false;
                break;
            }
            case 5: {
                msg = net.lex("daServerState.test");
                isOk = true;
                break;
            }
            case 6: {
                msg = net.lex("daServerState.commFault");
                isOk = true;
                break;
            }
            default: {
                msg = net.lex("daServerState.unknown") + ": " + state;
                isOk = true;
            }
        }
        if (!this.getServerState().equals(msg)) {
            this.setServerState(msg);
            if (!isOk) {
                this.opcLog.warning("Server state: " + msg);
            }
        }
        return isOk;
    }

    public BLong doSetSecurity() {
        BLong tempVal = BLong.make((long)this.setSecurityConfiguration());
        return tempVal;
    }

    public BBoolean doGetServerSecured() {
        return BBoolean.make((boolean)this.getIsUserLoggedIn());
    }

    public void doSetServerSecured(BBoolean blnlog) {
        this.setIsUserLoggedIn(blnlog.getBoolean());
    }

    public long setSecurityConfiguration() {
        long returnVal = 0L;
        long result = 0L;
        this.opcLog.trace("Set Security Configuration");
        if (!this.getSecurity().getPrivateSecurity()) {
            this.opcLog.trace("Private security is not selected");
            if (this.bNTSecurityInterfaceSupport) {
                this.opcLog.trace("NT security is supported by the server");
                result = this.getPeer().getNTSecurity().changeUser(this.getSecurity().getLoginName(), AccessController.doPrivileged(() -> ((BPassword)this.getSecurity().getLoginPassword()).getValue()));
                switch ((int)result) {
                    case 0: {
                        returnVal = 0L;
                        break;
                    }
                    case -1: {
                        returnVal = -1L;
                        break;
                    }
                    case -2: {
                        returnVal = -2L;
                        break;
                    }
                    case -3: {
                        returnVal = -3L;
                        break;
                    }
                    case -4: {
                        returnVal = -4L;
                        break;
                    }
                    case -5: {
                        returnVal = -5L;
                    }
                }
            } else {
                returnVal = 1L;
            }
        } else if (this.getSecurity().getPrivateSecurity()) {
            this.opcLog.trace("Private security is selected");
            if (this.bPrivateSecurityInterfaceSupport) {
                this.opcLog.trace("Private security is supported by the server");
                if (this.getSecurity().getState().getOrdinal() == 0) {
                    result = this.getPeer().getPrivateSecurity().logOn(this.getSecurity().getLoginName(), AccessController.doPrivileged(() -> ((BPassword)this.getSecurity().getLoginPassword()).getValue()));
                    switch ((int)result) {
                        case 0: {
                            returnVal = 0L;
                            break;
                        }
                        case -1: {
                            returnVal = -6L;
                            break;
                        }
                        case -2: {
                            returnVal = -7L;
                            break;
                        }
                        case -3: {
                            returnVal = -8L;
                            break;
                        }
                        case -4: {
                            returnVal = -9L;
                            break;
                        }
                        case -5: {
                            returnVal = -10L;
                        }
                    }
                } else {
                    boolean bResult = this.getPeer().getPrivateSecurity().logOff();
                    returnVal = bResult ? 0L : -11L;
                }
            } else {
                returnVal = 2L;
            }
        }
        this.setIsUserLoggedIn(true);
        this.lease(5);
        return returnVal;
    }

    private void setLoginSettingsToCurrentInstance() {
        if (this.getSecurity().getLoginName() != "") {
            if (AccessController.doPrivileged(() -> ((BPassword)this.getSecurity().getLoginPassword()).getValue()) != "") {
                this.setSecurityConfiguration();
            }
        }
    }

    private void MakeSlotsReadOnly() {
        if (!this.bNTSecurityInterfaceSupport && !this.bPrivateSecurityInterfaceSupport) {
            this.setFlags(this.getSlot("security"), 4);
        } else {
            this.getSecurity().MakeSlotsReadOnly(this.bNTSecurityInterfaceSupport, this.bPrivateSecurityInterfaceSupport);
        }
    }

    private class Shutdown
    implements OpcServer.ShutdownListener {
        private Shutdown() {
        }

        @Override
        public void shutdownDeleted() {
            if (BOpcDaClient.this.getState().isAttached() && BOpcDaClient.this.isRunning()) {
                BOpcDaClient.this.opcLog.warning("Shutdown callback deleted.");
                BOpcDaClient.this.server.setShutdownListener(this);
            }
        }

        @Override
        public void shutdownRequest(String reason) {
            BOpcDaClient.this.setLastShutdownRequest(Clock.time());
            BOpcDaClient.this.opcLog.warning("Shutdown request. Detaching...");
            BOpcDaClient.this.doDetach();
            BOpcDaClient.this.pingFail("Server shutdown request");
        }
    }
}

