/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil;

import com.vykon.vykonProUtil.enums.BAssignmentModeEnum;
import com.vykon.vykonProUtil.util.BCommandNotification;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BBatchCategoryAssignmentTool
extends BComponent {
    public static final Property assignmentMode = BBatchCategoryAssignmentTool.newProperty((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BAssignmentModeEnum.TYPE)), null);
    public static final Property startOrd = BBatchCategoryAssignmentTool.newProperty((int)4, (BValue)BOrd.make((String)"station:|slot:/"), null);
    public static final Property componentName = BBatchCategoryAssignmentTool.newProperty((int)4, (String)"enter component name", null);
    public static final Property findExactName = BBatchCategoryAssignmentTool.newProperty((int)4, (boolean)true, null);
    public static final Property componentType = BBatchCategoryAssignmentTool.newProperty((int)4, (BValue)BTypeSpec.make((Type)BComponent.TYPE), null);
    public static final Property categoryMaskToApply = BBatchCategoryAssignmentTool.newProperty((int)4, (BValue)BCategoryMask.make((String)""), null);
    public static final Property displayConfirmation = BBatchCategoryAssignmentTool.newProperty((int)0, (boolean)true, null);
    public static final Action assignCategories = BBatchCategoryAssignmentTool.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBatchCategoryAssignmentTool.class);
    private static final BIcon icon = BIcon.std((String)"category.png");

    public BEnum getAssignmentMode() {
        return (BEnum)this.get(assignmentMode);
    }

    public void setAssignmentMode(BEnum v) {
        this.set(assignmentMode, (BValue)v, null);
    }

    public BOrd getStartOrd() {
        return (BOrd)this.get(startOrd);
    }

    public void setStartOrd(BOrd v) {
        this.set(startOrd, (BValue)v, null);
    }

    public String getComponentName() {
        return this.getString(componentName);
    }

    public void setComponentName(String v) {
        this.setString(componentName, v, null);
    }

    public boolean getFindExactName() {
        return this.getBoolean(findExactName);
    }

    public void setFindExactName(boolean v) {
        this.setBoolean(findExactName, v, null);
    }

    public BTypeSpec getComponentType() {
        return (BTypeSpec)this.get(componentType);
    }

    public void setComponentType(BTypeSpec v) {
        this.set(componentType, (BValue)v, null);
    }

    public BCategoryMask getCategoryMaskToApply() {
        return (BCategoryMask)this.get(categoryMaskToApply);
    }

    public void setCategoryMaskToApply(BCategoryMask v) {
        this.set(categoryMaskToApply, (BValue)v, null);
    }

    public boolean getDisplayConfirmation() {
        return this.getBoolean(displayConfirmation);
    }

    public void setDisplayConfirmation(boolean v) {
        this.setBoolean(displayConfirmation, v, null);
    }

    public void assignCategories() {
        this.invoke(assignCategories, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doAssignCategories() {
        StringBuffer message = new StringBuffer();
        BOrd qord = BOrd.make((String)this.buildQuery());
        BITable list = (BITable)qord.resolve().get();
        try (TableCursor cursor = list.cursor();){
            while (cursor.next()) {
                BComponent comp = (BComponent)cursor.get();
                comp.setCategoryMask(this.getCategoryMaskToApply(), null);
                if (!this.getDisplayConfirmation()) continue;
                message.append("modifiying category assignment for " + comp.getDisplayName(null) + '\n');
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error assigning categories");
            e.printStackTrace();
        }
        if (this.getDisplayConfirmation()) {
            BCommandNotification notify = new BCommandNotification();
            notify.setDialogTitle("Batch category assignment tool confirmation");
            notify.setDialogMessage(message.toString());
            notify.raise(false);
        }
    }

    private String buildQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStartOrd().toString());
        sb.append("|bql:select * ");
        if (this.getAssignmentMode().getEnum().getOrdinal() != 0) {
            sb.append("from " + this.getComponentType().toString());
        }
        if (this.getAssignmentMode().getEnum().getOrdinal() != 1) {
            if (this.getFindExactName()) {
                sb.append(" where name='" + this.getComponentName() + "'");
            } else {
                sb.append(" where name like '*" + this.getComponentName() + "*'");
            }
        }
        return sb.toString();
    }

    public BIcon getIcon() {
        return icon;
    }
}

