/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.job;

import com.tridium.data.BDataTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BGlobalJob
extends BJob
implements Runnable {
    public static final Property currentProgress = BGlobalJob.newProperty((int)5, (String)"", null);
    public static final Property logLimit = BGlobalJob.newProperty((int)1, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)10000)));
    public static final Type TYPE = Sys.loadType(BGlobalJob.class);
    private volatile Context cx;

    public String getCurrentProgress() {
        return this.getString(currentProgress);
    }

    public void setCurrentProgress(String v) {
        this.setString(currentProgress, v, null);
    }

    public int getLogLimit() {
        return this.getInt(logLimit);
    }

    public void setLogLimit(int v) {
        this.setInt(logLimit, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCancel(Context cx) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void doRun(Context cx) throws Exception {
        this.cx = cx;
        this.postAsync();
    }

    @Override
    public final void run() {
        try {
            this.run(this.cx);
            if (this.getJobState() == BJobState.canceling) {
                this.canceled();
            } else {
                this.success();
            }
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    protected abstract void postAsync();

    public abstract void run(Context var1) throws Exception;

    public JobLog readGlobalLog() {
        System.out.println("starting to readGlobalLog");
        JobLog log = new JobLog();
        try {
            BOrd jord = BOrd.make((String)(this.getHandleOrd().toString() + "|bql:vykonProUtil:GlobalJob.exportJobLogToTable()"));
            System.out.println("the job ord is " + jord);
            BITable table = (BITable)jord.get((BObject)this);
            Column col = table.getColumns().get(0);
            try (TableCursor c = table.cursor();){
                while (c.next()) {
                }
                log.add(JobLogItem.decode((String)c.cell(col).toString(null)));
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath());
            e.printStackTrace();
        }
        return log;
    }

    public static final BITable exportJobLogToTable(BObject job) {
        JobLog log = ((BJob)job).log();
        JobLogItem[] items = log.getItems();
        BDataTable table = new BDataTable();
        table.addColumn("log", BString.TYPE, 0, BFacets.NULL);
        table.startRows();
        for (int i = 0; i < items.length; ++i) {
            JobLogItem item = items[i];
            table.startRow();
            table.set(item.encode(), BFacets.NULL);
            table.endRow();
        }
        table.endRows();
        return table;
    }
}

