/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.points;

import com.vykon.vykonProUtil.points.BAbsOverride;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsBooleanWritableCommand
extends BComponent {
    public static final Property pointOrd = BAbsBooleanWritableCommand.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property defaultTime = BAbsBooleanWritableCommand.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property facets = BAbsBooleanWritableCommand.newProperty((int)7, (BValue)BFacets.makeBoolean(), null);
    public static final Property fallback = BAbsBooleanWritableCommand.newProperty((int)7, (boolean)false, null);
    public static final Property out = BAbsBooleanWritableCommand.newProperty((int)7, (boolean)false, null);
    public static final Action emergencyActive = BAbsBooleanWritableCommand.newAction((int)0, null);
    public static final Action emergencyInactive = BAbsBooleanWritableCommand.newAction((int)0, null);
    public static final Action emergencyAuto = BAbsBooleanWritableCommand.newAction((int)0, null);
    public static final Action active = BAbsBooleanWritableCommand.newAction((int)256, (BValue)new BOverride(), null);
    public static final Action inactive = BAbsBooleanWritableCommand.newAction((int)256, (BValue)new BOverride(), null);
    public static final Action auto = BAbsBooleanWritableCommand.newAction((int)256, null);
    public static final Action absActive = BAbsBooleanWritableCommand.newAction((int)256, (BValue)new BAbsOverride(), null);
    public static final Action absInactive = BAbsBooleanWritableCommand.newAction((int)256, (BValue)new BAbsOverride(), null);
    public static final Action set = BAbsBooleanWritableCommand.newAction((int)256, (BValue)BBoolean.FALSE, null);
    public static final Action cancelMinTimer = BAbsBooleanWritableCommand.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAbsBooleanWritableCommand.class);
    private static final BIcon icon = BIcon.std((String)"control/booleanPoint.png");
    BBooleanPoint slave = null;
    PointSubscriber pointSub = null;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd v) {
        this.set(pointOrd, (BValue)v, null);
    }

    public BRelTime getDefaultTime() {
        return (BRelTime)this.get(defaultTime);
    }

    public void setDefaultTime(BRelTime v) {
        this.set(defaultTime, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public boolean getFallback() {
        return this.getBoolean(fallback);
    }

    public void setFallback(boolean v) {
        this.setBoolean(fallback, v, null);
    }

    public boolean getOut() {
        return this.getBoolean(out);
    }

    public void setOut(boolean v) {
        this.setBoolean(out, v, null);
    }

    public void emergencyActive() {
        this.invoke(emergencyActive, null, null);
    }

    public void emergencyInactive() {
        this.invoke(emergencyInactive, null, null);
    }

    public void emergencyAuto() {
        this.invoke(emergencyAuto, null, null);
    }

    public void active(BOverride arg) {
        this.invoke(active, (BValue)arg, null);
    }

    public void inactive(BOverride arg) {
        this.invoke(inactive, (BValue)arg, null);
    }

    public void auto() {
        this.invoke(auto, null, null);
    }

    public void absActive(BAbsOverride arg) {
        this.invoke(absActive, (BValue)arg, null);
    }

    public void absInactive(BAbsOverride arg) {
        this.invoke(absInactive, (BValue)arg, null);
    }

    public void set(BBoolean arg) {
        this.invoke(set, (BValue)arg, null);
    }

    public void cancelMinTimer() {
        this.invoke(cancelMinTimer, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.pointSub.unsubscribeAll();
        this.pointSub = null;
    }

    public void stationStarted() {
        this.initPoint();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == pointOrd) {
            this.initPoint();
        }
    }

    private void initPoint() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getPointOrd() != BOrd.NULL) {
            try {
                this.slave = (BBooleanPoint)this.getPointOrd().resolve((BObject)this).get();
                if (this.slave.get("fallback") != null) {
                    boolean val = ((BStatusBoolean)this.slave.get("fallback")).getValue();
                    this.setFallback(val);
                }
                this.setOut(this.slave.getOut().getValue());
                if (this.slave.get("facets") != null) {
                    this.setFacets((BFacets)this.slave.get("facets"));
                }
                this.pointSub = new PointSubscriber();
                this.pointSub.subscribe((BComponent)this.slave);
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath() + " couldn't resolve point ord");
                System.out.println(e);
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == active || slot == inactive || slot == set || slot == absActive || slot == absInactive) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doEmergencyActive(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyActive").asAction(), (BValue)BBoolean.make((boolean)true), cx);
    }

    public void doEmergencyInactive(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyInactive").asAction(), (BValue)BBoolean.make((boolean)false), cx);
    }

    public void doEmergencyAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyAuto").asAction(), null, cx);
    }

    public void doActive(BOverride override, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("active").asAction(), (BValue)override, cx);
    }

    public void doInactive(BOverride override, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("inactive").asAction(), (BValue)override, cx);
    }

    public void doAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("auto").asAction(), null, cx);
    }

    public void doAbsActive(BAbsOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime end = BAbsTime.NULL;
        if (v != null && v.get("expireTime") != null) {
            end = v.getExpireTime();
        }
        long timeDiff = 0L;
        if (current != BAbsTime.NULL && end != BAbsTime.NULL) {
            timeDiff = v.getExpireTime().getMillis() - current.getMillis();
        }
        BRelTime dur = null;
        dur = timeDiff <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)timeDiff);
        BOverride o = new BOverride();
        o.setDuration(dur);
        this.slave.invoke(this.slave.getSlot("active").asAction(), (BValue)o, cx);
    }

    public void doAbsInactive(BAbsOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime end = BAbsTime.NULL;
        if (v != null && v.get("expireTime") != null) {
            end = v.getExpireTime();
        }
        long timeDiff = 0L;
        if (current != BAbsTime.NULL && end != BAbsTime.NULL) {
            timeDiff = v.getExpireTime().getMillis() - current.getMillis();
        }
        BRelTime dur = null;
        dur = timeDiff <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)timeDiff);
        BOverride o = new BOverride();
        o.setDuration(dur);
        this.slave.invoke(this.slave.getSlot("inactive").asAction(), (BValue)o, cx);
    }

    public void doSet(BBoolean v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("set").asAction(), (BValue)v, cx);
    }

    public void doCancelMinTimer(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("cancelMinTimer").asAction(), null, cx);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == set) {
            return BBoolean.make((boolean)this.getFallback());
        }
        if (action == active || action == inactive) {
            BOverride o = new BOverride();
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        if (action == absActive || action == absInactive) {
            BAbsTime end = Clock.time().add(this.getDefaultTime());
            BAbsOverride o = new BAbsOverride();
            o.setExpireTime(end);
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        return super.getActionParameterDefault(action);
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime maxDuration = BRelTime.DEFAULT;
        try {
            BFacets facets = this.getFacets();
            BObject obj = facets.get("maxOverrideDuration");
            if (obj instanceof BRelTime) {
                maxDuration = (BRelTime)obj;
            } else {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this);
                if (!station.isRunning()) {
                    station.loadSlots();
                    station.lease();
                }
                facets = (BFacets)station.get("sysInfo");
                maxDuration = (BRelTime)facets.get("maxOverrideDuration", (BObject)maxDuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxDuration;
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PointSubscriber
    extends Subscriber {
        private PointSubscriber() {
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            if (id == 0) {
                if (event.getSlotName().equals("fallback")) {
                    boolean val = ((BStatusBoolean)BAbsBooleanWritableCommand.this.slave.get("fallback")).getValue();
                    BAbsBooleanWritableCommand.this.setFallback(val);
                }
                if (event.getSlotName().equals("out")) {
                    BAbsBooleanWritableCommand.this.setOut(BAbsBooleanWritableCommand.this.slave.getOut().getValue());
                }
                if (event.getSlotName().equals("facets")) {
                    BAbsBooleanWritableCommand.this.setFacets(BAbsBooleanWritableCommand.this.slave.getFacets());
                }
            }
        }
    }
}

