/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.points;

import com.vykon.vykonProUtil.points.BAbsNumericOverride;
import javax.baja.control.BNumericPoint;
import javax.baja.control.util.BNumericOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsNumericWritableCommand
extends BComponent {
    public static final Property pointOrd = BAbsNumericWritableCommand.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property defaultTime = BAbsNumericWritableCommand.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property facets = BAbsNumericWritableCommand.newProperty((int)7, (BValue)BFacets.makeNumeric(), null);
    public static final Property fallback = BAbsNumericWritableCommand.newProperty((int)7, (double)0.0, null);
    public static final Property out = BAbsNumericWritableCommand.newProperty((int)7, (double)0.0, null);
    public static final Action emergencyOverride = BAbsNumericWritableCommand.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    public static final Action emergencyAuto = BAbsNumericWritableCommand.newAction((int)0, null);
    public static final Action override = BAbsNumericWritableCommand.newAction((int)256, (BValue)new BNumericOverride(), null);
    public static final Action auto = BAbsNumericWritableCommand.newAction((int)256, null);
    public static final Action set = BAbsNumericWritableCommand.newAction((int)256, (BValue)BDouble.DEFAULT, null);
    public static final Action absOverride = BAbsNumericWritableCommand.newAction((int)256, (BValue)new BAbsNumericOverride(), null);
    public static final Type TYPE = Sys.loadType(BAbsNumericWritableCommand.class);
    private static final BIcon icon = BIcon.std((String)"control/numericPoint.png");
    BNumericPoint slave = null;
    PointSubscriber pointSub = null;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd v) {
        this.set(pointOrd, (BValue)v, null);
    }

    public BRelTime getDefaultTime() {
        return (BRelTime)this.get(defaultTime);
    }

    public void setDefaultTime(BRelTime v) {
        this.set(defaultTime, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public double getFallback() {
        return this.getDouble(fallback);
    }

    public void setFallback(double v) {
        this.setDouble(fallback, v, null);
    }

    public double getOut() {
        return this.getDouble(out);
    }

    public void setOut(double v) {
        this.setDouble(out, v, null);
    }

    public void emergencyOverride(BDouble arg) {
        this.invoke(emergencyOverride, (BValue)arg, null);
    }

    public void emergencyAuto() {
        this.invoke(emergencyAuto, null, null);
    }

    public void override(BNumericOverride arg) {
        this.invoke(override, (BValue)arg, null);
    }

    public void auto() {
        this.invoke(auto, null, null);
    }

    public void set(BDouble arg) {
        this.invoke(set, (BValue)arg, null);
    }

    public void absOverride(BAbsNumericOverride arg) {
        this.invoke(absOverride, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.pointSub.unsubscribeAll();
        this.pointSub = null;
    }

    public void stationStarted() {
        this.initPoint();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == pointOrd) {
            this.initPoint();
        }
    }

    private void initPoint() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getPointOrd() != BOrd.NULL) {
            try {
                this.slave = (BNumericPoint)this.getPointOrd().resolve((BObject)this).get();
                if (this.slave.get("fallback") != null) {
                    double val = ((BStatusNumeric)this.slave.get("fallback")).getValue();
                    this.setFallback(val);
                }
                this.setOut(this.slave.getOut().getValue());
                if (this.slave.get("facets") != null) {
                    this.setFacets((BFacets)this.slave.get("facets"));
                }
                this.pointSub = new PointSubscriber();
                this.pointSub.subscribe((BComponent)this.slave);
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath() + " couldn't resolve point ord");
                System.out.println(e);
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == override || slot == emergencyOverride || slot == set || slot == absOverride) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doEmergencyOverride(BDouble v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyOverride").asAction(), (BValue)v, cx);
    }

    public void doEmergencyAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyAuto").asAction(), null, cx);
    }

    public void doOverride(BNumericOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)v, cx);
    }

    public void doAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("auto").asAction(), null, cx);
    }

    public void doSet(BDouble v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("set").asAction(), (BValue)v, cx);
    }

    public void doAbsOverride(BAbsNumericOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime end = BAbsTime.NULL;
        double val = 0.0;
        if (v != null && v.get("expireTime") != null) {
            end = v.getExpireTime();
        }
        if (v != null && v.get("value") != null) {
            val = v.getValue();
        }
        long timeDiff = 0L;
        if (current != BAbsTime.NULL && end != BAbsTime.NULL) {
            timeDiff = v.getExpireTime().getMillis() - current.getMillis();
        }
        BRelTime dur = null;
        dur = timeDiff <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)timeDiff);
        BNumericOverride o = new BNumericOverride(dur, val);
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)o, cx);
    }

    public BValue getActionParameterDefault(Action action) {
        BDouble value = null;
        if (action == set) {
            value = BDouble.make((double)this.getFallback());
        } else if (action == override || action == emergencyOverride || action == absOverride) {
            value = BDouble.make((double)this.getOut());
        }
        if (value != null) {
            BNumber maxFacet;
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            double v = value.getDouble();
            BFacets facets = this.getFacets();
            BNumber minFacet = (BNumber)facets.getFacet("min");
            if (minFacet != null) {
                min = minFacet.getDouble();
            }
            if ((maxFacet = (BNumber)facets.getFacet("max")) != null) {
                max = maxFacet.getDouble();
            }
            if (minFacet != null && v < min) {
                value = minFacet;
            } else if (maxFacet != null && v > max) {
                value = maxFacet;
            }
        }
        if (action == emergencyOverride || action == set) {
            return value;
        }
        if (action == override) {
            BNumericOverride o = new BNumericOverride(value.getDouble());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        if (action == absOverride) {
            BAbsTime end = Clock.time().add(this.getDefaultTime());
            BAbsNumericOverride o = new BAbsNumericOverride(end, value.getDouble());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        return super.getActionParameterDefault(action);
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime maxDuration = BRelTime.DEFAULT;
        try {
            BFacets facets = this.getFacets();
            BObject obj = facets.get("maxOverrideDuration");
            if (obj instanceof BRelTime) {
                maxDuration = (BRelTime)obj;
            } else {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this);
                if (!station.isRunning()) {
                    station.loadSlots();
                    station.lease();
                }
                facets = (BFacets)station.get("sysInfo");
                maxDuration = (BRelTime)facets.get("maxOverrideDuration", (BObject)maxDuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxDuration;
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PointSubscriber
    extends Subscriber {
        private PointSubscriber() {
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            if (id == 0) {
                if (event.getSlotName().equals("fallback")) {
                    double val = ((BStatusNumeric)BAbsNumericWritableCommand.this.slave.get("fallback")).getValue();
                    BAbsNumericWritableCommand.this.setFallback(val);
                }
                if (event.getSlotName().equals("out")) {
                    BAbsNumericWritableCommand.this.setOut(BAbsNumericWritableCommand.this.slave.getOut().getValue());
                }
                if (event.getSlotName().equals("facets")) {
                    BAbsNumericWritableCommand.this.setFacets(BAbsNumericWritableCommand.this.slave.getFacets());
                }
            }
        }
    }
}

