/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.sentience;

import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="defaultSystemType", type="BString", defaultValue="BString.make(NIAGARA_SYSTEM_TYPE)", flags=4)
@NiagaraAction(name="resetConnector")
public class BSentienceDevTestComponent
extends BComponent {
    public static final Property defaultSystemType = BSentienceDevTestComponent.newProperty((int)4, (BValue)BString.make((String)"n4-station"), null);
    public static final Action resetConnector = BSentienceDevTestComponent.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSentienceDevTestComponent.class);
    private static final Logger log = Logger.getLogger("cloud.connector.sentience");
    private static final String NIAGARA_SYSTEM_ID_TEST = "Tst";
    private boolean isJace8000;
    private static SecureRandom sRand;

    public String getDefaultSystemType() {
        return this.getString(defaultSystemType);
    }

    public void setDefaultSystemType(String v) {
        this.setString(defaultSystemType, v, null);
    }

    public void resetConnector() {
        this.invoke(resetConnector, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSentienceDevTestComponent() {
    }

    public BSentienceDevTestComponent(boolean isJace8000) {
        this.setJace8000(isJace8000);
    }

    public void started() throws Exception {
        super.started();
        this.setJace8000(Sys.getHostId().contains("TITAN"));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSentienceConnectorImpl;
    }

    public void doResetConnector(Context cx) throws Exception {
        try {
            ((BSentienceConnectorImpl)this.getParent().as(BSentienceConnectorImpl.class)).getCloudConnector().getExecutor().submit(((BSentienceConnectorImpl)this.getParent().as(BSentienceConnectorImpl.class))::resetConnectorInfo);
        }
        catch (Exception e) {
            log.info("connImpl.reset.keyError");
        }
    }

    String makeSystemId(String stationName) {
        StringBuilder sb = new StringBuilder();
        sb.append("N4").append(":").append(stationName).append(":").append(this.makeHostId());
        log.finest("Created dummy systemId " + sb.toString());
        return sb.toString();
    }

    static String getSafeStationNameFromSystemId(String systemId) {
        String[] strs = systemId.split(":");
        return strs.length >= 2 ? strs[1] : "";
    }

    private String makeHostId() {
        StringBuilder sb = new StringBuilder();
        sb.append(NIAGARA_SYSTEM_ID_TEST);
        if (this.isJace8000) {
            sb.append('-').append("TITAN");
        }
        for (int i = 0; i < 4; ++i) {
            byte[] b = new byte[2];
            sRand.nextBytes(b);
            String s = String.format("-%02X%02X", b[0], b[1]);
            sb.append(s);
        }
        return sb.toString();
    }

    public void setJace8000(boolean isJace8000) {
        this.isJace8000 = isJace8000;
    }

    public boolean isJace8000() {
        return this.isJace8000;
    }

    static {
        try {
            sRand = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            sRand = new SecureRandom();
        }
    }
}

