/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.dt;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.sql.PropertyValue;
import java.util.LinkedHashMap;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.table.TableModel;

public class DynamicTableResultModel
extends TableModel {
    protected boolean reachedMax = false;
    protected boolean manualSort = false;
    protected OrionType rowType;
    protected Property[] props;
    protected BDynamicTableColumn[] cols;
    protected BIOrionObject[] rows;
    protected int colsCount;
    protected BDynamicTable dt;
    protected Context cx;
    public static final int COALESCE_LIMIT = Integer.getInteger("niagara.dynamicTable.coalesceLimit", 20);

    public DynamicTableResultModel() {
        this.cols = new BDynamicTableColumn[0];
        this.rows = new BIOrionObject[0];
    }

    public DynamicTableResultModel(OrionType rowType, BDynamicTableColumn[] cols, BIOrionObject[] rows, BDynamicTable dt, Context cx) {
        this.rowType = rowType;
        this.props = rowType.getProperties();
        this.cols = cols;
        this.dt = dt;
        this.cx = cx;
        int count = 0;
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getHiddenKey()) continue;
            ++count;
        }
        this.colsCount = count;
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public int getColumnCount() {
        return this.colsCount;
    }

    public String getColumnName(int col) {
        return this.cols[col].getAlias().format((Object)this.dt, this.cx);
    }

    public int getColumnIndex(BDynamicTableColumn col) {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i].getColumnName().equals(col.getColumnName())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject getResolvedSubject(int row) {
        BOrionDatabase db = this.dt.getOrionDatabase();
        try (OrionSession session = db.createSession(this.cx);){
            BIOrionObject read;
            OrionType dynamicRowType = db.getType(this.dt.getRowType());
            Property[] key = dynamicRowType.getKey();
            PropertyValue[] keyValue = new PropertyValue[key.length];
            for (int i = 0; i < key.length; ++i) {
                keyValue[i] = new PropertyValue(key[i], this.rows[row].get(key[i]));
            }
            BIOrionObject bIOrionObject = read = session.read(dynamicRowType, keyValue);
            return bIOrionObject;
        }
    }

    public Object getSubject(int row) {
        return this.rows[row];
    }

    public Object getValueAt(int row, int col) {
        BIOrionObject obj = this.rows[row];
        Property p = this.props[col];
        return obj.get(p).toString((Context)new BasicContext(this.cx, obj.getSlotFacets((Slot)p)));
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public void sortByColumn(int col, boolean ascending) {
    }

    public void setManualSort(boolean manualSort) {
        this.manualSort = manualSort;
    }

    public void calculateResults(BDynamicTable dt, OrionType dynamicRowType, OrionCursor c, Context cx) {
        this.calculateResults(dt, dynamicRowType, c, -1, cx);
    }

    public void calculateResults(BDynamicTable dt, OrionType dynamicRowType, OrionCursor c, int maxRows, Context cx) {
        if (!dt.supportsPaginatedQuery(cx) || dt.getWorkingReportType(cx) == BDynamicTableReportType.fullReport) {
            this.coalesce(dt, dynamicRowType, c, maxRows, cx);
            return;
        }
        Array a = new Array(BIOrionObject.class);
        boolean checkThreshold = maxRows > 0;
        int count = 0;
        while (c.next() && (!checkThreshold || count < maxRows)) {
            if (checkThreshold) {
                ++count;
            }
            BIOrionObject current = (BIOrionObject)c.get();
            a.add((Object)current);
        }
        this.rows = (BIOrionObject[])a.trim();
    }

    public void coalesce(BDynamicTable dt, OrionType dynamicRowType, OrionCursor c, int maxRows, Context cx) {
        Property[] keys = dt.getOrionDatabase().getType(dt.getRowType()).getKey();
        Property[] props = dynamicRowType.getProperties();
        Array canCoalesceProps = new Array(Property.class);
        BDynamicTableColumn[] cols = dt.getWorkingColumns(cx);
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].canCoalesce(dt.getRowType())) continue;
            canCoalesceProps.add((Object)props[i]);
        }
        props = (Property[])canCoalesceProps.trim();
        LinkedHashMap<String, BIOrionObject> map = new LinkedHashMap<String, BIOrionObject>();
        Array a = new Array(BIOrionObject.class);
        boolean coalesce = dt.getCoalesce() && props.length > 0;
        boolean checkThreshold = maxRows > 0;
        int count = 0;
        while (c.next()) {
            if (checkThreshold) {
                if (count >= maxRows) {
                    this.rows = coalesce ? map.values().toArray(new BIOrionObject[0]) : (BIOrionObject[])a.trim();
                    this.reachedMax = true;
                    return;
                }
                ++count;
            }
            BIOrionObject current = (BIOrionObject)c.get();
            if (!coalesce) {
                a.add((Object)current);
                continue;
            }
            String handle = BOrionScheme.encodePropertiesToString((BIOrionObject)current, (Property[])keys);
            Object entry = map.get(handle);
            if (entry == null) {
                map.put(handle, current);
                continue;
            }
            BIOrionObject o = (BIOrionObject)entry;
            for (int j = 0; j < props.length; ++j) {
                if (o.get(props[j]).equals((Object)current.get(props[j]))) continue;
                if (o.get(props[j]) instanceof BString && o.get(props[j]).toString().indexOf("; ") > -1) {
                    String[] split = TextUtil.split((String)o.get(props[j]).toString(), (char)';');
                    if (split.length > COALESCE_LIMIT) {
                        if (split[split.length - 1].equals(" ...")) continue;
                        o.set(props[j], (BValue)BString.make((String)("" + o.get(props[j]) + "; ...")));
                        continue;
                    }
                    boolean foundSplit = false;
                    String currentValue = current.get(props[j]).toString();
                    for (int k = 0; k < split.length; ++k) {
                        if (!split[k].trim().equals(currentValue)) continue;
                        foundSplit = true;
                    }
                    if (foundSplit) continue;
                    o.set(props[j], (BValue)BString.make((String)("" + o.get(props[j]) + "; " + currentValue)));
                    continue;
                }
                o.set(props[j], (BValue)BString.make((String)("" + o.get(props[j]) + "; " + current.get(props[j]))));
            }
            map.put(handle, o);
        }
        this.rows = coalesce ? map.values().toArray(new BIOrionObject[0]) : (BIOrionObject[])a.trim();
    }

    public static BDynamicTable ensureVisibleColumns(BDynamicTable table) {
        BDynamicTableColumn[] columns = table.getColumns();
        boolean allHidden = true;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getHiddenKey()) continue;
            allHidden = false;
            return table;
        }
        BDynamicTable copy = (BDynamicTable)table.newCopy();
        Property[] p = copy.getDynamicPropertiesArray();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].getType().is(BDynamicTableColumn.TYPE)) continue;
            copy.remove(p[i]);
        }
        copy.setResolveBase(table.getResolveBase());
        BDynamicTableColumn[] defaultColumns = table.getDefaultColumns();
        for (int i = 0; i < defaultColumns.length; ++i) {
            copy.add(defaultColumns[i].getColumnName(), defaultColumns[i].newCopy(), 2);
        }
        return copy;
    }

    public boolean getReachedMax() {
        return this.reachedMax;
    }
}

