/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.ui.BFieldSheet;
import com.tridium.orion.priv.ui.BTypeTable;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"orion:OrionType"}, requiredPermissions="R")})
public class BTypeTableView
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeTableView.class);
    private BTable table;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject o, Context cx) {
        BEdgePane main = new BEdgePane();
        OrionType type = ((BOrionType)o).getOrionType();
        this.table = new BTypeTable(this, (BOrionType)o);
        main.setCenter((BWidget)BTitlePane.makePane((String)type.getOrionTypeId().toString(), (BTable)this.table));
        BPermissions permissions = BPermissions.all;
        if (o instanceof BIProtected) {
            permissions = ((BIProtected)o).getPermissions(cx);
        }
        if (permissions.hasAdminWrite()) {
            BGridPane buttonPane = new BGridPane(3);
            BButton newButton = new BButton((Command)new NewCommand());
            buttonPane.add("new", (BValue)newButton);
            BButton deleteButton = new BButton(((BNiagaraWbShell)this.getShell()).commands.delete);
            buttonPane.add("delete", (BValue)deleteButton);
            main.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        }
        this.setContent((BWidget)main);
        this.setTransferWidget((BTransferWidget)this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newObject() {
        BOrionType btype = (BOrionType)this.getCurrentValue();
        OrionType type = btype.getOrionType();
        BOrionDatabase db = btype.getOrionDatabase();
        BFieldSheet fieldSheet = new BFieldSheet(0, db);
        BIOrionObject newObj = (BIOrionObject)type.getInstance();
        newObj.setOrionDatabase(db);
        fieldSheet.doLoadValue((BObject)newObj, this.getCurrentContext());
        String title = this.getType().getModule().getLexicon().getText("command.new.label") + " " + type.getTypeName();
        int rc = BDialog.open((BWidget)this, (String)title, (Object)((Object)fieldSheet), (int)3);
        if (rc == 2) {
            return;
        }
        try {
            newObj = (BIOrionObject)fieldSheet.saveValue((BObject)newObj, this.getCurrentContext());
        }
        catch (Exception ex) {
            throw new OrionException("Cannot create new object.", (Throwable)ex);
        }
        try (OrionSession session = db.createSession(null);){
            session.insert(newObj);
        }
        ((BTypeTable.Model)this.table.getModel()).load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjects() {
        String msg;
        Lexicon lex = this.getType().getModule().getLexicon();
        String title = lex.getText("command.delete.label");
        int rc = BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirm.deleteObjects")));
        if (rc == 8) {
            return;
        }
        TableSelection selection = this.table.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        int[] rows = selection.getRows();
        BIOrionObject[] toDelete = new BIOrionObject[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            toDelete[i] = (BIOrionObject)this.table.getModel().getSubject(rows[i]);
        }
        try (OrionSession session = ((BOrionType)this.getCurrentValue()).getOrionDatabase().createSession(null);){
            for (int i = 0; i < toDelete.length; ++i) {
                session.delete(toDelete[i]);
            }
        }
        ((BTypeTable.Model)this.table.getModel()).load();
    }

    private class NewCommand
    extends Command {
        public NewCommand() {
            super((BWidget)BTypeTableView.this, BTypeTableView.this.getType().getModule(), "command.new");
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            BTypeTableView.this.newObject();
            return null;
        }
    }
}

