/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.alarm;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="subscribed", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="lastEvent", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()"), @NiagaraProperty(name="lastSubscribed", type="BAbsTime", defaultValue="BAbsTime.NULL")})
@NiagaraActions(value={@NiagaraAction(name="subscribeForEvents", flags=16), @NiagaraAction(name="unsubscribeForEvents", flags=16)})
public class BOpcUaClientAlarmSource
extends BComponent
implements BIAlarmSource,
BIStatus {
    @Generated
    public static final Property status = BOpcUaClientAlarmSource.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl());
    @Generated
    public static final Property enabled = BOpcUaClientAlarmSource.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property uaNodeId = BOpcUaClientAlarmSource.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property subscribed = BOpcUaClientAlarmSource.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl());
    @Generated
    public static final Property lastEvent = BOpcUaClientAlarmSource.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property alarmSourceInfo = BOpcUaClientAlarmSource.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    @Generated
    public static final Property lastSubscribed = BOpcUaClientAlarmSource.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Action subscribeForEvents = BOpcUaClientAlarmSource.newAction((int)16, null);
    @Generated
    public static final Action unsubscribeForEvents = BOpcUaClientAlarmSource.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientAlarmSource.class);
    private AlarmSupport alarmSupport;
    private int oldStatus = 0;
    private BOpcUaDevice device;
    private BOpcUaClientAlarmDeviceExt alarmDeviceExt;
    private NodeId nodeId;
    private static final Logger logger = Logger.getLogger("opcUaClient.alarm");

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    @Generated
    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    @Generated
    public boolean getSubscribed() {
        return this.getBoolean(subscribed);
    }

    @Generated
    public void setSubscribed(boolean v) {
        this.setBoolean(subscribed, v, null);
    }

    @Generated
    public String getLastEvent() {
        return this.getString(lastEvent);
    }

    @Generated
    public void setLastEvent(String v) {
        this.setString(lastEvent, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSubscribed() {
        return (BAbsTime)this.get(lastSubscribed);
    }

    @Generated
    public void setLastSubscribed(BAbsTime v) {
        this.set(lastSubscribed, (BValue)v, null);
    }

    @Generated
    public void subscribeForEvents() {
        this.invoke(subscribeForEvents, null, null);
    }

    @Generated
    public void unsubscribeForEvents() {
        this.invoke(unsubscribeForEvents, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.device = this.getDevice();
        this.alarmDeviceExt = this.getAlarmDeviceExt();
        this.nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
        if (this.needsSubscription()) {
            this.doSubscribeForEvents();
            this.setLastSubscribed(BAbsTime.now());
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.doUnsubscribeForEvents();
    }

    public AlarmSupport getAlarmSupport() {
        return this.alarmSupport;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (p.equals(uaNodeId)) {
            this.nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
        }
        if (p.equals(enabled)) {
            this.updateEventAndStatus(this.getEnabled());
        } else if (p.equals(subscribed)) {
            this.updateStatus();
        }
    }

    private void updateEventAndStatus(boolean isSubscribeForEvents) {
        if (isSubscribeForEvents) {
            this.doSubscribeForEvents();
        } else {
            this.doUnsubscribeForEvents();
        }
        this.updateStatus();
    }

    public BOpcUaDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        BDevice dvc = this.getAlarmDeviceExt().getDevice();
        if (dvc instanceof BOpcUaDevice) {
            this.device = (BOpcUaDevice)dvc;
        }
        return this.device;
    }

    public BOpcUaClientAlarmDeviceExt getAlarmDeviceExt() {
        BComplex parent = this.getParent();
        if (parent instanceof BOpcUaClientAlarmDeviceExt) {
            return (BOpcUaClientAlarmDeviceExt)parent;
        }
        return null;
    }

    public void doSubscribeForEvents() {
        if (this.alarmDeviceExt == null) {
            return;
        }
        try {
            this.alarmDeviceExt.addMonitorEvent(this.nodeId);
            this.setSubscribed(this.alarmDeviceExt.isEventSubscribed(this.nodeId));
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when subscribing to an alarm event", e);
            }
            logger.log(Level.SEVERE, "Exception occurred when subscribing to an alarm event: " + e);
        }
    }

    public void doUnsubscribeForEvents() {
        try {
            this.alarmDeviceExt.removeMonitorEvent(this.nodeId);
            this.setSubscribed(this.alarmDeviceExt.isEventSubscribed(this.nodeId));
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when unsubscribing to an alarm event", e);
            }
            logger.log(Level.SEVERE, "Exception occurred when unsubscribing to an alarm event: " + e);
        }
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        try {
            return this.getAlarmDeviceExt().doAckAlarm(ackRequest);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when acknowledging an alarm event", e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred when acknowledging an alarm event: " + e);
            }
            return BBoolean.FALSE;
        }
    }

    public void setLastEvent(BOpcUaClientAlarmEntry lastEvent) {
        this.setLastEvent(BAbsTime.now() + " " + lastEvent.getAlarmMessage());
    }

    public void updateStatus() {
        BStatus device;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = device = this.device == null ? BStatus.ok : this.device.getStatus();
        newStatus = !this.getEnabled() || device.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = device.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    private boolean needsSubscription() {
        boolean subscribed = this.getSubscribed();
        if (!subscribed && this.getLastSubscribed() == BAbsTime.NULL) {
            BOpcUaClientAlarmDeviceExt alarmExt = this.device.getAlarmExt();
            subscribed = alarmExt.getAutoSubscribeEnable();
        }
        return subscribed;
    }
}

