/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.history;

import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.enums.BServerState;
import com.tridium.util.ThrowableUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BIHistoryPollable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BDescriptorState", defaultValue="BDescriptorState.idle", flags=1), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make())"), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="useServerTimestamp", type="BBoolean", defaultValue="BBoolean.make(false)", flags=4)})
@NiagaraAction(name="execute", flags=16)
public class BImportHistoryExt
extends BHistoryExt
implements BIHistoryPollable,
BIPollableHistorySource {
    @Generated
    public static final Property state = BImportHistoryExt.newProperty((int)1, (BValue)BDescriptorState.idle, null);
    @Generated
    public static final Property executionTime = BImportHistoryExt.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    @Generated
    public static final Property lastAttempt = BImportHistoryExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastSuccess = BImportHistoryExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailure = BImportHistoryExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property useServerTimestamp = BImportHistoryExt.newProperty((int)4, (boolean)((BBoolean)BBoolean.make((boolean)false).as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Action execute = BImportHistoryExt.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BImportHistoryExt.class);
    private BIHistory pointHistory;
    private HistoryDatabaseConnection dbConnection;
    private BOpcUaClientProxyExt proxyExt;
    private static final Logger logger = Logger.getLogger("opcUaClient.history");

    @Generated
    public BDescriptorState getState() {
        return (BDescriptorState)this.get(state);
    }

    @Generated
    public void setState(BDescriptorState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getExecutionTime() {
        return (BTimeTrigger)this.get(executionTime);
    }

    @Generated
    public void setExecutionTime(BTimeTrigger v) {
        this.set(executionTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    @Generated
    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    @Generated
    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    @Generated
    public boolean getUseServerTimestamp() {
        return this.getBoolean(useServerTimestamp);
    }

    @Generated
    public void setUseServerTimestamp(boolean v) {
        this.setBoolean(useServerTimestamp, v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.showSupportedProperties();
        this.setFlags((Slot)activePeriod, this.getFlags((Slot)activePeriod) | 4);
        this.setFlags((Slot)active, this.getFlags((Slot)active) | 4);
        this.add(null, (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
    }

    void showSupportedProperties() {
        this.setFlags((Slot)useServerTimestamp, this.getFlags((Slot)useServerTimestamp) & 0xFFFFFFFB);
    }

    public void pointChanged(BAbsTime timestamp, BStatusValue out) {
    }

    public BDeviceNetwork getNetwork() {
        BAbstractProxyExt abstractProxyExt = this.getParentPoint().getProxyExt();
        if (abstractProxyExt instanceof BProxyExt) {
            BProxyExt proxyExt = (BProxyExt)abstractProxyExt;
            return proxyExt.getNetwork();
        }
        return null;
    }

    public BDevice getDevice() {
        BAbstractProxyExt abstractProxyExt = this.getParentPoint().getProxyExt();
        if (abstractProxyExt instanceof BProxyExt) {
            BProxyExt proxyExt = (BProxyExt)abstractProxyExt;
            return proxyExt.getDevice();
        }
        return null;
    }

    public boolean requiresPointSubscription() {
        return false;
    }

    protected void activated(BAbsTime activeStartTime, BAbsTime currentTime, BStatusValue out) {
    }

    protected void deactivated(BAbsTime currentTime, BStatusValue out) {
    }

    public Type getRecordType() {
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            BStatusValue statusValue = point.getOutStatusValue();
            if (statusValue instanceof BStatusNumeric) {
                return BNumericTrendRecord.TYPE;
            }
            if (statusValue instanceof BStatusBoolean) {
                return BBooleanTrendRecord.TYPE;
            }
            if (statusValue instanceof BStatusEnum) {
                return BEnumTrendRecord.TYPE;
            }
            if (statusValue instanceof BStatusString) {
                return BStringTrendRecord.TYPE;
            }
        }
        return null;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        BDeviceNetwork network = this.getNetwork();
        return ((BOpcUaNetwork)network).postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
    }

    public void doExecute() {
        boolean networkDisabled;
        BStatus status = this.getStatus();
        BOpcUaDevice device = (BOpcUaDevice)this.getDevice();
        boolean devDisabled = device.isDisabled() || device.isFault() || device.isDown();
        boolean bl = networkDisabled = device.getOpcUaClientNetwork().isDisabled() || device.getOpcUaClientNetwork().isFault() || device.getOpcUaClientNetwork().isDown();
        if (status.isDisabled() || status.isDown() || status.isFault() || devDisabled || networkDisabled) {
            return;
        }
        if (!device.getServerState().equals((Object)BServerState.Running)) {
            this.executeFail("Server not running");
            return;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        this.dbConnection = db.getDbConnection(null);
        this.pointHistory = this.dbConnection.getHistory(this.getHistoryConfig().getId());
        if (this.proxyExt == null) {
            BAbstractProxyExt absProxyExt = this.getParentPoint().getProxyExt();
            if (!(absProxyExt instanceof BOpcUaClientProxyExt)) {
                return;
            }
            this.proxyExt = (BOpcUaClientProxyExt)absProxyExt;
        }
        this.executeInProgress();
        this.setLastAttempt(BAbsTime.now());
        DateTime startTime = DateTime.MIN_VALUE;
        try {
            BAbsTime lastTimestamp = this.dbConnection.getLastTimestamp(this.pointHistory);
            startTime = DateTime.fromMillis((long)OpcUaClientUtil.getModifiedStartTime(lastTimestamp, ((BOpcUaDevice)this.getDevice()).getInitialHistoryArchiveFromDate()).getMillis());
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Exception while getting last timestamp for PointHistory, using DateTime minimum", exception);
        }
        try {
            device.getHistories().importHistory(NodeId.parseNodeId((String)this.proxyExt.getUaNodeId()), device.uaClient, startTime, DateTime.currentTime(), this.pointHistory, this.dbConnection, this.getUseServerTimestamp());
            this.setLastRecord(this.dbConnection.getLastRecord(this.pointHistory));
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception while importing history records: " + exception, logger.isLoggable(Level.FINE) ? exception : null);
            this.executeFail(exception);
            return;
        }
        this.executeOk();
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail() {
        this.executeFail("");
    }

    public void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail(Throwable ex) {
        this.executeFail(ex == null ? "" : ThrowableUtil.dumpToString((Throwable)ex, (int)1));
    }

    public void executeInProgress() {
        this.setState(BDescriptorState.inProgress);
    }

    public void poll() {
    }

    public BPollFrequency getPollFrequency() {
        return null;
    }

    public boolean historyPollingEnabled() {
        return false;
    }

    public int updateHistorySubscriptionCount(int change) {
        return 0;
    }
}

