/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.history;

import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.enums.BServerState;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="localHistoryName", type="String", defaultValue="", flags=64, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="useServerTimestamp", type="BBoolean", defaultValue="BBoolean.make(false)", flags=4), @NiagaraProperty(name="uaNodeName", type="String", defaultValue="", flags=1, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="typeSpec", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL")})
public class BOpcUaClientHistoryImport
extends BHistoryImport {
    @Generated
    public static final Property localHistoryName = BOpcUaClientHistoryImport.newProperty((int)64, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property useServerTimestamp = BOpcUaClientHistoryImport.newProperty((int)4, (boolean)((BBoolean)BBoolean.make((boolean)false).as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Property uaNodeName = BOpcUaClientHistoryImport.newProperty((int)1, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property uaNodeId = BOpcUaClientHistoryImport.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property typeSpec = BOpcUaClientHistoryImport.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property facets = BOpcUaClientHistoryImport.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientHistoryImport.class);
    private BIHistory pointHistory;
    private HistoryDatabaseConnection dbConnection;
    public static final Logger logger = Logger.getLogger("opcUaClient.history");
    private static final String VALUE_FACETS = "valueFacets";

    @Generated
    public String getLocalHistoryName() {
        return this.getString(localHistoryName);
    }

    @Generated
    public void setLocalHistoryName(String v) {
        this.setString(localHistoryName, v, null);
    }

    @Generated
    public boolean getUseServerTimestamp() {
        return this.getBoolean(useServerTimestamp);
    }

    @Generated
    public void setUseServerTimestamp(boolean v) {
        this.setBoolean(useServerTimestamp, v, null);
    }

    @Generated
    public String getUaNodeName() {
        return this.getString(uaNodeName);
    }

    @Generated
    public void setUaNodeName(String v) {
        this.setString(uaNodeName, v, null);
    }

    @Generated
    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    @Generated
    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    @Generated
    public String getTypeSpec() {
        return this.getString(typeSpec);
    }

    @Generated
    public void setTypeSpec(String v) {
        this.setString(typeSpec, v, null);
    }

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BOpcUaDevice device() {
        return (BOpcUaDevice)this.getDeviceExt().getDevice();
    }

    public void started() throws Exception {
        BHistoryService service;
        BHistoryDatabase db;
        super.started();
        this.showSupportedProperties();
        Type rcdType = this.getHistoryRecordType();
        BHistoryId histId = BHistoryId.make((String)this.getDevice().getName(), (String)this.getDefaultName());
        this.setHistoryId(histId);
        Slot slot = this.getSlot("historyConfig");
        if (slot == null) {
            BHistoryConfig histConfig = new BHistoryConfig(histId, BTypeSpec.make((Type)rcdType));
            histConfig = this.makeLocalConfig(histConfig);
            try {
                this.add("historyConfig", (BValue)histConfig);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Exception while adding history config: " + exception, logger.isLoggable(Level.FINE) ? exception : null);
            }
        }
        if ((db = (service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()) == null) {
            return;
        }
        this.dbConnection = db.getDbConnection(null);
        if (this.dbConnection != null) {
            this.initHistory(histId);
        }
    }

    void showSupportedProperties() {
        this.setFlags((Slot)useServerTimestamp, this.getFlags((Slot)useServerTimestamp) & 0xFFFFFFFB);
    }

    private void initHistory(BHistoryId histId) {
        try {
            BHistoryConfig histConfig = (BHistoryConfig)this.get("historyConfig");
            histConfig.setTimeZone(BTimeZone.getLocal());
            BFacets facets = (BFacets)histConfig.get(VALUE_FACETS);
            if (facets != null) {
                histConfig.set(VALUE_FACETS, (BValue)this.getFacets());
            } else {
                histConfig.add(VALUE_FACETS, (BValue)this.getFacets());
            }
            if (!this.dbConnection.exists(histId)) {
                this.dbConnection.createHistory(histConfig);
            } else {
                this.dbConnection.reconfigureHistory(histConfig);
            }
            this.pointHistory = this.dbConnection.getHistory(histId);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception while initializing history records: " + exception, logger.isLoggable(Level.FINE) ? exception : null);
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        return ((BOpcUaNetwork)this.getNetwork()).postAsync((Runnable)new Invocation((BComponent)this, execute, arg, cx));
    }

    public void doExecute() throws ArchiveException {
        BOpcUaDevice device = this.device();
        if (!device.getServerState().equals((Object)BServerState.Running)) {
            this.executeFail("Server not running");
            return;
        }
        this.executeInProgress();
        DateTime startTime = DateTime.MIN_VALUE;
        try {
            BAbsTime lastTimestamp = this.dbConnection.getLastTimestamp(this.pointHistory);
            startTime = DateTime.fromMillis((long)OpcUaClientUtil.getModifiedStartTime(lastTimestamp, ((BOpcUaDevice)this.getDevice()).getInitialHistoryArchiveFromDate()).getMillis());
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Exception while getting last timestamp for PointHistory, using DateTime minimum", exception);
        }
        try {
            BHistoryId historyId = this.pointHistory.getId();
            if (this.dbConnection.getHistory(historyId) == null) {
                this.initHistory(historyId);
            }
            device.getHistories().importHistory(NodeId.parseNodeId((String)this.getUaNodeId()), device.uaClient, startTime, DateTime.currentTime(), this.pointHistory, this.dbConnection, this.getUseServerTimestamp());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception while importing history records: " + exception, logger.isLoggable(Level.FINE) ? exception : null);
            this.executeFail(exception);
            return;
        }
        this.executeOk();
    }

    private Type getHistoryRecordType() {
        String spec = this.getTypeSpec();
        if (spec.isEmpty()) {
            return null;
        }
        TypeInfo typeInfo = BTypeSpec.make((String)spec).getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            return BNumericTrendRecord.TYPE;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            return BBooleanTrendRecord.TYPE;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            return BEnumTrendRecord.TYPE;
        }
        if (typeInfo.is(BString.TYPE)) {
            return BStringTrendRecord.TYPE;
        }
        return null;
    }

    private String getDefaultName() {
        return this.getUaNodeName().replace('/', '_');
    }
}

