/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Attributes;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.point.BOpcUaClientPointDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaMonitoredDataItemUtil;
import java.util.logging.Level;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Lexicon;

public class PointUnsubscribeCmd
implements Runnable,
ICoalesceable {
    private static final Lexicon LEX = Lexicon.make(PointUnsubscribeCmd.class);
    private BOpcUaDevice device;
    private BOpcUaClientPointDeviceExt deviceExt;
    private NodeId nodeId;
    private BOpcUaClientProxyExt proxyExt;

    private PointUnsubscribeCmd() {
    }

    public PointUnsubscribeCmd(BOpcUaDevice device, BOpcUaClientPointDeviceExt deviceExt, NodeId nodeId, BOpcUaClientProxyExt proxyExt) {
        this.device = device;
        this.deviceExt = deviceExt;
        this.nodeId = nodeId;
        this.proxyExt = proxyExt;
    }

    @Override
    public void run() {
        block4: {
            Subscription subscription = this.deviceExt.getSubscription();
            if (subscription != null) {
                try {
                    PointUnsubscribeCmd.unsubscribe(subscription, this.proxyExt, this.nodeId);
                }
                catch (Exception e) {
                    if (BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINER)) {
                        BOpcUaClientProxyExt.rdlogger.log(Level.FINER, "Unsubscribe failed: ", e);
                    }
                    if (!BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINE)) break block4;
                    BOpcUaClientProxyExt.rdlogger.log(Level.FINE, "Unsubscribe failed: " + e.getLocalizedMessage());
                }
            }
        }
    }

    private static void unsubscribe(Subscription subscription, BOpcUaClientProxyExt proxyExt, NodeId nodeId) throws Exception {
        MonitoredDataItem item = (MonitoredDataItem)subscription.getItem(nodeId, Attributes.Value);
        if (item != null && item.getDataChangeListener() != null) {
            if (BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINEST)) {
                BOpcUaClientProxyExt.rdlogger.log(Level.FINEST, "Removing listener for: " + nodeId);
            }
            OpcUaMonitoredDataItemUtil.unsubscribe(subscription, item, proxyExt, nodeId, Attributes.Value);
        }
        proxyExt.setMonitoredItem(null);
    }

    public int hashCode() {
        return this.proxyExt.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PointUnsubscribeCmd) {
            PointUnsubscribeCmd o = (PointUnsubscribeCmd)object;
            return this.proxyExt.equals((Object)o.proxyExt);
        }
        return false;
    }

    public String toString() {
        StringBuilder cmdString = new StringBuilder();
        cmdString.append("PointUnsubscribeCmd (pointDeviceExt=").append((Object)this.deviceExt);
        cmdString.append(", opcUaDevice=").append((Object)this.device);
        cmdString.append(", proxyExt=").append((Object)this.proxyExt);
        cmdString.append(", nodeId=").append(this.nodeId).append(')');
        return cmdString.toString();
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }
}

